/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.csv;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.csv.CsvIterator;
import org.apache.camel.dataformat.csv.CsvLineConverter;
import org.apache.camel.dataformat.csv.CsvLineConverters;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVStrategy;
import org.apache.commons.csv.writer.CSVConfig;
import org.apache.commons.csv.writer.CSVField;
import org.apache.commons.csv.writer.CSVWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvDataFormat
implements DataFormat {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvDataFormat.class);
    private CSVStrategy strategy = CsvDataFormat.cloneCSVStrategyIfNecessary(CSVStrategy.DEFAULT_STRATEGY);
    private CSVConfig config = new CSVConfig();
    private boolean autogenColumns = true;
    private String delimiter;
    private boolean skipFirstLine;
    private boolean lazyLoad;
    private boolean useMaps;

    private static CSVStrategy cloneCSVStrategyIfNecessary(CSVStrategy csvStrategy) {
        for (Field field : CSVStrategy.class.getFields()) {
            try {
                if (field.get(null) != csvStrategy) continue;
                LOGGER.debug("Returning a clone of {} as it is the declared constant {} by the CSVStrategy class", (Object)csvStrategy, (Object)field.getName());
                return (CSVStrategy)csvStrategy.clone();
            }
            catch (Exception e) {
                ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
        return csvStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object object, OutputStream outputStream) throws Exception {
        if (this.delimiter != null) {
            this.config.setDelimiter(this.delimiter.charAt(0));
        }
        OutputStreamWriter out = new OutputStreamWriter(outputStream, IOHelper.getCharsetName((Exchange)exchange));
        CSVWriter csv = new CSVWriter(this.config);
        csv.setWriter((Writer)out);
        try {
            List list = (List)ExchangeHelper.convertToType((Exchange)exchange, List.class, (Object)object);
            if (list != null) {
                for (Object child : list) {
                    Map row = (Map)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Map.class, child);
                    this.doMarshalRecord(exchange, row, out, csv);
                }
            } else {
                Map row = (Map)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Map.class, (Object)object);
                this.doMarshalRecord(exchange, row, out, csv);
            }
        }
        finally {
            IOHelper.close((Closeable)out);
        }
    }

    private void doMarshalRecord(Exchange exchange, Map<?, ?> row, Writer out, CSVWriter csv) throws Exception {
        if (this.autogenColumns) {
            Set<?> set = row.keySet();
            this.updateFieldsInConfig(set, exchange);
        }
        csv.writeRecord(row);
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        CsvIterator<List<String>> csvIterator;
        block12: {
            if (this.delimiter != null) {
                this.config.setDelimiter(this.delimiter.charAt(0));
            }
            this.strategy.setDelimiter(this.config.getDelimiter());
            BufferedReader reader = null;
            boolean error = false;
            try {
                CsvLineConverter<Object> lineConverter;
                reader = IOHelper.buffered((Reader)new InputStreamReader(inputStream, IOHelper.getCharsetName((Exchange)exchange)));
                CSVParser parser = new CSVParser((Reader)reader, this.strategy);
                if (this.skipFirstLine) {
                    parser.getLine();
                }
                if (this.useMaps) {
                    String[] fieldS;
                    CSVField[] fields = this.config.getFields();
                    if (fields != null && fields.length > 0) {
                        fieldS = new String[fields.length];
                        for (int i = 0; i < fields.length; ++i) {
                            fieldS[i] = fields[i].getName();
                        }
                    } else {
                        fieldS = parser.getLine();
                    }
                    lineConverter = CsvLineConverters.getMapLineConverter(fieldS);
                } else {
                    lineConverter = CsvLineConverters.getListConverter();
                }
                CsvIterator<List<String>> csvIterator2 = new CsvIterator<List<String>>(parser, reader, lineConverter);
                CsvIterator<List<String>> csvIterator3 = csvIterator = this.lazyLoad ? csvIterator2 : this.loadAllAsList(csvIterator2);
                if (!error) break block12;
            }
            catch (Exception e) {
                try {
                    error = true;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (error) {
                        IOHelper.close(reader);
                    }
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)reader);
        }
        return csvIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> loadAllAsList(CsvIterator<T> iter) {
        try {
            ArrayList<T> list = new ArrayList<T>();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            IOHelper.close(iter);
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        if (delimiter != null && delimiter.length() > 1) {
            throw new IllegalArgumentException("Delimiter must have a length of one!");
        }
        this.delimiter = delimiter;
    }

    public CSVConfig getConfig() {
        return this.config;
    }

    public void setConfig(CSVConfig config) {
        this.config = config;
    }

    public CSVStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(CSVStrategy strategy) {
        this.strategy = CsvDataFormat.cloneCSVStrategyIfNecessary(strategy);
    }

    public boolean isAutogenColumns() {
        return this.autogenColumns;
    }

    public void setAutogenColumns(boolean autogenColumns) {
        this.autogenColumns = autogenColumns;
    }

    public boolean isSkipFirstLine() {
        return this.skipFirstLine;
    }

    public void setSkipFirstLine(boolean skipFirstLine) {
        this.skipFirstLine = skipFirstLine;
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    public boolean isUseMaps() {
        return this.useMaps;
    }

    public void setUseMaps(boolean useMaps) {
        this.useMaps = useMaps;
    }

    private synchronized void updateFieldsInConfig(Set<?> set, Exchange exchange) {
        for (Object value : set) {
            String text;
            if (value == null || this.config.getField(text = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value)) != null) continue;
            CSVField field = new CSVField(text);
            this.config.addField(field);
        }
    }
}

