/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.dataformat.csv.CsvDataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

abstract class CsvMarshaller {
    private final CSVFormat format;

    private CsvMarshaller(CSVFormat format) {
        this.format = format;
    }

    public static CsvMarshaller create(CSVFormat format, CsvDataFormat dataFormat) {
        String[] fixedColumns;
        if (format.getSkipHeaderRecord()) {
            format = format.withHeader((String[])null);
        }
        if ((fixedColumns = dataFormat.getHeader()) != null && fixedColumns.length > 0) {
            return new FixedColumnsMarshaller(format, fixedColumns);
        }
        return new DynamicColumnsMarshaller(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object object, OutputStream outputStream) throws NoTypeConversionAvailableException, IOException {
        CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter(outputStream), this.format);
        try {
            Iterator it = ObjectHelper.createIterator((Object)object);
            while (it.hasNext()) {
                Object child = it.next();
                printer.printRecord(this.getRecordValues(exchange, child));
            }
        }
        finally {
            IOHelper.close((Closeable)printer);
        }
    }

    private Iterable<?> getRecordValues(Exchange exchange, Object data) throws NoTypeConversionAvailableException {
        Map map = (Map)exchange.getContext().getTypeConverter().tryConvertTo(Map.class, exchange, data);
        if (map != null) {
            return this.getMapRecordValues(map);
        }
        return (Iterable)ExchangeHelper.convertToMandatoryType((Exchange)exchange, List.class, (Object)data);
    }

    protected abstract Iterable<?> getMapRecordValues(Map<?, ?> var1);

    private static final class DynamicColumnsMarshaller
    extends CsvMarshaller {
        private final LinkedHashSet<Object> columns = new LinkedHashSet();

        private DynamicColumnsMarshaller(CSVFormat format) {
            super(format);
        }

        @Override
        protected Iterable<?> getMapRecordValues(Map<?, ?> map) {
            this.columns.addAll(map.keySet());
            ArrayList result = new ArrayList(this.columns.size());
            for (Object e : this.columns) {
                result.add(map.get(e));
            }
            return result;
        }
    }

    private static final class FixedColumnsMarshaller
    extends CsvMarshaller {
        private final String[] fixedColumns;

        private FixedColumnsMarshaller(CSVFormat format, String[] fixedColumns) {
            super(format);
            this.fixedColumns = Arrays.copyOf(fixedColumns, fixedColumns.length);
        }

        @Override
        protected Iterable<?> getMapRecordValues(Map<?, ?> map) {
            ArrayList result = new ArrayList(this.fixedColumns.length);
            for (String key : this.fixedColumns) {
                result.add(map.get(key));
            }
            return result;
        }
    }
}

