/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.common.header.CxfHeaderHelper;
import org.apache.camel.component.cxf.common.message.DefaultCxfMesssageMapper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelDestination
extends AbstractDestination
implements Configurable {
    protected static final String BASE_BEAN_NAME_SUFFIX = ".camel-destination";
    private static final Logger LOG = LoggerFactory.getLogger(CamelDestination.class);
    private static final java.util.logging.Logger JUL_LOG = LogUtils.getL7dLogger(CamelDestination.class);
    final ConduitInitiator conduitInitiator;
    CamelContext camelContext;
    Consumer consumer;
    String camelDestinationUri;
    private Endpoint destinationEndpoint;
    private HeaderFilterStrategy headerFilterStrategy;
    private boolean checkException;

    public CamelDestination(CamelContext camelContext, Bus bus, ConduitInitiator ci, EndpointInfo info) throws IOException {
        this(camelContext, bus, ci, info, null, false);
    }

    public CamelDestination(CamelContext camelContext, Bus bus, ConduitInitiator ci, EndpointInfo info, HeaderFilterStrategy headerFilterStrategy, boolean checkException) throws IOException {
        super(bus, CamelDestination.getTargetReference((EndpointInfo)info, (Bus)bus), info);
        this.camelContext = camelContext;
        this.conduitInitiator = ci;
        this.camelDestinationUri = this.endpointInfo.getAddress().substring("camel:".length());
        if (this.camelDestinationUri.startsWith("//")) {
            this.camelDestinationUri = this.camelDestinationUri.substring(2);
        }
        this.initConfig();
        this.headerFilterStrategy = headerFilterStrategy;
        this.checkException = checkException;
    }

    protected java.util.logging.Logger getLogger() {
        return JUL_LOG;
    }

    public void setCheckException(boolean exception) {
        this.checkException = exception;
    }

    public boolean isCheckException() {
        return this.checkException;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        return new BackChannelConduit(inMessage);
    }

    public void activate() {
        LOG.debug("CamelDestination activate().... ");
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        try {
            LOG.debug("establishing Camel connection");
            this.destinationEndpoint = this.getCamelContext().getEndpoint(this.camelDestinationUri);
            if (this.destinationEndpoint == null) {
                throw new NoSuchEndpointException(this.camelDestinationUri);
            }
            this.consumer = this.destinationEndpoint.createConsumer((Processor)new ConsumerProcessor());
            ServiceHelper.startService((Object)this.consumer);
        }
        catch (NoSuchEndpointException nex) {
            throw nex;
        }
        catch (Exception ex) {
            if (this.destinationEndpoint == null) {
                throw new FailedToCreateConsumerException(this.camelDestinationUri, (Throwable)ex);
            }
            throw new FailedToCreateConsumerException(this.destinationEndpoint, (Throwable)ex);
        }
    }

    public void deactivate() {
        try {
            ServiceHelper.stopService((Object)this.consumer);
        }
        catch (Exception e) {
            LOG.warn("Error stopping consumer", (Throwable)e);
        }
    }

    public void shutdown() {
        LOG.debug("CamelDestination shutdown()");
        this.deactivate();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void incoming(Exchange camelExchange) {
        LOG.debug("server received request: ", (Object)camelExchange);
        DefaultCxfMesssageMapper beanBinding = new DefaultCxfMesssageMapper();
        Message inMessage = beanBinding.createCxfMessageFromCamelExchange(camelExchange, this.headerFilterStrategy);
        inMessage.put((Object)"org.apache.camel.exchange", (Object)camelExchange);
        ((MessageImpl)inMessage).setDestination((Destination)this);
        this.incomingObserver.onMessage(inMessage);
    }

    public String getBeanName() {
        if (this.endpointInfo == null || this.endpointInfo.getName() == null) {
            return "default.camel-destination";
        }
        return this.endpointInfo.getName().toString() + BASE_BEAN_NAME_SUFFIX;
    }

    public String getCamelDestinationUri() {
        return this.camelDestinationUri;
    }

    private void initConfig() {
        Configurer configurer;
        if (this.bus != null && null != (configurer = (Configurer)this.bus.getExtension(Configurer.class))) {
            configurer.configureBean((Object)this);
        }
    }

    protected boolean markPartialResponse(Message partialResponse, EndpointReferenceType decoupledTarget) {
        return true;
    }

    protected ConduitInitiator getConduitInitiator() {
        return this.conduitInitiator;
    }

    protected void propagateResponseHeadersToCamel(Message outMessage, Exchange camelExchange) {
        CxfHeaderHelper.propagateCxfToCamel(this.headerFilterStrategy, outMessage, camelExchange.getOut().getHeaders(), camelExchange);
    }

    private class CamelOutputStream
    extends CachedOutputStream {
        private Message outMessage;

        public CamelOutputStream(Message m) {
            this.outMessage = m;
        }

        private void commitOutputMessage() throws IOException {
            Exchange camelExchange = (Exchange)this.outMessage.get((Object)"org.apache.camel.exchange");
            CamelDestination.this.propagateResponseHeadersToCamel(this.outMessage, camelExchange);
            Exception exception = (Exception)this.outMessage.getContent(Exception.class);
            if (CamelDestination.this.checkException && exception != null) {
                camelExchange.setException((Throwable)exception);
            }
            CachedOutputStream outputStream = (CachedOutputStream)this.outMessage.getContent(OutputStream.class);
            camelExchange.getOut().setBody((Object)outputStream.getInputStream());
            LOG.debug("send the response message: {}", (Object)outputStream);
        }

        protected void doFlush() throws IOException {
        }

        protected void doClose() throws IOException {
            this.commitOutputMessage();
        }

        protected void onWrite() throws IOException {
        }
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected Message inMessage;
        Exchange camelExchange;
        org.apache.cxf.message.Exchange cxfExchange;

        BackChannelConduit(Message message) {
            super(EndpointReferenceUtils.getAnonymousEndpointReference());
            this.inMessage = message;
            this.cxfExchange = this.inMessage.getExchange();
            this.camelExchange = (Exchange)this.cxfExchange.get(Exchange.class);
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void prepare(Message message) throws IOException {
            message.put((Object)"org.apache.camel.exchange", this.inMessage.get((Object)"org.apache.camel.exchange"));
            message.setContent(OutputStream.class, (Object)new CamelOutputStream(message));
        }

        protected java.util.logging.Logger getLogger() {
            return JUL_LOG;
        }
    }

    protected class ConsumerProcessor
    implements Processor {
        protected ConsumerProcessor() {
        }

        public void process(Exchange exchange) {
            try {
                CamelDestination.this.incoming(exchange);
            }
            catch (Throwable ex) {
                exchange.setException(ex);
            }
        }
    }
}

