/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.component.cxf.MessageHeaderFilter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.headers.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMessageHeaderFilter
implements MessageHeaderFilter {
    private static final Log LOG = LogFactory.getLog(SoapMessageHeaderFilter.class);
    private static final List<String> ACTIVATION_NS = Arrays.asList("http://schemas.xmlsoap.org/soap/", "http://schemas.xmlsoap.org/wsdl/soap/", "http://schemas.xmlsoap.org/wsdl/soap12/");

    @Override
    public List<String> getActivationNamespaces() {
        return ACTIVATION_NS;
    }

    @Override
    public void filter(HeaderFilterStrategy.Direction direction, List<Header> headers) {
        if (headers == null) {
            return;
        }
        Iterator<Header> iterator = headers.iterator();
        block0: while (iterator.hasNext()) {
            Header header = iterator.next();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Processing header: " + header));
            }
            if (!(header instanceof SoapHeader)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Skipped header: " + header + " since it is not a SoapHeader"));
                continue;
            }
            SoapHeader soapHeader = (SoapHeader)SoapHeader.class.cast(header);
            Iterator itv = SoapVersionFactory.getInstance().getVersions();
            while (itv.hasNext()) {
                SoapVersion version = (SoapVersion)itv.next();
                if (soapHeader.getActor() == null || !soapHeader.getActor().equals(version.getNextRole())) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Filtered header: " + header));
                }
                iterator.remove();
                continue block0;
            }
        }
    }
}

