/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.spring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.camel.component.cxf.spring.AbstractCxfBeanDefinitionParser;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfEndpointBeanDefinitionParser
extends AbstractCxfBeanDefinitionParser {
    protected Class<?> getBeanClass(Element arg0) {
        return CxfSpringEndpointBean.class;
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, Element e, String name, String val) {
        if ("endpointName".equals(name) || "serviceName".equals(name)) {
            QName q = this.parseQName(e, val);
            bean.addPropertyValue(name, (Object)q);
        } else {
            this.mapToProperty(bean, name, val);
        }
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element el, String name) {
        if ("properties".equals(name)) {
            Map map = ctx.getDelegate().parseMapElement(el, (BeanDefinition)bean.getBeanDefinition());
            Map<String, Object> props = this.getPropertyMap(bean, false);
            if (props != null) {
                map.putAll(props);
            }
            bean.addPropertyValue("properties", (Object)map);
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name) || "schemaLocations".equals(name) || "handlers".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }

    public static class CxfSpringEndpointBean
    extends CxfEndpointBean
    implements ApplicationContextAware {
        private ApplicationContext applicationContext;

        public CxfSpringEndpointBean() {
        }

        public CxfSpringEndpointBean(ReflectionServiceFactoryBean factory) {
            super(factory);
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            this.applicationContext = ctx;
            if (this.getBus() == null) {
                SpringBusFactory factory = new SpringBusFactory(ctx);
                Bus bus = factory.createBus();
                this.setBus(bus);
            }
            BusWiringBeanFactoryPostProcessor.updateBusReferencesInContext((Bus)this.getBus(), (ApplicationContext)ctx);
        }

        public ApplicationContext getApplicationContext() {
            return this.applicationContext;
        }
    }
}

