/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfClientCallback
extends ClientCallback {
    private static final Logger LOG = LoggerFactory.getLogger(CxfClientCallback.class);
    private final AsyncCallback camelAsyncCallback;
    private final Exchange camelExchange;
    private final org.apache.cxf.message.Exchange cxfExchange;
    private final BindingOperationInfo boi;
    private final CxfBinding binding;

    public CxfClientCallback(AsyncCallback callback, Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange, BindingOperationInfo boi, CxfBinding binding) {
        this.camelAsyncCallback = callback;
        this.camelExchange = camelExchange;
        this.cxfExchange = cxfExchange;
        this.boi = boi;
        this.binding = binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(Map<String, Object> ctx, Object[] res) {
        try {
            super.handleResponse(ctx, res);
        }
        finally {
            if (!this.boi.getOperationInfo().isOneWay()) {
                this.camelExchange.getOut().getHeaders().putAll(this.camelExchange.getIn().getHeaders());
                this.binding.populateExchangeFromCxfResponse(this.camelExchange, this.cxfExchange, ctx);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} calling handleResponse", (Object)Thread.currentThread().getName());
            }
            this.camelAsyncCallback.done(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Map<String, Object> ctx, Throwable ex) {
        try {
            super.handleException(ctx, ex);
            this.camelExchange.setException(ex);
        }
        finally {
            if (!this.boi.getOperationInfo().isOneWay()) {
                this.camelExchange.getOut().getHeaders().putAll(this.camelExchange.getIn().getHeaders());
                this.binding.populateExchangeFromCxfResponse(this.camelExchange, this.cxfExchange, ctx);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} calling handleException", (Object)Thread.currentThread().getName());
            }
            this.camelAsyncCallback.done(false);
        }
    }
}

