/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.blueprint;

import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.camel.component.cxf.CxfBlueprintEndpoint;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.blueprint.AbstractBPBeanDefinitionParser;
import org.apache.cxf.helpers.DOMUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EndpointDefinitionParser
extends AbstractBPBeanDefinitionParser {
    public static String getIdOrName(Element elem) {
        StringTokenizer st;
        String names;
        String id = elem.getAttribute("id");
        if ((null == id || "".equals(id)) && null != (names = elem.getAttribute("name")) && (st = new StringTokenizer(names, ",")).countTokens() > 0) {
            id = st.nextToken();
        }
        return id;
    }

    public Metadata parse(Element element, ParserContext context) {
        MutableBeanMetadata endpointConfig = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        endpointConfig.setRuntimeClass(CxfBlueprintEndpoint.class);
        endpointConfig.addProperty("blueprintContainer", (Metadata)EndpointDefinitionParser.createRef((ParserContext)context, (String)"blueprintContainer"));
        endpointConfig.addProperty("bundleContext", (Metadata)EndpointDefinitionParser.createRef((ParserContext)context, (String)"blueprintBundleContext"));
        if (!StringUtils.isEmpty((String)EndpointDefinitionParser.getIdOrName(element))) {
            endpointConfig.setId(EndpointDefinitionParser.getIdOrName(element));
        } else {
            endpointConfig.setId("camel.cxf.endpoint." + context.generateId());
        }
        NamedNodeMap atts = element.getAttributes();
        String bus = null;
        String address = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr node = (Attr)atts.item(i);
            String val = node.getValue();
            String pre = node.getPrefix();
            String name = node.getLocalName();
            if ("bus".equals(name)) {
                bus = val;
                continue;
            }
            if ("address".equals(name)) {
                address = val;
                continue;
            }
            if (!this.isAttribute(pre, name)) continue;
            if ("endpointName".equals(name) || "serviceName".equals(name)) {
                QName q = this.parseQName(element, val);
                endpointConfig.addProperty(name, this.createValue(context, q));
                continue;
            }
            if ("depends-on".equals(name)) {
                endpointConfig.addDependsOn(val);
                continue;
            }
            if ("name".equals(name)) continue;
            endpointConfig.addProperty(name, (Metadata)AbstractBPBeanDefinitionParser.createValue((ParserContext)context, (String)val));
        }
        Element elem = DOMUtils.getFirstElement((Node)element);
        while (elem != null) {
            String name = elem.getLocalName();
            if ("properties".equals(name)) {
                Metadata map = this.parseMapData(context, (ComponentMetadata)endpointConfig, elem);
                endpointConfig.addProperty(name, map);
            } else if ("binding".equals(name)) {
                this.setFirstChildAsProperty(element, context, endpointConfig, "bindingConfig");
            } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name) || "schemaLocations".equals(name) || "handlers".equals(name)) {
                Metadata list = this.parseListData(context, (ComponentMetadata)endpointConfig, elem);
                endpointConfig.addProperty(name, list);
            } else {
                this.setFirstChildAsProperty(element, context, endpointConfig, name);
            }
            elem = DOMUtils.getNextElement((Element)elem);
        }
        if (StringUtils.isEmpty(bus)) {
            bus = "cxf";
        }
        endpointConfig.addProperty("bus", (Metadata)this.getBusRef(context, bus));
        endpointConfig.setDestroyMethod("destroy");
        endpointConfig.addArgument((Metadata)AbstractBPBeanDefinitionParser.createValue((ParserContext)context, address), String.class.getName(), 0);
        endpointConfig.addArgument((Metadata)EndpointDefinitionParser.createRef((ParserContext)context, (String)"blueprintBundleContext"), BundleContext.class.getName(), 1);
        return endpointConfig;
    }

    public static class PassThroughCallable<T>
    implements Callable<T> {
        private T value;

        public PassThroughCallable(T value) {
            this.value = value;
        }

        @Override
        public T call() throws Exception {
            return this.value;
        }
    }
}

