/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.cxfbean;

import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.cxfbean.CxfBeanComponent;
import org.apache.camel.component.cxf.cxfbean.CxfBeanEndpoint;
import org.apache.camel.component.cxf.transport.CamelDestination;
import org.apache.cxf.Bus;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfBeanDestination
extends CamelDestination
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(CxfBeanDestination.class);
    private CxfBeanComponent cxfBeanComponent;
    private CxfBeanEndpoint endpoint;

    public CxfBeanDestination(CxfBeanComponent cxfBeanComponent, Bus bus, ConduitInitiator conduitInitiator, EndpointInfo endpointInfo) throws IOException {
        super(cxfBeanComponent.getCamelContext(), bus, conduitInitiator, endpointInfo);
        this.cxfBeanComponent = cxfBeanComponent;
    }

    @Override
    public void activate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Activating CxfBeanDestination {}", (Object)this.getCamelDestinationUri());
        }
        this.endpoint = this.cxfBeanComponent.getEndpoint(this.getCamelDestinationUri());
        if (this.endpoint == null) {
            LOG.error("Failed to find endpoint " + this.getCamelDestinationUri());
            return;
        }
        this.endpoint.setProcessor(this);
    }

    @Override
    public void deactivate() {
    }

    public void process(Exchange camelExchange) throws Exception {
        LOG.trace("Received request : {}", (Object)camelExchange);
        Message cxfMessage = this.endpoint.getCxfBeanBinding().createCxfMessageFromCamelExchange(camelExchange, this.endpoint.getHeaderFilterStrategy());
        cxfMessage.put((Object)"org.apache.camel.exchange", (Object)camelExchange);
        ((MessageImpl)cxfMessage).setDestination((Destination)this);
        this.incomingObserver.onMessage(cxfMessage);
    }

    @Override
    protected void propagateResponseHeadersToCamel(Message outMessage, Exchange camelExchange) {
        this.endpoint.getCxfBeanBinding().propagateResponseHeadersToCamel(outMessage, camelExchange, this.endpoint.getHeaderFilterStrategy());
    }
}

