/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;
import org.apache.cxf.message.MessageContentsList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCxfRsBinding
implements CxfRsBinding,
HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCxfRsBinding.class);
    protected Map<String, String> camelToCxfHeaderMap = new HashMap<String, String>();
    protected Map<String, String> cxfToCamelHeaderMap = new HashMap<String, String>();
    private HeaderFilterStrategy headerFilterStrategy;

    public DefaultCxfRsBinding() {
        this.camelToCxfHeaderMap.put("CamelHttpUri", "org.apache.cxf.request.uri");
        this.camelToCxfHeaderMap.put("CamelHttpMethod", "org.apache.cxf.request.method");
        this.camelToCxfHeaderMap.put("CamelHttpPath", org.apache.cxf.message.Message.PATH_INFO);
        this.camelToCxfHeaderMap.put("Content-Type", "Content-Type");
        this.camelToCxfHeaderMap.put("CamelHttpCharacterEncoding", org.apache.cxf.message.Message.ENCODING);
        this.camelToCxfHeaderMap.put("CamelHttpQuery", org.apache.cxf.message.Message.QUERY_STRING);
        this.camelToCxfHeaderMap.put("CamelAcceptContentType", "Accept");
        this.cxfToCamelHeaderMap.put("org.apache.cxf.request.uri", "CamelHttpUri");
        this.cxfToCamelHeaderMap.put("org.apache.cxf.request.method", "CamelHttpMethod");
        this.cxfToCamelHeaderMap.put(org.apache.cxf.message.Message.PATH_INFO, "CamelHttpPath");
        this.cxfToCamelHeaderMap.put("Content-Type", "Content-Type");
        this.cxfToCamelHeaderMap.put(org.apache.cxf.message.Message.ENCODING, "CamelHttpCharacterEncoding");
        this.cxfToCamelHeaderMap.put(org.apache.cxf.message.Message.QUERY_STRING, "CamelHttpQuery");
        this.cxfToCamelHeaderMap.put("Accept", "CamelAcceptContentType");
    }

    @Override
    public Object populateCxfRsResponseFromExchange(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) throws Exception {
        if (camelExchange.isFailed()) {
            throw camelExchange.getException();
        }
        return camelExchange.getOut().getBody();
    }

    @Override
    public void populateExchangeFromCxfRsRequest(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange, Method method, Object[] paramArray) {
        Message camelMessage = camelExchange.getIn();
        org.apache.cxf.message.Message cxfMessage = cxfExchange.getInMessage();
        this.copyMessageHeader(cxfMessage, camelMessage, "org.apache.cxf.request.uri", "CamelHttpUri");
        this.copyMessageHeader(cxfMessage, camelMessage, "org.apache.cxf.request.method", "CamelHttpMethod");
        String pathInfo = (String)cxfMessage.get((Object)org.apache.cxf.message.Message.PATH_INFO);
        String basePath = (String)cxfMessage.get((Object)org.apache.cxf.message.Message.BASE_PATH);
        if (pathInfo != null && basePath != null && pathInfo.startsWith(basePath)) {
            pathInfo = pathInfo.substring(basePath.length());
        }
        if (pathInfo != null) {
            camelMessage.setHeader("CamelHttpPath", (Object)pathInfo);
        }
        this.copyMessageHeader(cxfMessage, camelMessage, "Content-Type", "Content-Type");
        this.copyMessageHeader(cxfMessage, camelMessage, org.apache.cxf.message.Message.ENCODING, "CamelHttpCharacterEncoding");
        this.copyMessageHeader(cxfMessage, camelMessage, org.apache.cxf.message.Message.QUERY_STRING, "CamelHttpQuery");
        this.copyMessageHeader(cxfMessage, camelMessage, "Accept", "CamelAcceptContentType");
        this.copyProtocolHeader(cxfMessage, camelMessage, camelMessage.getExchange());
        camelMessage.setHeader("CamelCxfRsResponseClass", method.getReturnType());
        camelMessage.setHeader("CamelCxfRsResponseGenericType", (Object)method.getGenericReturnType());
        this.copyOperationResourceInfoStack(cxfMessage, camelMessage);
        camelMessage.setHeader("operationName", (Object)method.getName());
        camelMessage.setBody((Object)new MessageContentsList(paramArray));
    }

    @Override
    public MultivaluedMap<String, String> bindCamelHeadersToRequestHeaders(Map<String, Object> camelHeaders, Exchange camelExchange) throws Exception {
        MetadataMap answer = new MetadataMap();
        for (Map.Entry<String, Object> entry : camelHeaders.entrySet()) {
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), camelExchange)) {
                LOG.trace("Drop Camel header: {}={}", (Object)entry.getKey(), entry.getValue());
                continue;
            }
            String mappedHeaderName = this.camelToCxfHeaderMap.get(entry.getKey());
            if (mappedHeaderName == null) {
                mappedHeaderName = entry.getKey();
            }
            LOG.trace("Propagate Camel header: {}={} as {}", new Object[]{entry.getKey(), entry.getValue(), mappedHeaderName});
            answer.putSingle((Object)mappedHeaderName, (Object)entry.getValue().toString());
        }
        return answer;
    }

    @Override
    public Object bindCamelMessageBodyToRequestBody(Message camelMessage, Exchange camelExchange) throws Exception {
        Object request = camelMessage.getBody(MessageContentsList.class);
        if (request != null) {
            return ((MessageContentsList)request).get(0);
        }
        request = camelMessage.getBody();
        if (request instanceof List) {
            request = ((List)request).get(0);
        } else if (request != null && request.getClass().isArray()) {
            request = ((Object[])request)[0];
        }
        return request;
    }

    @Override
    public Map<String, Object> bindResponseHeadersToCamelHeaders(Object response, Exchange camelExchange) throws Exception {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        if (response instanceof Response) {
            for (Map.Entry entry : ((Response)response).getMetadata().entrySet()) {
                if (!this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), camelExchange)) {
                    String mappedHeaderName = this.cxfToCamelHeaderMap.get(entry.getKey());
                    if (mappedHeaderName == null) {
                        mappedHeaderName = (String)entry.getKey();
                    }
                    LOG.trace("Populate external header {}={} as {}", new Object[]{entry.getKey(), entry.getValue(), mappedHeaderName});
                    answer.put(mappedHeaderName, ((List)entry.getValue()).get(0));
                    continue;
                }
                LOG.trace("Drop external header {}={}", entry.getKey(), entry.getValue());
            }
        }
        return answer;
    }

    @Override
    public Object bindResponseToCamelBody(Object response, Exchange camelExchange) throws Exception {
        return response;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Map<String, String> getCamelToCxfHeaderMap() {
        return this.camelToCxfHeaderMap;
    }

    public void setCamelToCxfHeaderMap(Map<String, String> camelToCxfHeaderMap) {
        this.camelToCxfHeaderMap = camelToCxfHeaderMap;
    }

    public Map<String, String> getCxfToCamelHeaderMap() {
        return this.cxfToCamelHeaderMap;
    }

    public void setCxfToCamelHeaderMap(Map<String, String> cxfToCamelHeaderMap) {
        this.cxfToCamelHeaderMap = cxfToCamelHeaderMap;
    }

    protected void copyMessageHeader(org.apache.cxf.message.Message cxfMessage, Message camelMessage, String cxfKey, String camelKey) {
        if (cxfMessage.get((Object)cxfKey) != null) {
            camelMessage.setHeader(camelKey, cxfMessage.get((Object)cxfKey));
        }
    }

    protected void copyProtocolHeader(org.apache.cxf.message.Message cxfMessage, Message camelMessage, Exchange camelExchange) {
        Map headers = (Map)cxfMessage.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS);
        for (Map.Entry entry : headers.entrySet()) {
            if (this.headerFilterStrategy.applyFilterToCamelHeaders((String)entry.getKey(), entry.getValue(), camelExchange)) {
                LOG.trace("Drop CXF message protocol header: {}={}", entry.getKey(), entry.getValue());
                continue;
            }
            camelMessage.setHeader((String)entry.getKey(), ((List)entry.getValue()).get(0));
        }
    }

    protected void copyOperationResourceInfoStack(org.apache.cxf.message.Message cxfMessage, Message camelMessage) {
        OperationResourceInfoStack stack = (OperationResourceInfoStack)cxfMessage.get(OperationResourceInfoStack.class);
        if (stack != null) {
            OperationResourceInfoStack copyStack = (OperationResourceInfoStack)stack.clone();
            camelMessage.setHeader("CamelCxfRsOperationResourceInfoStack", (Object)copyStack);
        }
    }
}

