/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.exec.impl;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.exec.ExecBinding;
import org.apache.camel.component.exec.ExecCommand;
import org.apache.camel.component.exec.ExecEndpoint;
import org.apache.camel.component.exec.ExecResult;
import org.apache.camel.component.exec.impl.ExecParseUtils;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecBinding
implements ExecBinding {
    @Override
    public ExecCommand readInput(Exchange exchange, ExecEndpoint endpoint) {
        ObjectHelper.notNull((Object)exchange, (String)"exchange");
        ObjectHelper.notNull((Object)((Object)endpoint), (String)"endpoint");
        String cmd = this.getAndRemoveHeader(exchange.getIn(), "CamelExecCommandExecutable", endpoint.getExecutable(), String.class);
        List<String> argsList = this.getAndRemoveHeader(exchange.getIn(), "CamelExecCommandArgs", null, List.class);
        String dir = this.getAndRemoveHeader(exchange.getIn(), "CamelExecCommandWorkingDir", endpoint.getWorkingDir(), String.class);
        long timeout = this.getAndRemoveHeader(exchange.getIn(), "CamelExecCommandTimeout", endpoint.getTimeout(), Long.class);
        String outFilePath = this.getAndRemoveHeader(exchange.getIn(), "CamelExecCommandOutFile", endpoint.getOutFile(), String.class);
        boolean useStderrOnEmptyStdout = this.getAndRemoveHeader(exchange.getIn(), "CamelExecUseStderrOnEmptyStdout", endpoint.isUseStderrOnEmptyStdout(), Boolean.class);
        InputStream input = (InputStream)exchange.getIn().getBody(InputStream.class);
        if (argsList == null) {
            argsList = ExecParseUtils.splitToWhiteSpaceSeparatedTokens(endpoint.getArgs());
        }
        File outFile = outFilePath == null ? null : new File(outFilePath);
        return new ExecCommand(cmd, argsList, dir, timeout, input, outFile, useStderrOnEmptyStdout);
    }

    @Override
    public void writeOutput(Exchange exchange, ExecResult result) {
        ObjectHelper.notNull((Object)exchange, (String)"exchange");
        ObjectHelper.notNull((Object)result, (String)"result");
        if (exchange.getPattern().isOutCapable()) {
            this.writeOutputInMessage(exchange.getOut(), result);
            exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
        } else {
            this.writeOutputInMessage(exchange.getIn(), result);
        }
    }

    protected void writeOutputInMessage(Message message, ExecResult result) {
        message.setHeader("CamelExecStderr", (Object)result.getStderr());
        message.setHeader("CamelExecExitValue", (Object)result.getExitValue());
        message.setBody((Object)result);
    }

    protected <T> T getAndRemoveHeader(Message message, String headerName, T defaultValue, Class<T> headerType) {
        Object h = message.getHeader(headerName, defaultValue, headerType);
        message.removeHeader(headerName);
        return (T)h;
    }
}

