/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceBasedEndpoint;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class FreemarkerEndpoint
extends ResourceBasedEndpoint {
    private String encoding;
    private Configuration configuration;

    public FreemarkerEndpoint() {
    }

    public FreemarkerEndpoint(String uri, Component component, String resourceUri) {
        super(uri, component, resourceUri, null);
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "freemarker:" + this.getResourceUri();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void onExchange(Exchange exchange) throws Exception {
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Freemarker is evaluating " + path + " using context: " + variableMap));
        }
        Template template = this.encoding != null ? this.configuration.getTemplate(path, this.encoding) : this.configuration.getTemplate(path);
        StringWriter buffer = new StringWriter();
        template.process((Object)variableMap, (Writer)buffer);
        buffer.flush();
        Message out = exchange.getOut();
        out.setBody((Object)buffer.toString());
        out.setHeader("CamelFreemarkerResource", (Object)this.getResource());
        out.setHeader("CamelFreemarkerResourceUri", (Object)path);
        Map headers = (Map)variableMap.get("headers");
        for (String key : headers.keySet()) {
            out.setHeader(key, headers.get(key));
        }
    }
}

