/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.freemarker;

import freemarker.cache.CacheStorage;
import freemarker.cache.NullCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import java.net.URL;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.freemarker.FreemarkerEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;

public class FreemarkerComponent
extends DefaultComponent {
    private Configuration configuration;
    private Configuration noCacheConfiguration;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Configuration config;
        boolean cache;
        FreemarkerEndpoint endpoint = new FreemarkerEndpoint(uri, (Component)this, remaining);
        String encoding = (String)this.getAndRemoveParameter(parameters, "encoding", String.class);
        if (ObjectHelper.isNotEmpty((Object)encoding)) {
            endpoint.setEncoding(encoding);
        }
        if (cache = ((Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE)).booleanValue()) {
            config = this.getConfiguration();
            int templateUpdateDelay = (Integer)this.getAndRemoveParameter(parameters, "templateUpdateDelay", Integer.class, 0);
            if (templateUpdateDelay > 0) {
                config.setTemplateUpdateDelay(templateUpdateDelay);
            }
        } else {
            config = this.getNoCacheConfiguration();
        }
        endpoint.setConfiguration(config);
        return endpoint;
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
            this.configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

                protected URL getURL(String name) {
                    try {
                        return ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)FreemarkerComponent.this.getCamelContext().getClassResolver(), (String)name);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        }
        return (Configuration)this.configuration.clone();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private synchronized Configuration getNoCacheConfiguration() {
        if (this.noCacheConfiguration == null) {
            this.noCacheConfiguration = (Configuration)this.getConfiguration().clone();
            this.noCacheConfiguration.setCacheStorage((CacheStorage)new NullCacheStorage());
        }
        return this.noCacheConfiguration;
    }
}

