/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.FtpOperationFailedException;
import org.apache.camel.component.file.remote.FtpUtils;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpConsumer
extends RemoteFileConsumer<RemoteFileExchange> {
    private FtpEndpoint endpoint;
    private FTPClient client;
    private boolean loggedIn;

    public FtpConsumer(FtpEndpoint endpoint, Processor processor, FTPClient client) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.client = client;
    }

    public FtpConsumer(FtpEndpoint endpoint, Processor processor, FTPClient client, ScheduledExecutorService executor) {
        super(endpoint, processor, executor);
        this.endpoint = endpoint;
        this.client = client;
    }

    protected void doStart() throws Exception {
        this.log.info((Object)"Starting");
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.log.info((Object)"Stopping");
        try {
            this.disconnect();
        }
        catch (Exception e) {
            String message = "Could not disconnect from " + this.remoteServer() + ". Reason: " + this.client.getReplyString() + ". Code: " + this.client.getReplyCode();
            this.log.warn((Object)message);
        }
        super.doStop();
    }

    protected void connectIfNecessary() throws IOException {
        if (!this.client.isConnected() || !this.loggedIn) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Not connected/logged in, connecting to " + this.remoteServer()));
            }
            this.loggedIn = FtpUtils.connect(this.client, this.endpoint.getConfiguration());
            if (!this.loggedIn) {
                return;
            }
        }
        this.log.info((Object)("Connected and logged in to " + this.remoteServer()));
    }

    protected void disconnect() throws IOException {
        this.loggedIn = false;
        this.log.debug((Object)("Disconnecting from " + this.remoteServer()));
        FtpUtils.disconnect(this.client);
    }

    protected void poll() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Polling " + this.endpoint.getConfiguration()));
        }
        try {
            this.connectIfNecessary();
            if (!this.loggedIn) {
                String message = "Could not connect/login to " + this.endpoint.getConfiguration();
                this.log.warn((Object)message);
                throw new FtpOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), message);
            }
            String fileName = this.endpoint.getConfiguration().getFile();
            if (this.endpoint.getConfiguration().isDirectory()) {
                this.pollDirectory(fileName);
            } else {
                FTPFile[] files;
                int index = fileName.lastIndexOf(47);
                if (index > -1) {
                    this.client.changeWorkingDirectory(fileName.substring(0, index));
                }
                if ((files = this.client.listFiles(fileName.substring(index + 1))) != null && files.length > 0) {
                    this.pollFile(files[0]);
                }
            }
            this.lastPollTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.loggedIn = false;
            if (this.isStopping() || this.isStopped()) {
                this.log.warn((Object)("Consumer is stopping. Ignoring caught exception: " + e.getClass().getCanonicalName() + " message: " + e.getMessage()));
            }
            this.log.warn((Object)("Exception occured during polling: " + e.getClass().getCanonicalName() + " message: " + e.getMessage()));
            this.disconnect();
            throw e;
        }
    }

    protected void pollDirectory(String dir) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Polling directory: " + dir));
        }
        String currentDir = this.client.printWorkingDirectory();
        this.client.changeWorkingDirectory(dir);
        for (FTPFile ftpFile : this.client.listFiles()) {
            if (ftpFile.isFile()) {
                this.pollFile(ftpFile);
                continue;
            }
            if (ftpFile.isDirectory()) {
                if (!this.isRecursive()) continue;
                this.pollDirectory(this.getFullFileName(ftpFile));
                continue;
            }
            this.log.debug((Object)("Unsupported type of FTPFile: " + ftpFile + " (not a file or directory). It is skipped."));
        }
        this.client.changeWorkingDirectory(currentDir);
    }

    protected String getFullFileName(FTPFile ftpFile) throws IOException {
        return this.client.printWorkingDirectory() + "/" + ftpFile.getName();
    }

    private void pollFile(FTPFile ftpFile) throws Exception {
        if (ftpFile == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Polling file: " + ftpFile));
        }
        boolean timestampMatched = true;
        if (this.isTimestamp()) {
            long ts = ftpFile.getTimestamp().getTimeInMillis();
            boolean bl = timestampMatched = ts > this.lastPollTime;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("The file is to old + " + ftpFile + ". lastPollTime=" + this.lastPollTime + " > fileTimestamp=" + ts));
            }
        }
        if (timestampMatched && this.isMatched(ftpFile)) {
            String fullFileName = this.getFullFileName(ftpFile);
            if (this.exclusiveReadLock) {
                this.acquireExclusiveReadLock(this.client, ftpFile);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.client.retrieveFile(ftpFile.getName(), (OutputStream)byteArrayOutputStream);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieved file: " + ftpFile.getName() + " from: " + this.remoteServer()));
            }
            Object exchange = this.endpoint.createExchange(fullFileName, ftpFile.getName(), ftpFile.getSize(), byteArrayOutputStream);
            if (this.isSetNames()) {
                String ftpBasePath = this.endpoint.getConfiguration().getFile();
                String relativePath = fullFileName.substring(ftpBasePath.length() + 1);
                relativePath = relativePath.replaceFirst("/", "");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Setting exchange filename to " + relativePath));
                }
                exchange.getIn().setHeader("org.apache.camel.file.name", (Object)relativePath);
            }
            this.getProcessor().process(exchange);
            if (exchange.isFailed()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Processing of exchange failed, so cannot do FTP post command such as move or delete: " + exchange));
                }
            } else if (this.deleteFile) {
                boolean deleted;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Deleteing file: " + ftpFile.getName() + " from: " + this.remoteServer()));
                }
                if (!(deleted = this.client.deleteFile(ftpFile.getName()))) {
                    String message = "Can not delete file: " + ftpFile.getName() + " from: " + this.remoteServer();
                    throw new FtpOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), message);
                }
            } else if (this.isMoveFile()) {
                boolean success;
                String directory;
                int lastPathIndex;
                boolean deleted;
                String fromName = ftpFile.getName();
                String toName = this.getMoveFileName(fromName, (Exchange)exchange);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Moving file: " + fromName + " to: " + toName));
                }
                if (!(deleted = this.client.deleteFile(toName)) && (lastPathIndex = toName.lastIndexOf(47)) != -1 && !FtpUtils.buildDirectory(this.client, directory = toName.substring(0, lastPathIndex))) {
                    this.log.warn((Object)("Can not build directory: " + directory + " (maybe because of denied permissions)"));
                }
                if (!(success = this.client.rename(fromName, toName))) {
                    String message = "Can not move file: " + fromName + " to: " + toName;
                    throw new FtpOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), message);
                }
            }
        }
    }

    protected void acquireExclusiveReadLock(FTPClient client, FTPFile ftpFile) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Waiting for exclusive read lock to file: " + ftpFile));
        }
        String originalName = ftpFile.getName();
        String newName = originalName + ".camelExclusiveReadLock";
        boolean exclusive = false;
        while (!exclusive) {
            exclusive = client.rename(originalName, newName);
            if (exclusive) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Acquired exclusive read lock to file: " + originalName));
                }
                client.rename(newName, originalName);
                continue;
            }
            this.log.trace((Object)"Exclusive read lock not granted. Sleeping for 1000 millis.");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
    }

    @Override
    protected String getFileName(Object file) {
        FTPFile ftpFile = (FTPFile)file;
        return ftpFile.getName();
    }
}

