/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.camel.component.file.remote.SftpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpProducer
extends RemoteFileProducer<RemoteFileExchange> {
    private SftpEndpoint endpoint;
    private ChannelSftp channel;
    private Session session;

    public SftpProducer(SftpEndpoint endpoint, Session session) {
        super(endpoint);
        this.endpoint = endpoint;
        this.session = session;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Processing " + this.endpoint.getConfiguration()));
        }
        this.connectIfNecessary();
        try {
            this.process((RemoteFileExchange)this.endpoint.createExchange(exchange));
        }
        catch (Exception e) {
            if (this.isStopping() || this.isStopped()) {
                this.log.warn((Object)("Producer is stopping. Ignoring caught exception: " + e.getClass().getCanonicalName() + " message: " + e.getMessage()));
            }
            this.log.warn((Object)("Exception occured during processing: " + e.getClass().getCanonicalName() + " message: " + e.getMessage()));
            this.disconnect();
            throw e;
        }
    }

    @Override
    protected void connectIfNecessary() throws JSchException {
        if (this.channel == null || !this.channel.isConnected()) {
            if (this.session == null || !this.session.isConnected()) {
                this.log.trace((Object)"Session isn't connected, trying to recreate and connect.");
                this.session = this.endpoint.createSession();
                this.session.connect();
            }
            this.log.trace((Object)"Channel isn't connected, trying to recreate and connect.");
            this.channel = this.endpoint.createChannelSftp(this.session);
            this.channel.connect();
            this.log.info((Object)("Connected to " + this.endpoint.getConfiguration().remoteServerInformation()));
        }
    }

    @Override
    protected void disconnect() throws JSchException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Disconnecting from " + this.remoteServer()));
        }
        if (this.session != null) {
            this.session.disconnect();
        }
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RemoteFileExchange exchange) throws Exception {
        InputStream payload = (InputStream)exchange.getIn().getBody(InputStream.class);
        try {
            String directory;
            boolean success;
            String remoteServer = this.endpoint.getConfiguration().remoteServerInformation();
            String fileName = this.createFileName(exchange.getIn(), this.endpoint.getConfiguration());
            int lastPathIndex = fileName.lastIndexOf(47);
            if (lastPathIndex != -1 && !(success = SftpUtils.buildDirectory(this.channel, directory = fileName.substring(0, lastPathIndex)))) {
                this.log.warn((Object)("Couldn't build directory: " + directory + " (could be because of denied permissions)"));
            }
            this.channel.put(payload, fileName);
            this.log.info((Object)("Sent: " + fileName + " to: " + remoteServer));
        }
        finally {
            if (payload != null) {
                payload.close();
            }
        }
    }
}

