/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.net.ftp.FTPFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpConsumer
extends RemoteFileConsumer<FTPFile> {
    protected String endpointPath;

    public FtpConsumer(RemoteFileEndpoint<FTPFile> endpoint, Processor processor, RemoteFileOperations<FTPFile> fileOperations) {
        super(endpoint, processor, fileOperations);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
    }

    protected boolean pollDirectory(String fileName, List<GenericFile<FTPFile>> fileList) {
        String currentDir = this.operations.getCurrentDirectory();
        fileName = FileUtil.stripTrailingSeparator((String)fileName);
        boolean answer = this.doPollDirectory(fileName, null, fileList);
        this.operations.changeCurrentDirectory(currentDir);
        return answer;
    }

    protected boolean pollSubDirectory(String absolutePath, String dirName, List<GenericFile<FTPFile>> fileList) {
        boolean answer = this.doPollDirectory(absolutePath, dirName, fileList);
        this.operations.changeToParentDirectory();
        return answer;
    }

    protected boolean doPollDirectory(String absolutePath, String dirName, List<GenericFile<FTPFile>> fileList) {
        List files;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("doPollDirectory from absolutePath: " + absolutePath + ", dirName: " + dirName));
        }
        String dir = ObjectHelper.isNotEmpty((Object)(dirName = FileUtil.stripTrailingSeparator((String)dirName))) ? dirName : absolutePath;
        this.operations.changeCurrentDirectory(dir);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Polling directory: " + dir));
        }
        if ((files = this.operations.listFiles()) == null || files.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("No files found in directory: " + dir));
            }
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Found " + files.size() + " in directory: " + dir));
        }
        for (FTPFile file : files) {
            RemoteFile<FTPFile> remote;
            if (!this.canPollMoreFiles(fileList)) {
                return false;
            }
            if (file.isDirectory()) {
                remote = this.asRemoteFile(absolutePath, file);
                if (!this.endpoint.isRecursive() || !this.isValidFile(remote, true)) continue;
                String subDirectory = file.getName();
                String path = absolutePath + "/" + subDirectory;
                boolean canPollMore = this.pollSubDirectory(path, subDirectory, fileList);
                if (canPollMore) continue;
                return false;
            }
            if (file.isFile()) {
                remote = this.asRemoteFile(absolutePath, file);
                if (!this.isValidFile(remote, false)) continue;
                if (this.isInProgress(remote)) {
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)("Skipping as file is already in progress: " + remote.getFileName()));
                    continue;
                }
                fileList.add(remote);
                continue;
            }
            this.log.debug((Object)("Ignoring unsupported remote file type: " + file));
        }
        return true;
    }

    private RemoteFile<FTPFile> asRemoteFile(String absolutePath, FTPFile file) {
        RemoteFile<FTPFile> answer = new RemoteFile<FTPFile>();
        answer.setEndpointPath(this.endpointPath);
        answer.setFile(file);
        answer.setFileNameOnly(file.getName());
        answer.setFileLength(file.getSize());
        if (file.getTimestamp() != null) {
            answer.setLastModified(file.getTimestamp().getTimeInMillis());
        }
        answer.setHostname(((RemoteFileConfiguration)this.endpoint.getConfiguration()).getHost());
        boolean absolute = FileUtil.hasLeadingSeparator((String)absolutePath);
        answer.setAbsolute(absolute);
        String dir = FileUtil.stripTrailingSeparator((String)absolutePath);
        String absoluteFileName = FileUtil.stripLeadingSeparator((String)(dir + "/" + file.getName()));
        if (absolute) {
            absoluteFileName = "/" + absoluteFileName;
        }
        answer.setAbsoluteFilePath(absoluteFileName);
        String relativePath = ObjectHelper.after((String)absoluteFileName, (String)this.endpointPath);
        relativePath = FileUtil.stripLeadingSeparator((String)relativePath);
        answer.setRelativeFilePath(relativePath);
        answer.setFileName(answer.getRelativeFilePath());
        return answer;
    }
}

