/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.storage;

import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.storage.GoogleCloudStorageOperations;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class GoogleCloudStorageConfiguration
implements Cloneable {
    @UriPath(label="common", description="Bucket name or ARN")
    @Metadata(required=true)
    private String bucketName;
    @UriParam(label="common", description="The Service account key that can be used as credentials for the Storage client. It can be loaded by default from  classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.")
    private String serviceAccountKey;
    @UriParam(label="producer", enums="copyObject,listObjects,deleteObject,deleteBucket,listBuckets,getObject,createDownloadLink")
    private GoogleCloudStorageOperations operation;
    @UriParam(label="producer", description="The Object name inside the bucket")
    private String objectName;
    @UriParam(label="common", defaultValue="US-EAST1", description="The Cloud Storage location to use when creating the new buckets")
    private String storageLocation = "US-EAST1";
    @UriParam(label="common", defaultValue="STANDARD", description="The Cloud Storage class to use when creating the new buckets")
    private StorageClass storageClass = StorageClass.STANDARD;
    @UriParam(label="common", defaultValue="true")
    private boolean autoCreateBucket = true;
    @UriParam(label="consumer")
    private boolean moveAfterRead;
    @UriParam(label="consumer")
    private String destinationBucket;
    @UriParam(label="consumer", defaultValue="true")
    private boolean deleteAfterRead = true;
    @UriParam(label="consumer", defaultValue="true")
    private boolean includeBody = true;
    @UriParam(label="consumer", defaultValue="true")
    private boolean includeFolders = true;
    @UriParam(label="consumer")
    private String downloadFileName;
    @UriParam
    @Metadata(autowired=true)
    private Storage storageClient;
    @UriParam(label="consumer", description="A regular expression to include only blobs with name matching it.")
    private String filter;

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getServiceAccountKey() {
        return this.serviceAccountKey;
    }

    public void setServiceAccountKey(String serviceAccountKey) {
        this.serviceAccountKey = serviceAccountKey;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass;
    }

    public Storage getStorageClient() {
        return this.storageClient;
    }

    public void setStorageClient(Storage storageClient) {
        this.storageClient = storageClient;
    }

    public GoogleCloudStorageOperations getOperation() {
        return this.operation;
    }

    public void setOperation(GoogleCloudStorageOperations operation) {
        this.operation = operation;
    }

    public boolean isAutoCreateBucket() {
        return this.autoCreateBucket;
    }

    public void setAutoCreateBucket(boolean autoCreateBucket) {
        this.autoCreateBucket = autoCreateBucket;
    }

    public boolean isMoveAfterRead() {
        return this.moveAfterRead;
    }

    public void setMoveAfterRead(boolean moveAfterRead) {
        this.moveAfterRead = moveAfterRead;
    }

    public String getDestinationBucket() {
        return this.destinationBucket;
    }

    public void setDestinationBucket(String destinationBucket) {
        this.destinationBucket = destinationBucket;
    }

    public void setIncludeFolders(boolean includeFolders) {
        this.includeFolders = includeFolders;
    }

    public boolean isIncludeFolders() {
        return this.includeFolders;
    }

    public String getDownloadFileName() {
        return this.downloadFileName;
    }

    public void setDownloadFileName(String downloadFileName) {
        this.downloadFileName = downloadFileName;
    }

    public boolean isDeleteAfterRead() {
        return this.deleteAfterRead;
    }

    public void setDeleteAfterRead(boolean deleteAfterRead) {
        this.deleteAfterRead = deleteAfterRead;
    }

    public void setIncludeBody(boolean includeBody) {
        this.includeBody = includeBody;
    }

    public boolean isIncludeBody() {
        return this.includeBody;
    }

    public GoogleCloudStorageConfiguration copy() {
        try {
            return (GoogleCloudStorageConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }
}

