/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.set;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ISet;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;

public class HazelcastSetProducer
extends HazelcastDefaultProducer {
    private final ISet<Object> set;

    public HazelcastSetProducer(HazelcastInstance hazelcastInstance, HazelcastDefaultEndpoint endpoint, String setName) {
        super(endpoint);
        this.set = hazelcastInstance.getSet(setName);
    }

    public void process(Exchange exchange) throws Exception {
        int operation = this.lookupOperationNumber(exchange);
        switch (operation) {
            case 31: {
                this.add(exchange);
                break;
            }
            case 17: {
                this.remove(exchange);
                break;
            }
            case 7: {
                this.clear();
                break;
            }
            case 9: {
                this.addAll(exchange);
                break;
            }
            case 10: {
                this.removeAll(exchange);
                break;
            }
            case 11: {
                this.retainAll(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the LIST cache.", operation, "CamelHazelcastOperationType"));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void add(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.set.add(body);
    }

    private void remove(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.set.remove(body);
    }

    private void clear() {
        this.set.clear();
    }

    private void addAll(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.set.addAll((Collection)body);
    }

    private void removeAll(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.set.removeAll((Collection)body);
    }

    private void retainAll(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.set.retainAll((Collection)body);
    }
}

