/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.policy;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.component.hazelcast.HazelcastUtil;
import org.apache.camel.support.RoutePolicySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastRoutePolicy
extends RoutePolicySupport
implements NonManagedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastRoutePolicy.class);
    private final boolean managedInstance;
    private final AtomicBoolean leader;
    private final Set<Route> suspendedRoutes;
    private final ExecutorService executorService;
    private HazelcastInstance instance;
    private String lockMapName;
    private String lockKey;
    private String lockValue;
    private long tryLockTimeout;
    private TimeUnit tryLockTimeoutUnit;
    private IMap<String, String> locks;
    private volatile Future<Void> future;
    private boolean shouldStopConsumer;

    public HazelcastRoutePolicy() {
        this(HazelcastUtil.newInstance(), true);
    }

    public HazelcastRoutePolicy(HazelcastInstance instance) {
        this(instance, false);
    }

    public HazelcastRoutePolicy(HazelcastInstance instance, boolean managedInstance) {
        this.instance = instance;
        this.managedInstance = managedInstance;
        this.suspendedRoutes = new HashSet<Route>();
        this.leader = new AtomicBoolean(false);
        this.lockMapName = null;
        this.lockKey = null;
        this.lockValue = null;
        this.tryLockTimeout = Long.MAX_VALUE;
        this.tryLockTimeoutUnit = TimeUnit.MILLISECONDS;
        this.locks = null;
        this.future = null;
        this.shouldStopConsumer = true;
        this.executorService = Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r, "Camel RoutePolicy");
            thread.setDaemon(true);
            return thread;
        });
    }

    public void onStart(Route route) {
        if (!this.leader.get() && this.shouldStopConsumer) {
            this.stopConsumer(route);
        }
    }

    public synchronized void onStop(Route route) {
        this.suspendedRoutes.remove(route);
    }

    public synchronized void onSuspend(Route route) {
        this.suspendedRoutes.remove(route);
    }

    protected void doStart() throws Exception {
        this.locks = this.instance.getMap(this.lockMapName);
        this.future = this.executorService.submit(this::acquireLeadership);
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        if (this.managedInstance) {
            this.instance.shutdown();
        }
        super.doStop();
    }

    protected void setLeader(boolean isLeader) {
        if (isLeader && this.leader.compareAndSet(false, isLeader)) {
            LOGGER.info("Leadership taken (map={}, key={}, val={})", new Object[]{this.lockMapName, this.lockKey, this.lockValue});
            this.startAllStoppedConsumers();
        } else if (!this.leader.getAndSet(isLeader) && isLeader) {
            LOGGER.info("Leadership lost (map={}, key={} val={})", new Object[]{this.lockMapName, this.lockKey, this.lockValue});
        }
    }

    private synchronized void startConsumer(Route route) {
        try {
            if (this.suspendedRoutes.contains(route)) {
                this.startConsumer(route.getConsumer());
                this.suspendedRoutes.remove(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private synchronized void stopConsumer(Route route) {
        try {
            if (!this.suspendedRoutes.contains(route)) {
                LOGGER.debug("Stopping consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                this.stopConsumer(route.getConsumer());
                this.suspendedRoutes.add(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private synchronized void startAllStoppedConsumers() {
        try {
            for (Route route : this.suspendedRoutes) {
                LOGGER.debug("Starting consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                this.startConsumer(route.getConsumer());
            }
            this.suspendedRoutes.clear();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String getLockMapName() {
        return this.lockMapName;
    }

    public void setLockMapName(String lockMapName) {
        this.lockMapName = lockMapName;
    }

    public boolean isShouldStopConsumer() {
        return this.shouldStopConsumer;
    }

    public void setShouldStopConsumer(boolean shouldStopConsumer) {
        this.shouldStopConsumer = shouldStopConsumer;
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public void setLockKey(String lockKey) {
        this.lockKey = lockKey;
    }

    public String getLockValue() {
        return this.lockValue;
    }

    public void setLockValue(String lockValue) {
        this.lockValue = lockValue;
    }

    public long getTryLockTimeout() {
        return this.tryLockTimeout;
    }

    public void setTryLockTimeout(long tryLockTimeout) {
        this.tryLockTimeout = tryLockTimeout;
    }

    public void setTryLockTimeout(long tryLockTimeout, TimeUnit tryLockTimeoutUnit) {
        this.tryLockTimeout = tryLockTimeout;
        this.tryLockTimeoutUnit = tryLockTimeoutUnit;
    }

    public TimeUnit getTryLockTimeoutUnit() {
        return this.tryLockTimeoutUnit;
    }

    public void setTryLockTimeoutUnit(TimeUnit tryLockTimeoutUnit) {
        this.tryLockTimeoutUnit = tryLockTimeoutUnit;
    }

    public boolean isLeader() {
        return this.leader.get();
    }

    private Void acquireLeadership() throws Exception {
        boolean locked = false;
        while (this.isRunAllowed()) {
            try {
                locked = this.locks.tryLock((Object)this.lockKey, this.tryLockTimeout, this.tryLockTimeoutUnit);
                if (locked) {
                    this.locks.put((Object)this.lockKey, (Object)this.lockValue);
                    this.setLeader(true);
                    Thread.sleep(Long.MAX_VALUE);
                    continue;
                }
                LOGGER.debug("Failed to acquire lock (map={}, key={}, val={}) after {} {}", new Object[]{this.lockMapName, this.lockKey, this.lockValue, this.tryLockTimeout, this.tryLockTimeoutUnit.name()});
            }
            catch (InterruptedException e) {
                if (this.isRunAllowed()) {
                    LOGGER.warn("Interrupted Exception caught", (Throwable)e);
                    continue;
                }
                LOGGER.debug("Interrupted Exception caught", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.warn("Exception caught", (Throwable)e);
            }
            finally {
                if (locked) {
                    this.locks.remove((Object)this.lockKey);
                    this.locks.unlock((Object)this.lockKey);
                    locked = false;
                }
                this.setLeader(false);
            }
        }
        return null;
    }
}

