/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.hdfs2.HdfsCompressionCodec;
import org.apache.camel.component.hdfs2.HdfsConstants;
import org.apache.camel.component.hdfs2.HdfsFileSystemType;
import org.apache.camel.component.hdfs2.HdfsFileType;
import org.apache.camel.component.hdfs2.HdfsProducer;
import org.apache.camel.component.hdfs2.WritableType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.URISupport;
import org.apache.hadoop.io.SequenceFile;

@UriParams
public class HdfsConfiguration {
    private URI uri;
    private boolean wantAppend;
    private List<HdfsProducer.SplitStrategy> splitStrategies;
    @UriPath
    @Metadata(required="true")
    private String hostName;
    @UriPath(defaultValue="8020")
    private int port = 8020;
    @UriPath
    @Metadata(required="true")
    private String path;
    @UriParam(label="producer", defaultValue="true")
    private boolean overwrite = true;
    @UriParam(label="producer")
    private boolean append;
    @UriParam(label="advanced")
    private String splitStrategy;
    @UriParam(label="advanced", defaultValue="4096")
    private int bufferSize = 4096;
    @UriParam(label="advanced", defaultValue="3")
    private short replication = (short)3;
    @UriParam(label="advanced", defaultValue="67108864")
    private long blockSize = 0x4000000L;
    @UriParam(label="advanced", defaultValue="NONE")
    private SequenceFile.CompressionType compressionType = HdfsConstants.DEFAULT_COMPRESSIONTYPE;
    @UriParam(label="advanced", defaultValue="DEFAULT")
    private HdfsCompressionCodec compressionCodec = HdfsConstants.DEFAULT_CODEC;
    @UriParam(defaultValue="NORMAL_FILE")
    private HdfsFileType fileType = HdfsFileType.NORMAL_FILE;
    @UriParam(defaultValue="HDFS")
    private HdfsFileSystemType fileSystemType = HdfsFileSystemType.HDFS;
    @UriParam(defaultValue="NULL")
    private WritableType keyType = WritableType.NULL;
    @UriParam(defaultValue="BYTES")
    private WritableType valueType = WritableType.BYTES;
    @UriParam(label="advanced", defaultValue="opened")
    private String openedSuffix = "opened";
    @UriParam(label="advanced", defaultValue="read")
    private String readSuffix = "read";
    @UriParam(label="consumer", defaultValue="10000")
    private long initialDelay = 10000L;
    @UriParam(label="consumer", defaultValue="1000")
    private long delay = 1000L;
    @UriParam(label="consumer", defaultValue="*")
    private String pattern = "*";
    @UriParam(label="advanced", defaultValue="4096")
    private int chunkSize = 4096;
    @UriParam(label="advanced", defaultValue="500")
    private int checkIdleInterval = 500;
    @UriParam(defaultValue="true")
    private boolean connectOnStartup = true;
    @UriParam
    private String owner;

    private Boolean getBoolean(Map<String, Object> hdfsSettings, String param, Boolean dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Boolean.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private Integer getInteger(Map<String, Object> hdfsSettings, String param, Integer dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Integer.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private Short getShort(Map<String, Object> hdfsSettings, String param, Short dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Short.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private Long getLong(Map<String, Object> hdfsSettings, String param, Long dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Long.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private HdfsFileType getFileType(Map<String, Object> hdfsSettings, String param, HdfsFileType dflt) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return HdfsFileType.valueOf(eit);
        }
        return dflt;
    }

    private HdfsFileSystemType getFileSystemType(Map<String, Object> hdfsSettings, String param, HdfsFileSystemType dflt) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return HdfsFileSystemType.valueOf(eit);
        }
        return dflt;
    }

    private WritableType getWritableType(Map<String, Object> hdfsSettings, String param, WritableType dflt) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return WritableType.valueOf(eit);
        }
        return dflt;
    }

    private SequenceFile.CompressionType getCompressionType(Map<String, Object> hdfsSettings, String param, SequenceFile.CompressionType ct) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return SequenceFile.CompressionType.valueOf((String)eit);
        }
        return ct;
    }

    private HdfsCompressionCodec getCompressionCodec(Map<String, Object> hdfsSettings, String param, HdfsCompressionCodec cd) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return HdfsCompressionCodec.valueOf(eit);
        }
        return cd;
    }

    private String getString(Map<String, Object> hdfsSettings, String param, String dflt) {
        if (hdfsSettings.containsKey(param)) {
            return (String)hdfsSettings.get(param);
        }
        return dflt;
    }

    private List<HdfsProducer.SplitStrategy> getSplitStrategies(Map<String, Object> hdfsSettings) {
        ArrayList<HdfsProducer.SplitStrategy> strategies = new ArrayList<HdfsProducer.SplitStrategy>();
        for (String obj : hdfsSettings.keySet()) {
            String[] strstrategies;
            String eit;
            String key = obj;
            if (!"splitStrategy".equals(key) || (eit = (String)hdfsSettings.get(key)) == null) continue;
            for (String strstrategy : strstrategies = eit.split(",")) {
                String[] tokens = strstrategy.split(":");
                if (tokens.length != 2) {
                    throw new IllegalArgumentException("Wrong Split Strategy " + key + "=" + eit);
                }
                HdfsProducer.SplitStrategyType sst = HdfsProducer.SplitStrategyType.valueOf(tokens[0]);
                long ssv = Long.valueOf(tokens[1]);
                strategies.add(new HdfsProducer.SplitStrategy(sst, ssv));
            }
        }
        return strategies;
    }

    public void checkConsumerOptions() {
    }

    public void checkProducerOptions() {
        if (this.isAppend()) {
            if (this.getSplitStrategies().size() != 0) {
                throw new IllegalArgumentException("Split Strategies incompatible with append=true");
            }
            if (this.getFileType() != HdfsFileType.NORMAL_FILE) {
                throw new IllegalArgumentException("append=true works only with NORMAL_FILEs");
            }
        }
    }

    public void parseURI(URI uri) throws URISyntaxException {
        String protocol = uri.getScheme();
        if (!protocol.equalsIgnoreCase("hdfs2")) {
            throw new IllegalArgumentException("Unrecognized protocol: " + protocol + " for uri: " + uri);
        }
        this.hostName = uri.getHost();
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
        this.port = uri.getPort() == -1 ? 8020 : uri.getPort();
        this.path = uri.getPath();
        Map hdfsSettings = URISupport.parseParameters((URI)uri);
        this.overwrite = this.getBoolean(hdfsSettings, "overwrite", this.overwrite);
        this.wantAppend = this.append = this.getBoolean(hdfsSettings, "append", this.append).booleanValue();
        this.bufferSize = this.getInteger(hdfsSettings, "bufferSize", this.bufferSize);
        this.replication = this.getShort(hdfsSettings, "replication", this.replication);
        this.blockSize = this.getLong(hdfsSettings, "blockSize", this.blockSize);
        this.compressionType = this.getCompressionType(hdfsSettings, "compressionType", this.compressionType);
        this.compressionCodec = this.getCompressionCodec(hdfsSettings, "compressionCodec", this.compressionCodec);
        this.fileType = this.getFileType(hdfsSettings, "fileType", this.fileType);
        this.fileSystemType = this.getFileSystemType(hdfsSettings, "fileSystemType", this.fileSystemType);
        this.keyType = this.getWritableType(hdfsSettings, "keyType", this.keyType);
        this.valueType = this.getWritableType(hdfsSettings, "valueType", this.valueType);
        this.openedSuffix = this.getString(hdfsSettings, "openedSuffix", this.openedSuffix);
        this.readSuffix = this.getString(hdfsSettings, "readSuffix", this.readSuffix);
        this.initialDelay = this.getLong(hdfsSettings, "initialDelay", this.initialDelay);
        this.delay = this.getLong(hdfsSettings, "delay", this.delay);
        this.pattern = this.getString(hdfsSettings, "pattern", this.pattern);
        this.chunkSize = this.getInteger(hdfsSettings, "chunkSize", this.chunkSize);
        this.splitStrategies = this.getSplitStrategies(hdfsSettings);
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isWantAppend() {
        return this.wantAppend;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public short getReplication() {
        return this.replication;
    }

    public void setReplication(short replication) {
        this.replication = replication;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public HdfsFileType getFileType() {
        return this.fileType;
    }

    public void setFileType(HdfsFileType fileType) {
        this.fileType = fileType;
    }

    public SequenceFile.CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(SequenceFile.CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public HdfsCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(HdfsCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public void setFileSystemType(HdfsFileSystemType fileSystemType) {
        this.fileSystemType = fileSystemType;
    }

    public HdfsFileSystemType getFileSystemType() {
        return this.fileSystemType;
    }

    public WritableType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(WritableType keyType) {
        this.keyType = keyType;
    }

    public WritableType getValueType() {
        return this.valueType;
    }

    public void setValueType(WritableType valueType) {
        this.valueType = valueType;
    }

    public void setOpenedSuffix(String openedSuffix) {
        this.openedSuffix = openedSuffix;
    }

    public String getOpenedSuffix() {
        return this.openedSuffix;
    }

    public void setReadSuffix(String readSuffix) {
        this.readSuffix = readSuffix;
    }

    public String getReadSuffix() {
        return this.readSuffix;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setCheckIdleInterval(int checkIdleInterval) {
        this.checkIdleInterval = checkIdleInterval;
    }

    public int getCheckIdleInterval() {
        return this.checkIdleInterval;
    }

    public List<HdfsProducer.SplitStrategy> getSplitStrategies() {
        return this.splitStrategies;
    }

    public String getSplitStrategy() {
        return this.splitStrategy;
    }

    public void setSplitStrategy(String splitStrategy) {
        this.splitStrategy = splitStrategy;
    }

    public boolean isConnectOnStartup() {
        return this.connectOnStartup;
    }

    public void setConnectOnStartup(boolean connectOnStartup) {
        this.connectOnStartup = connectOnStartup;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }
}

