/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonDataFormat
implements DataFormat {
    private final ObjectMapper objectMapper;
    private Class<?> unmarshalType;

    public JacksonDataFormat() {
        this(new ObjectMapper(), HashMap.class);
    }

    public JacksonDataFormat(Class<?> unmarshalType) {
        this(new ObjectMapper(), unmarshalType);
    }

    public JacksonDataFormat(ObjectMapper mapper, Class<?> unmarshalType) {
        this.objectMapper = mapper;
        this.unmarshalType = unmarshalType;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        this.objectMapper.writeValue(stream, graph);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.objectMapper.readValue(stream, this.unmarshalType);
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

