/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.converter;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Set;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.TypeConverterRegistry;

@Converter(loader=true)
public final class JacksonTypeConverters {
    private final ObjectMapper defaultMapper = new ObjectMapper();
    private boolean init;
    private boolean enabled;
    private boolean toPojo;

    public JacksonTypeConverters() {
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        this.defaultMapper.registerModule((Module)module);
    }

    @Converter(fallback=true)
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) throws Exception {
        if (!this.init && exchange != null) {
            String text = (String)exchange.getContext().getGlobalOptions().get("CamelJacksonEnableTypeConverter");
            if (text != null) {
                text = exchange.getContext().resolvePropertyPlaceholders(text);
                this.enabled = "true".equalsIgnoreCase(text);
            }
            if ((text = (String)exchange.getContext().getGlobalOptions().get("CamelJacksonTypeConverterToPojo")) != null) {
                text = exchange.getContext().resolvePropertyPlaceholders(text);
                this.toPojo = "true".equalsIgnoreCase(text);
            }
            this.init = true;
        }
        if (!this.enabled) {
            return null;
        }
        if (!this.toPojo && JacksonTypeConverters.isNotPojoType(type)) {
            return null;
        }
        if (exchange != null) {
            ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext().getRegistry());
            if (String.class.isAssignableFrom(type)) {
                String out = mapper.writeValueAsString(value);
                return type.cast(out);
            }
            if (byte[].class.isAssignableFrom(type)) {
                byte[] out = mapper.writeValueAsBytes(value);
                return type.cast(out);
            }
            if (mapper.canSerialize(type) && !Enum.class.isAssignableFrom(type)) {
                if (String.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((String)value, type);
                }
                if (byte[].class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((byte[])value, type);
                }
                if (File.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((File)value, type);
                }
                if (InputStream.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((InputStream)value, type);
                }
                if (Reader.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((Reader)value, type);
                }
                return (T)mapper.convertValue(value, type);
            }
        }
        return null;
    }

    private static boolean isNotPojoType(Class<?> type) {
        boolean isString = String.class.isAssignableFrom(type);
        boolean isNumber = Number.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type);
        return isString || isNumber;
    }

    private ObjectMapper resolveObjectMapper(Registry registry) {
        Set mappers = registry.findByType(ObjectMapper.class);
        if (mappers.size() == 1) {
            return (ObjectMapper)mappers.iterator().next();
        }
        return this.defaultMapper;
    }
}

