/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.util.JAXBSource;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.converter.jaxb.MessageDefinition;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class JaxbConverter {
    private XmlConverter xmlConverter = new XmlConverter();
    private Map<Class<?>, JAXBContext> contexts = new HashMap();

    public JAXBSource toSource(Object value) throws JAXBException {
        if (value == null) {
            throw new IllegalArgumentException("Cannot convert from null value to JAXBSource");
        }
        if (value.getClass().getAnnotation(XmlRootElement.class) != null) {
            JAXBContext context = this.getJaxbContext(value);
            return new JAXBSource(context, value);
        }
        return null;
    }

    public Document toDocument(Object value) throws JAXBException, ParserConfigurationException {
        if (value == null) {
            throw new IllegalArgumentException("Cannot convert from null value to JAXBSource");
        }
        if (value.getClass().getAnnotation(XmlRootElement.class) != null) {
            JAXBContext context = this.getJaxbContext(value);
            Marshaller marshaller = context.createMarshaller();
            Document doc = this.xmlConverter.createDocument();
            marshaller.marshal(value, (Node)doc);
            return doc;
        }
        return null;
    }

    @Converter
    public static MessageDefinition toMessageType(Exchange exchange) {
        return JaxbConverter.toMessageType(exchange.getIn());
    }

    @Converter
    public static MessageDefinition toMessageType(Message in) {
        MessageDefinition answer = new MessageDefinition();
        answer.copyFrom(in);
        return answer;
    }

    private synchronized JAXBContext getJaxbContext(Object value) throws JAXBException {
        Class<?> type = value.getClass();
        JAXBContext context = this.contexts.get(type);
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{type});
            this.contexts.put(type, context);
        }
        return context;
    }
}

