/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlLineNumberParser {
    public static final String LINE_NUMBER = "lineNumber";
    public static final String COLUMN_NUMBER = "colNumber";
    public static final String LINE_NUMBER_END = "lineNumberEnd";
    public static final String COLUMN_NUMBER_END = "colNumberEnd";

    private XmlLineNumberParser() {
    }

    public static Document parseXml(InputStream is) throws Exception {
        return XmlLineNumberParser.parseXml(is, null);
    }

    public static Document parseXml(InputStream is, XmlTextTransformer xmlTransformer) throws Exception {
        return XmlLineNumberParser.parseXml(is, xmlTransformer, null, null);
    }

    public static Document parseXml(InputStream is, XmlTextTransformer xmlTransformer, final String rootNames, final String forceNamespace) throws Exception {
        ObjectHelper.notNull((Object)is, (String)"is");
        final XmlTextTransformer transformer = xmlTransformer == null ? new NoopTransformer() : xmlTransformer;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        SAXParser parser = factory.newSAXParser();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        dbf.setFeature("http://xml.org/sax/features/namespaces", false);
        dbf.setFeature("http://xml.org/sax/features/validation", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        final Document doc = docBuilder.newDocument();
        final Stack elementStack = new Stack();
        final StringBuilder textBuffer = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(){
            private Locator locator;
            private boolean found;

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
                this.found = rootNames == null;
            }

            private boolean isRootName(String qName) {
                for (String root : rootNames.split(",")) {
                    if (!qName.equals(root)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.addTextIfNeeded();
                if (rootNames != null && !this.found && this.isRootName(qName)) {
                    this.found = true;
                }
                if (this.found) {
                    Element el = forceNamespace != null ? doc.createElementNS(forceNamespace, qName) : doc.createElement(qName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        el.setAttribute(transformer.transform(attributes.getQName(i)), transformer.transform(attributes.getValue(i)));
                    }
                    el.setUserData(XmlLineNumberParser.LINE_NUMBER, String.valueOf(this.locator.getLineNumber()), null);
                    el.setUserData(XmlLineNumberParser.COLUMN_NUMBER, String.valueOf(this.locator.getColumnNumber()), null);
                    elementStack.push(el);
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                Element closedEl;
                if (!this.found) {
                    return;
                }
                this.addTextIfNeeded();
                Element element = closedEl = elementStack.isEmpty() ? null : (Element)elementStack.pop();
                if (closedEl != null) {
                    if (elementStack.isEmpty()) {
                        doc.appendChild(closedEl);
                    } else {
                        Element parentEl = (Element)elementStack.peek();
                        parentEl.appendChild(closedEl);
                    }
                    closedEl.setUserData(XmlLineNumberParser.LINE_NUMBER_END, String.valueOf(this.locator.getLineNumber()), null);
                    closedEl.setUserData(XmlLineNumberParser.COLUMN_NUMBER_END, String.valueOf(this.locator.getColumnNumber()), null);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                char[] chars = new char[length];
                System.arraycopy(ch, start, chars, 0, length);
                String s = new String(chars);
                s = transformer.transform(s);
                textBuffer.append(s);
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                return new InputSource(new StringReader(""));
            }

            private void addTextIfNeeded() {
                if (textBuffer.length() > 0) {
                    Element el;
                    Element element = el = elementStack.isEmpty() ? null : (Element)elementStack.peek();
                    if (el != null) {
                        Text textNode = doc.createTextNode(textBuffer.toString());
                        el.appendChild(textNode);
                        textBuffer.delete(0, textBuffer.length());
                    }
                }
            }
        };
        parser.parse(is, handler);
        return doc;
    }

    private static final class NoopTransformer
    implements XmlTextTransformer {
        private NoopTransformer() {
        }

        @Override
        public String transform(String text) {
            return text;
        }
    }

    public static interface XmlTextTransformer {
        public String transform(String var1);
    }
}

