/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jdbc.JdbcProducer;
import org.apache.camel.impl.DefaultEndpoint;

public class JdbcEndpoint
extends DefaultEndpoint {
    private int readSize;
    private DataSource dataSource;
    private Map<String, Object> parameters;
    private boolean useJDBC4ColumnNameAndLabelSemantics = true;

    public JdbcEndpoint() {
    }

    public JdbcEndpoint(String endpointUri, Component component, DataSource dataSource) {
        super(endpointUri, component);
        this.dataSource = dataSource;
    }

    public boolean isSingleton() {
        return true;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    public Producer createProducer() throws Exception {
        return new JdbcProducer(this, this.dataSource, this.readSize, this.parameters);
    }

    public int getReadSize() {
        return this.readSize;
    }

    public void setReadSize(int readSize) {
        this.readSize = readSize;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public boolean isUseJDBC4ColumnNameAndLabelSemantics() {
        return this.useJDBC4ColumnNameAndLabelSemantics;
    }

    public void setUseJDBC4ColumnNameAndLabelSemantics(boolean useJDBC4ColumnNameAndLabelSemantics) {
        this.useJDBC4ColumnNameAndLabelSemantics = useJDBC4ColumnNameAndLabelSemantics;
    }

    protected String createEndpointUri() {
        return "jdbc";
    }
}

