/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.jms.InOnlyMessageSentCallback;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.MessageSentCallback;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.component.jms.reply.PersistentQueueReplyManager;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.component.jms.reply.TemporaryQueueReplyManager;
import org.apache.camel.component.jms.reply.UseMessageIdAsCorrelationIdMessageSentCallback;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.support.JmsUtils;

public class JmsProducer
extends DefaultAsyncProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(JmsProducer.class);
    private static final String GENERATED_CORRELATION_ID_PREFIX = "Camel-";
    private final JmsEndpoint endpoint;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private JmsOperations inOnlyTemplate;
    private JmsOperations inOutTemplate;
    private UuidGenerator uuidGenerator;
    private ReplyManager replyManager;

    public JmsProducer(JmsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public JmsEndpoint getEndpoint() {
        return (JmsEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initReplyManager() {
        if (!this.started.get()) {
            JmsProducer jmsProducer = this;
            synchronized (jmsProducer) {
                if (this.started.get()) {
                    return;
                }
                ClassLoader current = Thread.currentThread().getContextClassLoader();
                ClassLoader ac = this.endpoint.getCamelContext().getApplicationContextClassLoader();
                try {
                    if (ac != null) {
                        Thread.currentThread().setContextClassLoader(ac);
                    }
                    if (this.endpoint.getReplyToType() != null && this.endpoint.getReplyTo() != null && this.endpoint.getReplyToType().equals(ReplyToType.Temporary.name())) {
                        throw new IllegalArgumentException("ReplyToType " + (Object)((Object)ReplyToType.Temporary) + " is not supported when replyTo " + this.endpoint.getReplyTo() + " is also configured.");
                    }
                    if (this.endpoint.getReplyTo() != null) {
                        this.replyManager = this.createReplyManager(this.endpoint.getReplyTo());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Using JmsReplyManager: {} to process replies from: {}", (Object)this.replyManager, (Object)this.endpoint.getReplyTo());
                        }
                    } else {
                        this.replyManager = this.createReplyManager();
                        LOG.debug("Using JmsReplyManager: {} to process replies from temporary queue", (Object)this.replyManager);
                    }
                }
                catch (Exception e) {
                    throw new FailedToCreateProducerException((Endpoint)this.endpoint, (Throwable)e);
                }
                finally {
                    if (ac != null) {
                        Thread.currentThread().setContextClassLoader(current);
                    }
                }
                this.started.set(true);
            }
        }
    }

    protected void unInitReplyManager() {
        try {
            ServiceHelper.stopService((Object)this.replyManager);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        finally {
            this.started.set(false);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isRunAllowed()) {
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException());
            }
            callback.done(true);
            return true;
        }
        try {
            if (!this.endpoint.isDisableReplyTo() && exchange.getPattern().isOutCapable()) {
                return this.processInOut(exchange, callback);
            }
            return this.processInOnly(exchange, callback);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    protected boolean processInOut(final Exchange exchange, final AsyncCallback callback) {
        String originalCorrelationId;
        boolean generateFreshCorrId;
        final Message in = exchange.getIn();
        String destinationName = (String)in.getHeader("CamelJmsDestinationName", String.class);
        in.removeHeader("CamelJmsDestinationName");
        if (destinationName == null) {
            destinationName = this.endpoint.getDestinationName();
        }
        Destination destination = (Destination)in.getHeader("CamelJmsDestination", Destination.class);
        in.removeHeader("CamelJmsDestination");
        if (destination == null) {
            destination = this.endpoint.getDestination();
        }
        if (destination != null) {
            destinationName = null;
        }
        this.initReplyManager();
        boolean msgIdAsCorrId = this.endpoint.getConfiguration().isUseMessageIDAsCorrelationID();
        final String provisionalCorrelationId = msgIdAsCorrId ? this.getUuidGenerator().generateUuid() : null;
        UseMessageIdAsCorrelationIdMessageSentCallback messageSentCallback = null;
        if (msgIdAsCorrId) {
            messageSentCallback = new UseMessageIdAsCorrelationIdMessageSentCallback(this.replyManager, provisionalCorrelationId, this.endpoint.getRequestTimeout());
        }
        boolean bl = generateFreshCorrId = ObjectHelper.isEmpty((Object)(originalCorrelationId = (String)in.getHeader("JMSCorrelationID", String.class))) && !msgIdAsCorrId || originalCorrelationId != null && originalCorrelationId.startsWith(GENERATED_CORRELATION_ID_PREFIX);
        if (generateFreshCorrId) {
            in.setHeader("JMSCorrelationID", (Object)(GENERATED_CORRELATION_ID_PREFIX + this.getUuidGenerator().generateUuid()));
        }
        MessageCreator messageCreator = new MessageCreator(){

            public javax.jms.Message createMessage(Session session) throws JMSException {
                javax.jms.Message answer = JmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session, null);
                Destination replyTo = JmsProducer.this.replyManager.getReplyTo();
                if (replyTo == null) {
                    throw new RuntimeExchangeException("Failed to resolve replyTo destination", exchange);
                }
                LOG.debug("Using JMSReplyTo destination: {}", (Object)replyTo);
                JmsMessageHelper.setJMSReplyTo(answer, replyTo);
                JmsProducer.this.replyManager.setReplyToSelectorHeader(in, answer);
                String correlationId = JmsProducer.this.determineCorrelationId(answer, provisionalCorrelationId);
                JmsProducer.this.replyManager.registerReply(JmsProducer.this.replyManager, exchange, callback, originalCorrelationId, correlationId, JmsProducer.this.endpoint.getRequestTimeout());
                LOG.debug("Using JMSCorrelationID: {}", (Object)correlationId);
                LOG.trace("Created javax.jms.Message: {}", (Object)answer);
                return answer;
            }
        };
        this.doSend(true, destinationName, destination, messageCreator, messageSentCallback);
        this.setMessageId(exchange);
        return false;
    }

    protected String determineCorrelationId(javax.jms.Message message, String provisionalCorrelationId) throws JMSException {
        if (provisionalCorrelationId != null) {
            return provisionalCorrelationId;
        }
        String messageId = message.getJMSMessageID();
        String correlationId = message.getJMSCorrelationID();
        if (this.endpoint.getConfiguration().isUseMessageIDAsCorrelationID()) {
            return messageId;
        }
        if (ObjectHelper.isEmpty((Object)correlationId)) {
            return messageId;
        }
        return correlationId;
    }

    protected boolean processInOnly(final Exchange exchange, AsyncCallback callback) {
        Destination destination;
        final Message in = exchange.getIn();
        String destinationName = (String)in.getHeader("CamelJmsDestinationName", String.class);
        if (destinationName != null) {
            in.removeHeader("CamelJmsDestinationName");
        }
        if (destinationName == null) {
            destinationName = this.endpoint.getDestinationName();
        }
        if ((destination = (Destination)in.getHeader("CamelJmsDestination", Destination.class)) != null) {
            in.removeHeader("CamelJmsDestination");
        }
        if (destination == null) {
            destination = this.endpoint.getDestination();
        }
        if (destination != null) {
            destinationName = null;
        }
        final String to = destinationName != null ? destinationName : "" + destination;
        InOnlyMessageSentCallback messageSentCallback = this.getEndpoint().getConfiguration().isIncludeSentJMSMessageID() ? new InOnlyMessageSentCallback(exchange) : null;
        MessageCreator messageCreator = new MessageCreator(){

            public javax.jms.Message createMessage(Session session) throws JMSException {
                javax.jms.Message answer = JmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session, null);
                Object jmsReplyTo = JmsMessageHelper.getJMSReplyTo(answer);
                if (JmsProducer.this.endpoint.isDisableReplyTo()) {
                    LOG.trace("ReplyTo is disabled on endpoint: {}", (Object)JmsProducer.this.endpoint);
                    JmsMessageHelper.setJMSReplyTo(answer, null);
                } else if (jmsReplyTo == null && (jmsReplyTo = exchange.getIn().getHeader("JMSReplyTo", String.class)) == null) {
                    jmsReplyTo = JmsProducer.this.endpoint.getReplyTo();
                }
                if (jmsReplyTo != null && !JmsProducer.this.endpoint.isPreserveMessageQos() && !JmsProducer.this.endpoint.isExplicitQosEnabled()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Disabling JMSReplyTo: {} for destination: {}. Use preserveMessageQos=true to force Camel to keep the JMSReplyTo on endpoint: {}", new Object[]{jmsReplyTo, to, JmsProducer.this.endpoint});
                    }
                    jmsReplyTo = null;
                }
                if (jmsReplyTo != null && jmsReplyTo instanceof String) {
                    String before = (String)jmsReplyTo;
                    String replyTo = JmsMessageHelper.normalizeDestinationName(before);
                    jmsReplyTo = null;
                    LOG.trace("Normalized JMSReplyTo destination name {} -> {}", (Object)before, (Object)replyTo);
                    if (JmsProducer.this.endpoint.getDestinationResolver() != null) {
                        jmsReplyTo = JmsProducer.this.endpoint.getDestinationResolver().resolveDestinationName(session, replyTo, JmsProducer.this.endpoint.isPubSubDomain());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Resolved JMSReplyTo destination {} using DestinationResolver {} as PubSubDomain {} -> {}", new Object[]{replyTo, JmsProducer.this.endpoint.getDestinationResolver(), JmsProducer.this.endpoint.isPubSubDomain(), jmsReplyTo});
                        }
                    }
                    if (jmsReplyTo == null) {
                        if (JmsProducer.this.endpoint.isPubSubDomain()) {
                            LOG.debug("Creating JMSReplyTo topic: {}", (Object)replyTo);
                            jmsReplyTo = session.createTopic(replyTo);
                        } else {
                            LOG.debug("Creating JMSReplyTo queue: {}", (Object)replyTo);
                            jmsReplyTo = session.createQueue(replyTo);
                        }
                    }
                }
                Object replyTo = null;
                if (jmsReplyTo instanceof Destination) {
                    replyTo = jmsReplyTo;
                }
                if (replyTo != null) {
                    LOG.debug("Using JMSReplyTo destination: {}", replyTo);
                    JmsMessageHelper.setJMSReplyTo(answer, replyTo);
                } else {
                    JmsProducer.this.log.trace("Not using JMSReplyTo");
                    JmsMessageHelper.setJMSReplyTo(answer, null);
                }
                LOG.trace("Created javax.jms.Message: {}", (Object)answer);
                return answer;
            }
        };
        this.doSend(false, destinationName, destination, messageCreator, messageSentCallback);
        this.setMessageId(exchange);
        callback.done(true);
        return true;
    }

    protected void doSend(boolean inOut, String destinationName, Destination destination, MessageCreator messageCreator, MessageSentCallback callback) {
        JmsConfiguration.CamelJmsTemplate template = (JmsConfiguration.CamelJmsTemplate)(inOut ? this.getInOutTemplate() : this.getInOnlyTemplate());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using {} jms template", (Object)(inOut ? "inOut" : "inOnly"));
        }
        if (destination != null) {
            if (inOut) {
                if (template != null) {
                    template.send(destination, messageCreator, callback);
                }
            } else if (template != null) {
                template.send(destination, messageCreator, callback);
            }
        } else if (destinationName != null) {
            if (inOut) {
                if (template != null) {
                    template.send(destinationName, messageCreator, callback);
                }
            } else if (template != null) {
                template.send(destinationName, messageCreator, callback);
            }
        } else {
            throw new IllegalArgumentException("Neither destination nor destinationName is specified on this endpoint: " + (Object)((Object)this.endpoint));
        }
    }

    protected void setMessageId(Exchange exchange) {
        if (exchange.hasOut()) {
            JmsMessage out = (JmsMessage)((Object)exchange.getOut(JmsMessage.class));
            try {
                if (out != null && out.getJmsMessage() != null) {
                    out.setMessageId(out.getJmsMessage().getJMSMessageID());
                }
            }
            catch (JMSException e) {
                LOG.warn("Unable to retrieve JMSMessageID from outgoing JMS Message and set it into Camel's MessageId", (Throwable)e);
            }
        }
    }

    public JmsOperations getInOnlyTemplate() {
        if (this.inOnlyTemplate == null) {
            this.inOnlyTemplate = this.endpoint.createInOnlyTemplate();
        }
        return this.inOnlyTemplate;
    }

    public void setInOnlyTemplate(JmsOperations inOnlyTemplate) {
        this.inOnlyTemplate = inOnlyTemplate;
    }

    public JmsOperations getInOutTemplate() {
        if (this.inOutTemplate == null) {
            this.inOutTemplate = this.endpoint.createInOutTemplate();
        }
        return this.inOutTemplate;
    }

    public void setInOutTemplate(JmsOperations inOutTemplate) {
        this.inOutTemplate = inOutTemplate;
    }

    public UuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    protected void testConnectionOnStartup() throws FailedToCreateProducerException {
        try {
            JmsConfiguration.CamelJmsTemplate template = (JmsConfiguration.CamelJmsTemplate)this.getInOnlyTemplate();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Testing JMS Connection on startup for destination: " + template.getDefaultDestinationName());
            }
            Connection conn = template.getConnectionFactory().createConnection();
            JmsUtils.closeConnection((Connection)conn);
            this.log.debug("Successfully tested JMS Connection on startup for destination: " + template.getDefaultDestinationName());
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException((Endpoint)this.getEndpoint(), (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.uuidGenerator == null) {
            this.uuidGenerator = this.getEndpoint().getCamelContext().getUuidGenerator();
        }
        if (this.endpoint.isTestConnectionOnStartup()) {
            this.testConnectionOnStartup();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.unInitReplyManager();
    }

    protected ReplyManager createReplyManager() throws Exception {
        TemporaryQueueReplyManager replyManager = new TemporaryQueueReplyManager(this.getEndpoint().getCamelContext());
        replyManager.setEndpoint(this.getEndpoint());
        String name = "JmsReplyManagerTimeoutChecker[" + this.getEndpoint().getEndpointConfiguredDestinationName() + "]";
        ScheduledExecutorService replyManagerExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)name, name);
        replyManager.setScheduledExecutorService(replyManagerExecutorService);
        ServiceHelper.startService((Object)replyManager);
        return replyManager;
    }

    protected ReplyManager createReplyManager(String replyTo) throws Exception {
        PersistentQueueReplyManager replyManager = new PersistentQueueReplyManager(this.getEndpoint().getCamelContext());
        replyManager.setEndpoint(this.getEndpoint());
        String name = "JmsReplyManagerTimeoutChecker[" + replyTo + "]";
        ScheduledExecutorService replyManagerExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)name, name);
        replyManager.setScheduledExecutorService(replyManagerExecutorService);
        ServiceHelper.startService((Object)replyManager);
        return replyManager;
    }
}

