/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.math.BigInteger;
import java.util.Random;
import java.util.concurrent.Executor;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.DefaultSpringErrorHandler;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.component.jms.reply.ExclusiveQueueMessageListenerContainer;
import org.apache.camel.component.jms.reply.MessageSelectorCreator;
import org.apache.camel.component.jms.reply.QueueReplyHandler;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.component.jms.reply.ReplyManagerSupport;
import org.apache.camel.component.jms.reply.SharedQueueMessageListenerContainer;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.destination.DestinationResolver;

public class QueueReplyManager
extends ReplyManagerSupport {
    private String replyToSelectorValue;
    private MessageSelectorCreator dynamicMessageSelector;

    public QueueReplyManager(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public String registerReply(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        QueueReplyHandler handler = new QueueReplyHandler(replyManager, exchange, callback, originalCorrelationId, correlationId, requestTimeout);
        this.correlation.put(correlationId, handler, requestTimeout);
        return correlationId;
    }

    @Override
    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        this.log.trace("Updated provisional correlationId [{}] to expected correlationId [{}]", (Object)correlationId, (Object)newCorrelationId);
        ReplyHandler handler = this.correlation.remove(correlationId);
        if (handler == null) {
            return;
        }
        this.correlation.put(newCorrelationId, handler, requestTimeout);
    }

    @Override
    protected void handleReplyMessage(String correlationID, javax.jms.Message message) {
        ReplyHandler handler = (ReplyHandler)this.correlation.get(correlationID);
        if (handler == null && this.endpoint.isUseMessageIDAsCorrelationID()) {
            handler = this.waitForProvisionCorrelationToBeUpdated(correlationID, message);
        }
        if (handler != null) {
            this.correlation.remove(correlationID);
            handler.onReply(correlationID, message);
        } else {
            this.log.warn("Reply received for unknown correlationID [{}]. The message will be ignored: {}", (Object)correlationID, (Object)message);
        }
    }

    @Override
    public void setReplyToSelectorHeader(Message camelMessage, javax.jms.Message jmsMessage) throws JMSException {
        String replyToSelectorName = this.endpoint.getReplyToDestinationSelectorName();
        if (replyToSelectorName != null && this.replyToSelectorValue != null) {
            camelMessage.setHeader(replyToSelectorName, (Object)this.replyToSelectorValue);
            jmsMessage.setStringProperty(replyToSelectorName, this.replyToSelectorValue);
        }
    }

    @Override
    protected AbstractMessageListenerContainer createListenerContainer() throws Exception {
        DestinationResolver resolver;
        DefaultJmsMessageListenerContainer answer;
        ReplyToType type = this.endpoint.getConfiguration().getReplyToType();
        if (type == null) {
            type = ReplyToType.Shared;
        }
        if (ReplyToType.Shared == type) {
            String replyToSelectorName = this.endpoint.getReplyToDestinationSelectorName();
            if (replyToSelectorName != null) {
                this.replyToSelectorValue = "ID:" + new BigInteger(192, new Random()).toString(16);
                String fixedMessageSelector = replyToSelectorName + "='" + this.replyToSelectorValue + "'";
                answer = new SharedQueueMessageListenerContainer(this.endpoint, fixedMessageSelector);
                answer.setCacheLevel(3);
                this.log.debug("Using shared queue: " + this.endpoint.getReplyTo() + " with fixed message selector [" + fixedMessageSelector + "] as reply listener: " + (Object)((Object)answer));
            } else {
                this.dynamicMessageSelector = new MessageSelectorCreator(this.correlation);
                answer = new SharedQueueMessageListenerContainer(this.endpoint, this.dynamicMessageSelector);
                answer.setCacheLevel(2);
                this.log.debug("Using shared queue: " + this.endpoint.getReplyTo() + " with dynamic message selector as reply listener: " + (Object)((Object)answer));
            }
            this.log.warn("{} is using a shared reply queue, which is not as fast as alternatives. See more detail at the section 'Request-reply over JMS' at http://camel.apache.org/jms", (Object)this.endpoint);
        } else if (ReplyToType.Exclusive == type) {
            answer = new ExclusiveQueueMessageListenerContainer(this.endpoint);
            answer.setCacheLevel(3);
            this.log.debug("Using exclusive queue:" + this.endpoint.getReplyTo() + " as reply listener: " + (Object)((Object)answer));
        } else {
            throw new IllegalArgumentException("ReplyToType " + (Object)((Object)type) + " is not supported for reply queues");
        }
        String replyToCacheLevelName = this.endpoint.getConfiguration().getReplyToCacheLevelName();
        if (replyToCacheLevelName != null) {
            answer.setCacheLevelName(replyToCacheLevelName);
            this.log.debug("Setting the replyCacheLevel to be " + replyToCacheLevelName);
        }
        if ((resolver = this.endpoint.getDestinationResolver()) == null) {
            resolver = answer.getDestinationResolver();
        }
        answer.setDestinationResolver(new DestinationResolverDelegate(resolver));
        answer.setDestinationName(this.endpoint.getReplyTo());
        answer.setAutoStartup(true);
        answer.setIdleConsumerLimit(this.endpoint.getIdleConsumerLimit());
        answer.setIdleTaskExecutionLimit(this.endpoint.getIdleTaskExecutionLimit());
        if (this.endpoint.getMaxMessagesPerTask() >= 0) {
            answer.setMaxMessagesPerTask(this.endpoint.getMaxMessagesPerTask());
        }
        answer.setMessageListener(this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(this.endpoint.getConcurrentConsumers());
        if (this.endpoint.getMaxConcurrentConsumers() > 0) {
            answer.setMaxConcurrentConsumers(this.endpoint.getMaxConcurrentConsumers());
        }
        answer.setConnectionFactory(this.endpoint.getConnectionFactory());
        String clientId = this.endpoint.getClientId();
        if (clientId != null) {
            clientId = clientId + ".CamelReplyManager";
            answer.setClientId(clientId);
        }
        answer.setSessionTransacted(false);
        if (this.endpoint.getExceptionListener() != null) {
            answer.setExceptionListener(this.endpoint.getExceptionListener());
        }
        if (this.endpoint.getErrorHandler() != null) {
            answer.setErrorHandler(this.endpoint.getErrorHandler());
        } else {
            answer.setErrorHandler(new DefaultSpringErrorHandler(QueueReplyManager.class, this.endpoint.getErrorHandlerLoggingLevel(), this.endpoint.isErrorHandlerLogStackTrace()));
        }
        if (this.endpoint.getReceiveTimeout() >= 0L) {
            answer.setReceiveTimeout(this.endpoint.getReceiveTimeout());
        }
        if (this.endpoint.getRecoveryInterval() >= 0L) {
            answer.setRecoveryInterval(this.endpoint.getRecoveryInterval());
        }
        if (this.endpoint.getTaskExecutor() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using custom TaskExecutor: {} on listener container: {}", (Object)this.endpoint.getTaskExecutor(), (Object)answer);
            }
            answer.setTaskExecutor((Executor)this.endpoint.getTaskExecutor());
        }
        String name = "QueueReplyManager[" + answer.getDestinationName() + "]";
        answer.setBeanName(name);
        if (answer.getConcurrentConsumers() > 1) {
            if (ReplyToType.Shared == type) {
                this.log.warn("Using {}-{} concurrent consumer on {} with shared queue {} may not work properly with all message brokers.", new Object[]{answer.getConcurrentConsumers(), answer.getMaxConcurrentConsumers(), name, this.endpoint.getReplyTo()});
            } else {
                this.log.info("Using {}-{} concurrent consumers on {}", new Object[]{answer.getConcurrentConsumers(), answer.getMaxConcurrentConsumers(), name});
            }
        }
        return answer;
    }

    private final class DestinationResolverDelegate
    implements DestinationResolver {
        private DestinationResolver delegate;
        private Destination destination;

        public DestinationResolverDelegate(DestinationResolver delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
            QueueReplyManager queueReplyManager = QueueReplyManager.this;
            synchronized (queueReplyManager) {
                if (this.destination == null) {
                    this.destination = this.delegate.resolveDestinationName(session, destinationName, pubSubDomain);
                    QueueReplyManager.this.setReplyTo(this.destination);
                }
            }
            return this.destination;
        }
    }
}

