/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.ThreadFactory;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.JmsException;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DefaultJmsMessageListenerContainer
extends DefaultMessageListenerContainer {
    private final JmsEndpoint endpoint;

    public DefaultJmsMessageListenerContainer(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    protected boolean runningAllowed() {
        return this.endpoint.isRunning();
    }

    protected TaskExecutor createDefaultTaskExecutor() {
        String beanName;
        String pattern = this.endpoint.getCamelContext().getExecutorServiceManager().getThreadNamePattern();
        String string = beanName = this.getBeanName() == null ? this.endpoint.getThreadName() : this.getBeanName();
        if (this.endpoint.getDefaultTaskExecutorType() == DefaultTaskExecutorType.ThreadPool) {
            ThreadPoolTaskExecutor answer = new ThreadPoolTaskExecutor();
            answer.setBeanName(beanName);
            answer.setThreadFactory((ThreadFactory)new CamelThreadFactory(pattern, beanName, true));
            answer.setCorePoolSize(this.endpoint.getConcurrentConsumers());
            answer.setQueueCapacity(0);
            answer.initialize();
            return answer;
        }
        SimpleAsyncTaskExecutor answer = new SimpleAsyncTaskExecutor(beanName);
        answer.setThreadFactory((ThreadFactory)new CamelThreadFactory(pattern, beanName, true));
        return answer;
    }

    public void stop() throws JmsException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Stopping listenerContainer: " + (Object)((Object)this) + " with cacheLevel: " + this.getCacheLevel() + " and sharedConnectionEnabled: " + this.sharedConnectionEnabled()));
        }
        super.stop();
    }

    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Destroying listenerContainer: " + (Object)((Object)this) + " with cacheLevel: " + this.getCacheLevel() + " and sharedConnectionEnabled: " + this.sharedConnectionEnabled()));
        }
        super.destroy();
    }

    protected void stopSharedConnection() {
        if (this.logger.isDebugEnabled() && this.sharedConnectionEnabled()) {
            this.logger.debug((Object)("Stopping shared connection on listenerContainer: " + (Object)((Object)this)));
        }
        super.stopSharedConnection();
    }
}

