/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.Executor;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.DefaultSpringErrorHandler;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.DestinationEndpoint;
import org.apache.camel.component.jms.EndpointMessageListener;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.JmsProviderMetadata;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.MessageSentCallback;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.component.jms.SimpleJmsMessageListenerContainer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

@UriParams
public class JmsConfiguration
implements Cloneable {
    public static final String QUEUE_PREFIX = "queue:";
    public static final String TOPIC_PREFIX = "topic:";
    public static final String TEMP_QUEUE_PREFIX = "temp:queue:";
    public static final String TEMP_TOPIC_PREFIX = "temp:topic:";
    private static final Logger LOG = LoggerFactory.getLogger(JmsConfiguration.class);
    private JmsOperations jmsOperations;
    private DestinationResolver destinationResolver;
    private ConnectionFactory connectionFactory;
    private ConnectionFactory templateConnectionFactory;
    private ConnectionFactory listenerConnectionFactory;
    private int acknowledgementMode = -1;
    @UriParam(defaultValue="AUTO_ACKNOWLEDGE", enums="SESSION_TRANSACTED,CLIENT_ACKNOWLEDGE,AUTO_ACKNOWLEDGE,DUPS_OK_ACKNOWLEDGE")
    private String acknowledgementModeName;
    @UriParam
    private ExceptionListener exceptionListener;
    @UriParam(label="consumer", defaultValue="Default")
    private ConsumerType consumerType = ConsumerType.Default;
    @UriParam
    private ErrorHandler errorHandler;
    @UriParam(defaultValue="WARN")
    private LoggingLevel errorHandlerLoggingLevel = LoggingLevel.WARN;
    @UriParam(defaultValue="true")
    private boolean errorHandlerLogStackTrace = true;
    @UriParam(label="consumer", defaultValue="true")
    private boolean autoStartup = true;
    @UriParam(label="consumer")
    private boolean acceptMessagesWhileStopping;
    @UriParam
    private String clientId;
    @UriParam
    private String durableSubscriptionName;
    @Deprecated
    private boolean subscriptionDurable;
    @UriParam
    private boolean exposeListenerSession = true;
    private TaskExecutor taskExecutor;
    @UriParam
    private boolean pubSubNoLocal;
    @UriParam(defaultValue="1")
    private int concurrentConsumers = 1;
    @UriParam(defaultValue="1")
    private int replyToConcurrentConsumers = 1;
    @UriParam(defaultValue="-1")
    private int maxMessagesPerTask = -1;
    private int cacheLevel = -1;
    @UriParam(defaultValue="CACHE_AUTO", enums="CACHE_AUTO,CACHE_CONNECTION,CACHE_CONSUMER,CACHE_NONE,CACHE_SESSION")
    private String cacheLevelName;
    @UriParam(defaultValue="5000")
    private long recoveryInterval = 5000L;
    @UriParam(defaultValue="1000")
    private long receiveTimeout = 1000L;
    @UriParam(label="producer", defaultValue="20000")
    private long requestTimeout = 20000L;
    @UriParam(defaultValue="1000")
    private long requestTimeoutCheckerInterval = 1000L;
    @UriParam(defaultValue="1")
    private int idleTaskExecutionLimit = 1;
    @UriParam(defaultValue="1")
    private int idleConsumerLimit = 1;
    @UriParam
    private int maxConcurrentConsumers;
    @UriParam
    private int replyToMaxConcurrentConsumers;
    @UriParam
    private Boolean explicitQosEnabled;
    @UriParam(defaultValue="true")
    private boolean deliveryPersistent = true;
    @UriParam(enums="1,2")
    private Integer deliveryMode;
    @UriParam(defaultValue="true")
    private boolean replyToDeliveryPersistent = true;
    @UriParam(defaultValue="-1")
    private long timeToLive = -1L;
    private MessageConverter messageConverter;
    @UriParam(defaultValue="true")
    private boolean mapJmsMessage = true;
    @UriParam(defaultValue="true")
    private boolean messageIdEnabled = true;
    @UriParam(defaultValue="true")
    private boolean messageTimestampEnabled = true;
    @UriParam(defaultValue="4", enums="1,2,3,4,5,6,7,8,9")
    private int priority = 4;
    @UriParam
    private boolean transacted;
    private boolean transactedInOut;
    @UriParam(defaultValue="true")
    private boolean lazyCreateTransactionManager = true;
    private PlatformTransactionManager transactionManager;
    @UriParam
    private String transactionName;
    @UriParam(defaultValue="-1")
    private int transactionTimeout = -1;
    @UriParam
    private boolean preserveMessageQos;
    @UriParam
    private boolean disableReplyTo;
    @UriParam
    private boolean eagerLoadingOfProperties;
    @UriParam
    private boolean alwaysCopyMessage;
    @UriParam
    private boolean useMessageIDAsCorrelationID;
    private JmsProviderMetadata providerMetadata = new JmsProviderMetadata();
    private JmsOperations metadataJmsOperations;
    @UriParam
    private String replyTo;
    @UriParam
    private String replyToDestinationSelectorName;
    @UriParam
    private String replyToOverride;
    @UriParam(enums="Bytes,Map,Object,Stream,Text")
    private JmsMessageType jmsMessageType;
    @UriParam
    private JmsKeyFormatStrategy jmsKeyFormatStrategy;
    @UriParam
    private boolean transferExchange;
    @UriParam
    private boolean transferException;
    @UriParam
    private boolean testConnectionOnStartup;
    @UriParam
    private boolean asyncStartListener;
    @UriParam
    private boolean asyncStopListener;
    @UriParam
    private boolean forceSendOriginalMessage;
    @UriParam
    private boolean disableTimeToLive;
    @UriParam
    private ReplyToType replyToType;
    @UriParam(label="consumer")
    private boolean asyncConsumer;
    @UriParam
    private String replyToCacheLevelName;
    @UriParam(defaultValue="true")
    private boolean allowNullBody = true;
    private MessageListenerContainerFactory messageListenerContainerFactory;
    @UriParam
    private boolean includeSentJMSMessageID;
    @UriParam
    private DefaultTaskExecutorType defaultTaskExecutorType;
    @UriParam
    private boolean includeAllJMSXProperties;
    @UriParam
    private MessageCreatedStrategy messageCreatedStrategy;

    public JmsConfiguration() {
    }

    public JmsConfiguration(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public JmsConfiguration copy() {
        try {
            return (JmsConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public JmsOperations createInOutTemplate(JmsEndpoint endpoint, boolean pubSubDomain, String destination, long requestTimeout) {
        JmsOperations answer = this.createInOnlyTemplate(endpoint, pubSubDomain, destination);
        if (answer instanceof JmsTemplate && requestTimeout > 0L) {
            long ttl;
            JmsTemplate jmsTemplate = (JmsTemplate)answer;
            jmsTemplate.setExplicitQosEnabled(true);
            long l = ttl = this.timeToLive > 0L ? this.timeToLive : requestTimeout;
            if (ttl > 0L && !this.isDisableTimeToLive()) {
                jmsTemplate.setTimeToLive(ttl);
            }
            jmsTemplate.setSessionTransacted(this.isTransactedInOut());
            if (this.isTransactedInOut()) {
                jmsTemplate.setSessionAcknowledgeMode(0);
            } else if (this.acknowledgementMode >= 0) {
                jmsTemplate.setSessionAcknowledgeMode(this.acknowledgementMode);
            } else if (this.acknowledgementModeName != null) {
                jmsTemplate.setSessionAcknowledgeModeName(this.acknowledgementModeName);
            } else {
                jmsTemplate.setSessionAcknowledgeMode(1);
            }
        }
        return answer;
    }

    public JmsOperations createInOnlyTemplate(JmsEndpoint endpoint, boolean pubSubDomain, String destination) {
        if (this.jmsOperations != null) {
            return this.jmsOperations;
        }
        ConnectionFactory factory = this.getTemplateConnectionFactory();
        CamelJmsTemplate template = new CamelJmsTemplate(this, factory);
        template.setPubSubDomain(pubSubDomain);
        if (this.destinationResolver != null) {
            template.setDestinationResolver(this.destinationResolver);
            if (endpoint instanceof DestinationEndpoint) {
                LOG.debug("You are overloading the destinationResolver property on a DestinationEndpoint; are you sure you want to do that?");
            }
        } else if (endpoint instanceof DestinationEndpoint) {
            DestinationEndpoint destinationEndpoint = (DestinationEndpoint)((Object)endpoint);
            template.setDestinationResolver(JmsConfiguration.createDestinationResolver(destinationEndpoint));
        }
        template.setDefaultDestinationName(destination);
        template.setExplicitQosEnabled(this.isExplicitQosEnabled());
        if (this.deliveryMode != null) {
            template.setDeliveryMode(this.deliveryMode);
        } else {
            template.setDeliveryPersistent(this.deliveryPersistent);
        }
        if (this.messageConverter != null) {
            template.setMessageConverter(this.messageConverter);
        }
        template.setMessageIdEnabled(this.messageIdEnabled);
        template.setMessageTimestampEnabled(this.messageTimestampEnabled);
        if (this.priority >= 0) {
            template.setPriority(this.priority);
        }
        template.setPubSubNoLocal(this.pubSubNoLocal);
        if (this.timeToLive >= 0L && !this.isDisableTimeToLive()) {
            template.setTimeToLive(this.timeToLive);
        }
        template.setSessionTransacted(this.transacted);
        if (this.transacted) {
            template.setSessionAcknowledgeMode(0);
        } else if (this.acknowledgementMode >= 0) {
            template.setSessionAcknowledgeMode(this.acknowledgementMode);
        } else if (this.acknowledgementModeName != null) {
            template.setSessionAcknowledgeModeName(this.acknowledgementModeName);
        }
        return template;
    }

    public AbstractMessageListenerContainer createMessageListenerContainer(JmsEndpoint endpoint) throws Exception {
        AbstractMessageListenerContainer container = this.chooseMessageListenerContainerImplementation(endpoint);
        this.configureMessageListenerContainer(container, endpoint);
        return container;
    }

    public AbstractMessageListenerContainer chooseMessageListenerContainerImplementation(JmsEndpoint endpoint) {
        switch (this.consumerType) {
            case Simple: {
                return new SimpleJmsMessageListenerContainer(endpoint);
            }
            case Default: {
                return new DefaultJmsMessageListenerContainer(endpoint);
            }
            case Custom: {
                return this.getCustomMessageListenerContainer(endpoint);
            }
        }
        throw new IllegalArgumentException("Unknown consumer type: " + (Object)((Object)this.consumerType));
    }

    private AbstractMessageListenerContainer getCustomMessageListenerContainer(JmsEndpoint endpoint) {
        if (this.messageListenerContainerFactory != null) {
            return this.messageListenerContainerFactory.createMessageListenerContainer(endpoint);
        }
        return null;
    }

    public ConsumerType getConsumerType() {
        return this.consumerType;
    }

    public void setConsumerType(ConsumerType consumerType) {
        this.consumerType = consumerType;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getListenerConnectionFactory() {
        if (this.listenerConnectionFactory == null) {
            this.listenerConnectionFactory = this.createListenerConnectionFactory();
        }
        return this.listenerConnectionFactory;
    }

    public void setListenerConnectionFactory(ConnectionFactory listenerConnectionFactory) {
        this.listenerConnectionFactory = listenerConnectionFactory;
    }

    public ConnectionFactory getTemplateConnectionFactory() {
        if (this.templateConnectionFactory == null) {
            this.templateConnectionFactory = this.createTemplateConnectionFactory();
        }
        return this.templateConnectionFactory;
    }

    public void setTemplateConnectionFactory(ConnectionFactory templateConnectionFactory) {
        this.templateConnectionFactory = templateConnectionFactory;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAcceptMessagesWhileStopping() {
        return this.acceptMessagesWhileStopping;
    }

    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.acceptMessagesWhileStopping = acceptMessagesWhileStopping;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String consumerClientId) {
        this.clientId = consumerClientId;
    }

    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public LoggingLevel getErrorHandlerLoggingLevel() {
        return this.errorHandlerLoggingLevel;
    }

    public void setErrorHandlerLoggingLevel(LoggingLevel errorHandlerLoggingLevel) {
        this.errorHandlerLoggingLevel = errorHandlerLoggingLevel;
    }

    public boolean isErrorHandlerLogStackTrace() {
        return this.errorHandlerLogStackTrace;
    }

    public void setErrorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
        this.errorHandlerLogStackTrace = errorHandlerLogStackTrace;
    }

    @Deprecated
    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    @Deprecated
    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    public String getAcknowledgementModeName() {
        return this.acknowledgementModeName;
    }

    public void setAcknowledgementModeName(String consumerAcknowledgementMode) {
        this.acknowledgementModeName = consumerAcknowledgementMode;
        this.acknowledgementMode = -1;
    }

    public boolean isExposeListenerSession() {
        return this.exposeListenerSession;
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.exposeListenerSession = exposeListenerSession;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getReplyToConcurrentConsumers() {
        return this.replyToConcurrentConsumers;
    }

    public void setReplyToConcurrentConsumers(int replyToConcurrentConsumers) {
        this.replyToConcurrentConsumers = replyToConcurrentConsumers;
    }

    public int getMaxMessagesPerTask() {
        return this.maxMessagesPerTask;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public String getCacheLevelName() {
        return this.cacheLevelName;
    }

    public void setCacheLevelName(String cacheName) {
        this.cacheLevelName = cacheName;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.transactionManager == null && this.isTransacted() && this.isLazyCreateTransactionManager()) {
            this.transactionManager = this.createTransactionManager();
        }
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public int getIdleTaskExecutionLimit() {
        return this.idleTaskExecutionLimit;
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.idleTaskExecutionLimit = idleTaskExecutionLimit;
    }

    public int getIdleConsumerLimit() {
        return this.idleConsumerLimit;
    }

    public void setIdleConsumerLimit(int idleConsumerLimit) {
        this.idleConsumerLimit = idleConsumerLimit;
    }

    public int getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public int getReplyToMaxConcurrentConsumers() {
        return this.replyToMaxConcurrentConsumers;
    }

    public void setReplyToMaxConcurrentConsumers(int replyToMaxConcurrentConsumers) {
        this.replyToMaxConcurrentConsumers = replyToMaxConcurrentConsumers;
    }

    public boolean isExplicitQosEnabled() {
        return this.explicitQosEnabled != null ? this.explicitQosEnabled : false;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public boolean isDeliveryPersistent() {
        return this.deliveryPersistent;
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.deliveryPersistent = deliveryPersistent;
        this.configuredQoS();
    }

    public Integer getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(Integer deliveryMode) {
        this.deliveryMode = deliveryMode;
        this.configuredQoS();
    }

    public boolean isReplyToDeliveryPersistent() {
        return this.replyToDeliveryPersistent;
    }

    public void setReplyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
        this.replyToDeliveryPersistent = replyToDeliveryPersistent;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        this.configuredQoS();
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public boolean isMapJmsMessage() {
        return this.mapJmsMessage;
    }

    public void setMapJmsMessage(boolean mapJmsMessage) {
        this.mapJmsMessage = mapJmsMessage;
    }

    public boolean isMessageIdEnabled() {
        return this.messageIdEnabled;
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.messageIdEnabled = messageIdEnabled;
    }

    public boolean isMessageTimestampEnabled() {
        return this.messageTimestampEnabled;
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.messageTimestampEnabled = messageTimestampEnabled;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.configuredQoS();
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int consumerAcknowledgementMode) {
        this.acknowledgementMode = consumerAcknowledgementMode;
        this.acknowledgementModeName = null;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean consumerTransacted) {
        this.transacted = consumerTransacted;
    }

    @Deprecated
    public boolean isTransactedInOut() {
        return this.transactedInOut;
    }

    @Deprecated
    public void setTransactedInOut(boolean transactedInOut) {
        this.transactedInOut = transactedInOut;
    }

    public boolean isLazyCreateTransactionManager() {
        return this.lazyCreateTransactionManager;
    }

    public void setLazyCreateTransactionManager(boolean lazyCreating) {
        this.lazyCreateTransactionManager = lazyCreating;
    }

    public boolean isEagerLoadingOfProperties() {
        return this.eagerLoadingOfProperties;
    }

    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.eagerLoadingOfProperties = eagerLoadingOfProperties;
    }

    public boolean isDisableReplyTo() {
        return this.disableReplyTo;
    }

    public void setDisableReplyTo(boolean disableReplyTo) {
        this.disableReplyTo = disableReplyTo;
    }

    public void setPreserveMessageQos(boolean preserveMessageQos) {
        this.preserveMessageQos = preserveMessageQos;
    }

    public JmsOperations getJmsOperations() {
        return this.jmsOperations;
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.jmsOperations = jmsOperations;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public JmsProviderMetadata getProviderMetadata() {
        return this.providerMetadata;
    }

    public void setProviderMetadata(JmsProviderMetadata providerMetadata) {
        this.providerMetadata = providerMetadata;
    }

    public JmsOperations getMetadataJmsOperations(JmsEndpoint endpoint) {
        if (this.metadataJmsOperations == null) {
            this.metadataJmsOperations = this.getJmsOperations();
            if (this.metadataJmsOperations == null) {
                this.metadataJmsOperations = this.createInOnlyTemplate(endpoint, false, null);
            }
        }
        return this.metadataJmsOperations;
    }

    public void setMetadataJmsOperations(JmsOperations metadataJmsOperations) {
        this.metadataJmsOperations = metadataJmsOperations;
    }

    public static DestinationResolver createDestinationResolver(final DestinationEndpoint destinationEndpoint) {
        return new DestinationResolver(){

            public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
                return destinationEndpoint.getJmsDestination(session);
            }
        };
    }

    protected void configureMessageListenerContainer(AbstractMessageListenerContainer container, JmsEndpoint endpoint) throws Exception {
        DefaultMessageListenerContainer listenerContainer;
        container.setConnectionFactory(this.getListenerConnectionFactory());
        if (endpoint instanceof DestinationEndpoint) {
            container.setDestinationResolver(JmsConfiguration.createDestinationResolver((DestinationEndpoint)((Object)endpoint)));
        } else if (this.destinationResolver != null) {
            container.setDestinationResolver(this.destinationResolver);
        }
        container.setAutoStartup(this.autoStartup);
        if (this.durableSubscriptionName != null) {
            container.setDurableSubscriptionName(this.durableSubscriptionName);
            container.setSubscriptionDurable(true);
        }
        if (this.clientId != null) {
            container.setClientId(this.clientId);
        }
        if (this.exceptionListener != null) {
            container.setExceptionListener(this.exceptionListener);
        }
        if (this.errorHandler != null) {
            container.setErrorHandler(this.errorHandler);
        } else {
            DefaultSpringErrorHandler handler = new DefaultSpringErrorHandler(endpoint.getCamelContext(), EndpointMessageListener.class, this.getErrorHandlerLoggingLevel(), this.isErrorHandlerLogStackTrace());
            container.setErrorHandler((ErrorHandler)handler);
        }
        container.setAcceptMessagesWhileStopping(this.acceptMessagesWhileStopping);
        container.setExposeListenerSession(this.exposeListenerSession);
        container.setSessionTransacted(this.transacted);
        if (this.transacted) {
            container.setSessionAcknowledgeMode(0);
        } else if (this.acknowledgementMode >= 0) {
            container.setSessionAcknowledgeMode(this.acknowledgementMode);
        } else if (this.acknowledgementModeName != null) {
            container.setSessionAcknowledgeModeName(this.acknowledgementModeName);
        }
        if (endpoint.getSelector() != null && endpoint.getSelector().length() != 0) {
            container.setMessageSelector(endpoint.getSelector());
        }
        if (container instanceof DefaultMessageListenerContainer) {
            listenerContainer = (DefaultMessageListenerContainer)container;
            this.configureDefaultMessageListenerContainer(endpoint, listenerContainer);
        } else if (container instanceof SimpleMessageListenerContainer) {
            listenerContainer = (SimpleMessageListenerContainer)container;
            this.configureSimpleMessageListenerContainer((SimpleMessageListenerContainer)listenerContainer);
        }
    }

    private void configureSimpleMessageListenerContainer(SimpleMessageListenerContainer listenerContainer) {
        if (this.maxConcurrentConsumers > 0) {
            if (this.maxConcurrentConsumers < this.concurrentConsumers) {
                throw new IllegalArgumentException("Property maxConcurrentConsumers: " + this.maxConcurrentConsumers + " must be higher than concurrentConsumers: " + this.concurrentConsumers);
            }
            listenerContainer.setConcurrency(this.concurrentConsumers + "-" + this.maxConcurrentConsumers);
        } else if (this.concurrentConsumers >= 0) {
            listenerContainer.setConcurrentConsumers(this.concurrentConsumers);
        }
        listenerContainer.setPubSubNoLocal(this.pubSubNoLocal);
        if (this.taskExecutor != null) {
            listenerContainer.setTaskExecutor((Executor)this.taskExecutor);
        }
    }

    private void configureDefaultMessageListenerContainer(JmsEndpoint endpoint, DefaultMessageListenerContainer container) {
        PlatformTransactionManager tm;
        if (this.concurrentConsumers >= 0) {
            container.setConcurrentConsumers(this.concurrentConsumers);
        }
        if (this.cacheLevel >= 0) {
            container.setCacheLevel(this.cacheLevel);
        } else if (this.cacheLevelName != null) {
            container.setCacheLevelName(this.cacheLevelName);
        } else {
            container.setCacheLevel(this.defaultCacheLevel(endpoint));
        }
        if (this.idleTaskExecutionLimit >= 0) {
            container.setIdleTaskExecutionLimit(this.idleTaskExecutionLimit);
        }
        if (this.idleConsumerLimit >= 0) {
            container.setIdleConsumerLimit(this.idleConsumerLimit);
        }
        if (this.maxConcurrentConsumers > 0) {
            if (this.maxConcurrentConsumers < this.concurrentConsumers) {
                throw new IllegalArgumentException("Property maxConcurrentConsumers: " + this.maxConcurrentConsumers + " must be higher than concurrentConsumers: " + this.concurrentConsumers);
            }
            container.setMaxConcurrentConsumers(this.maxConcurrentConsumers);
        }
        if (this.maxMessagesPerTask >= 0) {
            container.setMaxMessagesPerTask(this.maxMessagesPerTask);
        }
        container.setPubSubNoLocal(this.pubSubNoLocal);
        if (this.receiveTimeout >= 0L) {
            container.setReceiveTimeout(this.receiveTimeout);
        }
        if (this.recoveryInterval >= 0L) {
            container.setRecoveryInterval(this.recoveryInterval);
        }
        if (this.taskExecutor != null) {
            container.setTaskExecutor((Executor)this.taskExecutor);
        }
        if ((tm = this.getTransactionManager()) != null) {
            container.setTransactionManager(tm);
        } else if (this.transactionManager == null && this.transacted && !this.lazyCreateTransactionManager) {
            container.setSessionTransacted(true);
        }
        if (this.transactionName != null) {
            container.setTransactionName(this.transactionName);
        }
        if (this.transactionTimeout >= 0) {
            container.setTransactionTimeout(this.transactionTimeout);
        }
    }

    public void configureMessageListener(EndpointMessageListener listener) {
        JmsOperations operations;
        if (this.isDisableReplyTo()) {
            listener.setDisableReplyTo(true);
        }
        if (this.isEagerLoadingOfProperties()) {
            listener.setEagerLoadingOfProperties(true);
        }
        if (this.getReplyTo() != null) {
            listener.setReplyToDestination(this.getReplyTo());
        }
        if ((operations = listener.getTemplate()) instanceof JmsTemplate) {
            JmsTemplate template = (JmsTemplate)operations;
            template.setDeliveryPersistent(this.isReplyToDeliveryPersistent());
        }
    }

    protected int defaultCacheLevel(JmsEndpoint endpoint) {
        return 4;
    }

    protected ConnectionFactory createConnectionFactory() {
        ObjectHelper.notNull((Object)this.connectionFactory, (String)"connectionFactory");
        return null;
    }

    protected ConnectionFactory createListenerConnectionFactory() {
        return this.getConnectionFactory();
    }

    protected ConnectionFactory createTemplateConnectionFactory() {
        return this.getConnectionFactory();
    }

    protected PlatformTransactionManager createTransactionManager() {
        JmsTransactionManager answer = new JmsTransactionManager();
        answer.setConnectionFactory(this.getConnectionFactory());
        return answer;
    }

    public boolean isPreserveMessageQos() {
        return this.preserveMessageQos;
    }

    protected void configuredQoS() {
        if (this.explicitQosEnabled == null) {
            this.explicitQosEnabled = true;
        }
    }

    public boolean isAlwaysCopyMessage() {
        return this.alwaysCopyMessage;
    }

    public void setAlwaysCopyMessage(boolean alwaysCopyMessage) {
        this.alwaysCopyMessage = alwaysCopyMessage;
    }

    public boolean isUseMessageIDAsCorrelationID() {
        return this.useMessageIDAsCorrelationID;
    }

    public void setUseMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
        this.useMessageIDAsCorrelationID = useMessageIDAsCorrelationID;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getRequestTimeoutCheckerInterval() {
        return this.requestTimeoutCheckerInterval;
    }

    public void setRequestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
        this.requestTimeoutCheckerInterval = requestTimeoutCheckerInterval;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyToDestination) {
        this.replyTo = JmsMessageHelper.normalizeDestinationName(replyToDestination);
    }

    public String getReplyToDestinationSelectorName() {
        return this.replyToDestinationSelectorName;
    }

    public void setReplyToDestinationSelectorName(String replyToDestinationSelectorName) {
        this.replyToDestinationSelectorName = replyToDestinationSelectorName;
        if (replyToDestinationSelectorName != null) {
            this.setAlwaysCopyMessage(true);
        }
    }

    public String getReplyToOverride() {
        return this.replyToOverride;
    }

    public void setReplyToOverride(String replyToDestination) {
        this.replyToOverride = JmsMessageHelper.normalizeDestinationName(replyToDestination);
    }

    public JmsMessageType getJmsMessageType() {
        return this.jmsMessageType;
    }

    public void setJmsMessageType(JmsMessageType jmsMessageType) {
        if (jmsMessageType == JmsMessageType.Blob && !this.supportBlobMessage()) {
            throw new IllegalArgumentException("BlobMessage is not supported by this implementation");
        }
        this.jmsMessageType = jmsMessageType;
    }

    protected boolean supportBlobMessage() {
        return false;
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        if (this.jmsKeyFormatStrategy == null) {
            this.jmsKeyFormatStrategy = new DefaultJmsKeyFormatStrategy();
        }
        return this.jmsKeyFormatStrategy;
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
        this.jmsKeyFormatStrategy = jmsKeyFormatStrategy;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }

    public void setTransferExchange(boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public boolean isAsyncStartListener() {
        return this.asyncStartListener;
    }

    public void setAsyncStartListener(boolean asyncStartListener) {
        this.asyncStartListener = asyncStartListener;
    }

    public boolean isAsyncStopListener() {
        return this.asyncStopListener;
    }

    public void setAsyncStopListener(boolean asyncStopListener) {
        this.asyncStopListener = asyncStopListener;
    }

    public boolean isTestConnectionOnStartup() {
        return this.testConnectionOnStartup;
    }

    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.testConnectionOnStartup = testConnectionOnStartup;
    }

    public void setForceSendOriginalMessage(boolean forceSendOriginalMessage) {
        this.forceSendOriginalMessage = forceSendOriginalMessage;
    }

    public boolean isForceSendOriginalMessage() {
        return this.forceSendOriginalMessage;
    }

    public boolean isDisableTimeToLive() {
        return this.disableTimeToLive;
    }

    public void setDisableTimeToLive(boolean disableTimeToLive) {
        this.disableTimeToLive = disableTimeToLive;
    }

    public ReplyToType getReplyToType() {
        return this.replyToType;
    }

    public void setReplyToType(ReplyToType replyToType) {
        this.replyToType = replyToType;
    }

    public boolean isAsyncConsumer() {
        return this.asyncConsumer;
    }

    public void setAsyncConsumer(boolean asyncConsumer) {
        this.asyncConsumer = asyncConsumer;
    }

    public void setReplyToCacheLevelName(String name) {
        this.replyToCacheLevelName = name;
    }

    public String getReplyToCacheLevelName() {
        return this.replyToCacheLevelName;
    }

    public boolean isAllowNullBody() {
        return this.allowNullBody;
    }

    public void setAllowNullBody(boolean allowNullBody) {
        this.allowNullBody = allowNullBody;
    }

    public MessageListenerContainerFactory getMessageListenerContainerFactory() {
        return this.messageListenerContainerFactory;
    }

    public void setMessageListenerContainerFactory(MessageListenerContainerFactory messageListenerContainerFactory) {
        this.messageListenerContainerFactory = messageListenerContainerFactory;
    }

    public boolean isIncludeSentJMSMessageID() {
        return this.includeSentJMSMessageID;
    }

    public void setIncludeSentJMSMessageID(boolean includeSentJMSMessageID) {
        this.includeSentJMSMessageID = includeSentJMSMessageID;
    }

    public DefaultTaskExecutorType getDefaultTaskExecutorType() {
        return this.defaultTaskExecutorType;
    }

    public void setDefaultTaskExecutorType(DefaultTaskExecutorType defaultTaskExecutorType) {
        this.defaultTaskExecutorType = defaultTaskExecutorType;
    }

    public boolean isIncludeAllJMSXProperties() {
        return this.includeAllJMSXProperties;
    }

    public void setIncludeAllJMSXProperties(boolean includeAllJMSXProperties) {
        this.includeAllJMSXProperties = includeAllJMSXProperties;
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return this.messageCreatedStrategy;
    }

    public void setMessageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
        this.messageCreatedStrategy = messageCreatedStrategy;
    }

    public static class CamelJmsTemplate
    extends JmsTemplate {
        private JmsConfiguration config;

        public CamelJmsTemplate(JmsConfiguration config, ConnectionFactory connectionFactory) {
            super(connectionFactory);
            this.config = config;
        }

        public void send(final String destinationName, final MessageCreator messageCreator, final MessageSentCallback callback) throws JmsException {
            this.execute((SessionCallback)new SessionCallback<Object>(){

                public Object doInJms(Session session) throws JMSException {
                    Destination destination = CamelJmsTemplate.this.resolveDestinationName(session, destinationName);
                    return CamelJmsTemplate.this.doSendToDestination(destination, messageCreator, callback, session);
                }
            }, false);
        }

        public void send(final Destination destination, final MessageCreator messageCreator, final MessageSentCallback callback) throws JmsException {
            this.execute((SessionCallback)new SessionCallback<Object>(){

                public Object doInJms(Session session) throws JMSException {
                    return CamelJmsTemplate.this.doSendToDestination(destination, messageCreator, callback, session);
                }
            }, false);
        }

        public void send(final String destinationName, final MessageCreator messageCreator) throws JmsException {
            this.execute((SessionCallback)new SessionCallback<Object>(){

                public Object doInJms(Session session) throws JMSException {
                    Destination destination = CamelJmsTemplate.this.resolveDestinationName(session, destinationName);
                    return CamelJmsTemplate.this.doSendToDestination(destination, messageCreator, null, session);
                }
            }, false);
        }

        public void send(final Destination destination, final MessageCreator messageCreator) throws JmsException {
            this.execute((SessionCallback)new SessionCallback<Object>(){

                public Object doInJms(Session session) throws JMSException {
                    return CamelJmsTemplate.this.doSendToDestination(destination, messageCreator, null, session);
                }
            }, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object doSendToDestination(Destination destination, MessageCreator messageCreator, MessageSentCallback callback, Session session) throws JMSException {
            Assert.notNull((Object)messageCreator, (String)"MessageCreator must not be null");
            MessageProducer producer = this.createProducer(session, destination);
            try {
                Message message = messageCreator.createMessage(session);
                this.doSend(producer, message);
                if (message != null && callback != null) {
                    callback.sent(session, message, destination);
                }
                if (session.getTransacted() && this.isSessionLocallyTransacted(session)) {
                    JmsUtils.commitIfNecessary((Session)session);
                }
            }
            finally {
                JmsUtils.closeMessageProducer((MessageProducer)producer);
            }
            return null;
        }

        protected void doSend(MessageProducer producer, Message message) throws JMSException {
            if (this.config.isPreserveMessageQos()) {
                int deliveryMode;
                int priority;
                long ttl = message.getJMSExpiration();
                if (ttl != 0L && (ttl -= System.currentTimeMillis()) <= 0L) {
                    ttl = 1L;
                }
                if ((priority = message.getJMSPriority()) < 0 || priority > 9) {
                    priority = this.getPriority();
                }
                if (JmsMessageHelper.hasProperty(message, "CamelJmsDeliveryMode")) {
                    deliveryMode = message.getIntProperty("CamelJmsDeliveryMode");
                    JmsMessageHelper.removeJmsProperty(message, "CamelJmsDeliveryMode");
                } else {
                    deliveryMode = message.getJMSDeliveryMode();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending JMS message to: {} with message: {}", (Object)producer.getDestination(), (Object)message);
                }
                producer.send(message, deliveryMode, priority, ttl);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending JMS message to: {} with message: {}", (Object)producer.getDestination(), (Object)message);
                }
                super.doSend(producer, message);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Sent JMS message to: {} with message: {}", (Object)producer.getDestination(), (Object)message);
                }
            }
        }
    }
}

