/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jmx.JMXEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.EndpointHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXComponent
extends DefaultComponent {
    protected Endpoint createEndpoint(String aUri, String aRemaining, Map<String, Object> aParameters) throws Exception {
        JMXEndpoint endpoint = new JMXEndpoint(aUri, this);
        EndpointHelper.setReferenceProperties((CamelContext)this.getCamelContext(), (Object)((Object)endpoint), aParameters);
        EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)((Object)endpoint), aParameters);
        endpoint.setServerURL(aRemaining);
        if (!aParameters.isEmpty()) {
            Hashtable<String, String> objectProperties = new Hashtable<String, String>();
            Iterator<Map.Entry<String, Object>> it = aParameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                if (!entry.getKey().startsWith("key.")) continue;
                objectProperties.put(entry.getKey().substring("key.".length()), entry.getValue().toString());
                it.remove();
            }
            endpoint.setObjectProperties(objectProperties);
        }
        if (endpoint.getObjectDomain() == null) {
            throw new IllegalArgumentException("Must specify domain");
        }
        if (endpoint.getObjectName() == null && endpoint.getObjectProperties() == null) {
            throw new IllegalArgumentException("Must specify object name or object properties");
        }
        return endpoint;
    }
}

