/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXUriBuilder {
    private Map<String, String> mQueryProps = new LinkedHashMap<String, String>();
    private String mServerName = "platform";

    public JMXUriBuilder() {
    }

    public JMXUriBuilder(String aServerName) {
        this.setServerName(aServerName);
    }

    public JMXUriBuilder withFormat(String aFormat) {
        this.addProperty("format", aFormat);
        return this;
    }

    public JMXUriBuilder withUser(String aFormat) {
        this.addProperty("user", aFormat);
        return this;
    }

    public JMXUriBuilder withPassword(String aFormat) {
        this.addProperty("password", aFormat);
        return this;
    }

    public JMXUriBuilder withObjectDomain(String aFormat) {
        this.addProperty("objectDomain", aFormat);
        return this;
    }

    public JMXUriBuilder withObjectName(String aFormat) {
        this.addProperty("objectName", aFormat);
        return this;
    }

    public JMXUriBuilder withNotificationFilter(String aFilter) {
        this.addProperty("notificationFilter", aFilter);
        return this;
    }

    public JMXUriBuilder withHandback(String aHandback) {
        this.addProperty("handback", aHandback);
        return this;
    }

    public JMXUriBuilder withObjectProperties(Map<String, String> aPropertiesSansKeyPrefix) {
        for (Map.Entry<String, String> entry : aPropertiesSansKeyPrefix.entrySet()) {
            this.addProperty("key." + entry.getKey(), entry.getValue());
        }
        return this;
    }

    public JMXUriBuilder withObjectPropertiesReference(String aReferenceToHashtable) {
        if (aReferenceToHashtable.startsWith("#")) {
            this.addProperty("objectProperties", aReferenceToHashtable);
        } else {
            this.addProperty("objectProperties", "#" + aReferenceToHashtable);
        }
        return this;
    }

    protected void addProperty(String aName, String aValue) {
        this.mQueryProps.put(aName, aValue);
    }

    public String getServerName() {
        return this.mServerName;
    }

    public void setServerName(String aServerName) {
        this.mServerName = aServerName;
    }

    public JMXUriBuilder withServerName(String aServerName) {
        this.setServerName(aServerName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("jmx:").append(this.getServerName());
        if (!this.mQueryProps.isEmpty()) {
            sb.append('?');
            String delim = "";
            for (Map.Entry<String, String> entry : this.mQueryProps.entrySet()) {
                sb.append(delim);
                sb.append(entry.getKey()).append('=').append(entry.getValue());
                delim = "&";
            }
        }
        return sb.toString();
    }
}

