/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jmx.JMXComponent;
import org.apache.camel.component.jmx.JMXConsumer;
import org.apache.camel.impl.DefaultEndpoint;

public class JMXEndpoint
extends DefaultEndpoint {
    private String mFormat = "xml";
    private String mUser;
    private String mPassword;
    private String mObjectDomain;
    private String mObjectName;
    private NotificationFilter mNotificationFilter;
    private Object mHandback;
    private Hashtable<String, String> mObjectProperties;
    private ObjectName mJMXObjectName;
    private String mServerURL;

    public JMXEndpoint(String aEndpointUri, JMXComponent aComponent) {
        super(aEndpointUri, (Component)aComponent);
    }

    public Consumer createConsumer(Processor aProcessor) throws Exception {
        return new JMXConsumer(this, aProcessor);
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("producing JMX notifications is not supported");
    }

    public boolean isSingleton() {
        return false;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public void setFormat(String aFormat) {
        this.mFormat = aFormat;
    }

    public boolean isXML() {
        return "xml".equals(this.getFormat());
    }

    public boolean isPlatformServer() {
        return "platform".equals(this.getServerURL());
    }

    public String getUser() {
        return this.mUser;
    }

    public void setUser(String aUser) {
        this.mUser = aUser;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String aPassword) {
        this.mPassword = aPassword;
    }

    public String getObjectDomain() {
        return this.mObjectDomain;
    }

    public void setObjectDomain(String aObjectDomain) {
        this.mObjectDomain = aObjectDomain;
    }

    public String getObjectName() {
        return this.mObjectName;
    }

    public void setObjectName(String aObjectName) {
        if (this.getObjectProperties() != null) {
            throw new IllegalArgumentException("Cannot set both objectName and objectProperties");
        }
        this.mObjectName = aObjectName;
    }

    protected String getServerURL() {
        return this.mServerURL;
    }

    protected void setServerURL(String aServerURL) {
        this.mServerURL = aServerURL;
    }

    public NotificationFilter getNotificationFilter() {
        return this.mNotificationFilter;
    }

    public void setNotificationFilter(NotificationFilter aFilterRef) {
        this.mNotificationFilter = aFilterRef;
    }

    public Object getHandback() {
        return this.mHandback;
    }

    public void setHandback(Object aHandback) {
        this.mHandback = aHandback;
    }

    public Hashtable<String, String> getObjectProperties() {
        return this.mObjectProperties;
    }

    public void setObjectProperties(Hashtable<String, String> aObjectProperties) {
        if (this.getObjectName() != null) {
            throw new IllegalArgumentException("Cannot set both objectName and objectProperties");
        }
        this.mObjectProperties = aObjectProperties;
    }

    protected ObjectName getJMXObjectName() throws MalformedObjectNameException {
        if (this.mJMXObjectName == null) {
            ObjectName on = this.buildObjectName();
            this.setJMXObjectName(on);
        }
        return this.mJMXObjectName;
    }

    protected void setJMXObjectName(ObjectName aCachedObjectName) {
        this.mJMXObjectName = aCachedObjectName;
    }

    private ObjectName buildObjectName() throws MalformedObjectNameException {
        ObjectName objectName;
        if (this.getObjectProperties() == null) {
            StringBuilder sb = new StringBuilder(this.getObjectDomain()).append(':').append("name=").append(this.getObjectName());
            objectName = new ObjectName(sb.toString());
        } else {
            objectName = new ObjectName(this.getObjectDomain(), this.getObjectProperties());
        }
        return objectName;
    }
}

