/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.EntityManager;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaProducer
extends DefaultProducer {
    private final EntityManager entityManager;
    private final TransactionTemplate transactionTemplate;
    private final JpaEndpoint endpoint;
    private final Expression expression;

    public JpaProducer(JpaEndpoint endpoint, Expression expression) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.expression = expression;
        this.entityManager = endpoint.getEntityManager();
        this.transactionTemplate = endpoint.createTransactionTemplate();
    }

    public void process(final Exchange exchange) {
        exchange.getIn().setHeader("CamelEntityManager", (Object)this.entityManager);
        final Object values = this.expression.evaluate(exchange, Object.class);
        if (values != null) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    JpaProducer.this.entityManager.joinTransaction();
                    if (values.getClass().isArray()) {
                        Object[] array = (Object[])values;
                        for (int index = 0; index < array.length; ++index) {
                            Object managedEntity = this.save(array[index], JpaProducer.this.entityManager);
                            if (JpaProducer.this.endpoint.isUsePersist()) continue;
                            array[index] = managedEntity;
                        }
                    } else if (values instanceof Collection) {
                        Collection collection = (Collection)values;
                        ArrayList<Object> managedEntities = new ArrayList<Object>();
                        for (Object entity : collection) {
                            Object managedEntity = this.save(entity, JpaProducer.this.entityManager);
                            managedEntities.add(managedEntity);
                        }
                        if (!JpaProducer.this.endpoint.isUsePersist()) {
                            collection.clear();
                            collection.addAll(managedEntities);
                        }
                    } else {
                        Object managedEntity = this.save(values, JpaProducer.this.entityManager);
                        if (!JpaProducer.this.endpoint.isUsePersist()) {
                            exchange.getIn().setBody(managedEntity);
                        }
                    }
                    if (JpaProducer.this.endpoint.isFlushOnSend()) {
                        JpaProducer.this.entityManager.joinTransaction();
                        JpaProducer.this.entityManager.flush();
                    }
                    return null;
                }

                private Object save(Object entity, EntityManager entityManager) {
                    if (JpaProducer.this.endpoint.isUsePersist()) {
                        entityManager.joinTransaction();
                        entityManager.persist(entity);
                        return entity;
                    }
                    entityManager.joinTransaction();
                    return entityManager.merge(entity);
                }
            });
        }
        exchange.getIn().removeHeader("CamelEntityManager");
    }
}

