/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(JpaComponent.class);
    private EntityManagerFactory entityManagerFactory;
    private PlatformTransactionManager transactionManager;
    private boolean joinTransaction = true;
    private boolean sharedEntityManager;

    public JpaComponent() {
        super(JpaEndpoint.class);
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public boolean isJoinTransaction() {
        return this.joinTransaction;
    }

    public void setJoinTransaction(boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    public boolean isSharedEntityManager() {
        return this.sharedEntityManager;
    }

    public void setSharedEntityManager(boolean sharedEntityManager) {
        this.sharedEntityManager = sharedEntityManager;
    }

    protected Endpoint createEndpoint(String uri, String path, Map<String, Object> options) throws Exception {
        Class type;
        JpaEndpoint endpoint = new JpaEndpoint(uri, this);
        endpoint.setJoinTransaction(this.isJoinTransaction());
        endpoint.setSharedEntityManager(this.isSharedEntityManager());
        if (ObjectHelper.isNotEmpty((Object)path) && (type = this.getCamelContext().getClassResolver().resolveClass(path, JpaComponent.class.getClassLoader())) != null) {
            endpoint.setEntityType(type);
        }
        return endpoint;
    }

    protected void doStart() throws Exception {
        Map map;
        super.doStart();
        if (this.entityManagerFactory == null) {
            map = this.getCamelContext().getRegistry().findByTypeWithName(EntityManagerFactory.class);
            if (map != null) {
                if (map.size() == 1) {
                    this.entityManagerFactory = (EntityManagerFactory)map.values().iterator().next();
                    LOG.info("Using EntityManagerFactory found in registry with id [" + (String)map.keySet().iterator().next() + "] " + this.entityManagerFactory);
                } else {
                    LOG.debug("Could not find a single EntityManagerFactory in registry as there was " + map.size() + " instances.");
                }
            }
        } else {
            LOG.info("Using EntityManagerFactory configured: " + this.entityManagerFactory);
        }
        if (this.transactionManager == null) {
            map = this.getCamelContext().getRegistry().findByTypeWithName(PlatformTransactionManager.class);
            if (map != null) {
                if (map.size() == 1) {
                    this.transactionManager = (PlatformTransactionManager)map.values().iterator().next();
                    LOG.info("Using TransactionManager found in registry with id [" + (String)map.keySet().iterator().next() + "] " + this.transactionManager);
                } else {
                    LOG.debug("Could not find a single TransactionManager in registry as there was " + map.size() + " instances.");
                }
            }
        } else {
            LOG.info("Using TransactionManager configured on this component: " + this.transactionManager);
        }
        if (this.transactionManager == null && (map = this.getCamelContext().getRegistry().findByTypeWithName(TransactionTemplate.class)) != null) {
            if (map.size() == 1) {
                this.transactionManager = ((TransactionTemplate)map.values().iterator().next()).getTransactionManager();
                LOG.info("Using TransactionManager found in registry with id [" + (String)map.keySet().iterator().next() + "] " + this.transactionManager);
            } else {
                LOG.debug("Could not find a single TransactionTemplate in registry as there was " + map.size() + " instances.");
            }
        }
        if (this.entityManagerFactory == null) {
            LOG.warn("No EntityManagerFactory has been configured on this JpaComponent. Each JpaEndpoint will auto create their own EntityManagerFactory.");
        }
        if (this.transactionManager == null) {
            LOG.warn("No TransactionManager has been configured on this JpaComponent. Each JpaEndpoint will auto create their own JpaTransactionManager.");
        }
    }
}

