/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jpa;

import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.camel.processor.idempotent.jpa.MessageProcessed;
import org.apache.camel.spi.IdempotentRepository;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaMessageIdRepository
implements IdempotentRepository<String> {
    protected static final String QUERY_STRING = "select x from " + MessageProcessed.class.getName() + " x where x.processorName = ?1 and x.messageId = ?2";
    private JpaTemplate jpaTemplate;
    private String processorName;
    private TransactionTemplate transactionTemplate;

    public JpaMessageIdRepository(JpaTemplate template, String processorName) {
        this(template, JpaMessageIdRepository.createTransactionTemplate(template), processorName);
    }

    public JpaMessageIdRepository(JpaTemplate template, TransactionTemplate transactionTemplate, String processorName) {
        this.jpaTemplate = template;
        this.processorName = processorName;
        this.transactionTemplate = transactionTemplate;
    }

    public static JpaMessageIdRepository jpaMessageIdRepository(String persistenceUnit, String processorName) {
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)persistenceUnit);
        return JpaMessageIdRepository.jpaMessageIdRepository(new JpaTemplate(entityManagerFactory), processorName);
    }

    public static JpaMessageIdRepository jpaMessageIdRepository(JpaTemplate jpaTemplate, String processorName) {
        return new JpaMessageIdRepository(jpaTemplate, processorName);
    }

    private static TransactionTemplate createTransactionTemplate(JpaTemplate jpaTemplate) {
        TransactionTemplate transactionTemplate = new TransactionTemplate();
        transactionTemplate.setTransactionManager((PlatformTransactionManager)new JpaTransactionManager(jpaTemplate.getEntityManagerFactory()));
        transactionTemplate.setPropagationBehavior(0);
        return transactionTemplate;
    }

    public boolean add(final String messageId) {
        Boolean rc = (Boolean)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus arg0) {
                List list = JpaMessageIdRepository.this.jpaTemplate.find(QUERY_STRING, new Object[]{JpaMessageIdRepository.this.processorName, messageId});
                if (list.isEmpty()) {
                    MessageProcessed processed = new MessageProcessed();
                    processed.setProcessorName(JpaMessageIdRepository.this.processorName);
                    processed.setMessageId(messageId);
                    JpaMessageIdRepository.this.jpaTemplate.persist((Object)processed);
                    JpaMessageIdRepository.this.jpaTemplate.flush();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return rc;
    }

    public boolean contains(final String messageId) {
        Boolean rc = (Boolean)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus arg0) {
                List list = JpaMessageIdRepository.this.jpaTemplate.find(QUERY_STRING, new Object[]{JpaMessageIdRepository.this.processorName, messageId});
                if (list.isEmpty()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return rc;
    }

    public boolean remove(final String messageId) {
        Boolean rc = (Boolean)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus arg0) {
                List list = JpaMessageIdRepository.this.jpaTemplate.find(QUERY_STRING, new Object[]{JpaMessageIdRepository.this.processorName, messageId});
                if (list.isEmpty()) {
                    return Boolean.FALSE;
                }
                MessageProcessed processoed = (MessageProcessed)list.get(0);
                JpaMessageIdRepository.this.jpaTemplate.remove((Object)processoed);
                JpaMessageIdRepository.this.jpaTemplate.flush();
                return Boolean.TRUE;
            }
        });
        return rc;
    }

    public boolean confirm(String s) {
        return true;
    }
}

