/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.camel.component.jpa.QueryFactory;

public abstract class QueryBuilder
implements QueryFactory {
    ParameterBuilder parameterBuilder;

    public static QueryBuilder query(final String query) {
        return new QueryBuilder(){

            @Override
            protected Query makeQueryObject(EntityManager entityManager) {
                return entityManager.createQuery(query);
            }

            public String toString() {
                return "Query: " + query + this.getParameterDescription();
            }
        };
    }

    public static QueryBuilder namedQuery(final String namedQuery) {
        return new QueryBuilder(){

            @Override
            protected Query makeQueryObject(EntityManager entityManager) {
                return entityManager.createNamedQuery(namedQuery);
            }

            public String toString() {
                return "Named: " + namedQuery + this.getParameterDescription();
            }
        };
    }

    public static QueryBuilder nativeQuery(final String nativeQuery) {
        return new QueryBuilder(){

            @Override
            protected Query makeQueryObject(EntityManager entityManager) {
                return entityManager.createNativeQuery(nativeQuery);
            }

            public String toString() {
                return "NativeQuery: " + nativeQuery + this.getParameterDescription();
            }
        };
    }

    public static QueryBuilder nativeQuery(final String nativeQuery, final Class resultClass) {
        return new QueryBuilder(){

            @Override
            protected Query makeQueryObject(EntityManager entityManager) {
                return entityManager.createNativeQuery(nativeQuery, resultClass);
            }

            public String toString() {
                return "NativeQuery: " + nativeQuery + " resultClass:" + resultClass + this.getParameterDescription();
            }
        };
    }

    public QueryBuilder parameters(Object ... parameters) {
        return this.parameters(Arrays.asList(parameters));
    }

    public QueryBuilder parameters(final Collection parameters) {
        this.checkNoParametersConfigured();
        this.parameterBuilder = new ParameterBuilder(){

            @Override
            public void populateQuery(EntityManager entityManager, Query query) {
                int counter = 0;
                for (Object parameter : parameters) {
                    query.setParameter(counter++, parameter);
                }
            }

            public String toString() {
                return "Parameters: " + parameters;
            }
        };
        return this;
    }

    public QueryBuilder parameters(final Map<String, Object> parameterMap) {
        this.checkNoParametersConfigured();
        this.parameterBuilder = new ParameterBuilder(){

            @Override
            public void populateQuery(EntityManager entityManager, Query query) {
                Set entries = parameterMap.entrySet();
                for (Map.Entry entry : entries) {
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
            }

            public String toString() {
                return "Parameters: " + parameterMap;
            }
        };
        return this;
    }

    protected void checkNoParametersConfigured() {
        if (this.parameterBuilder != null) {
            throw new IllegalArgumentException("Cannot add parameters to a QueryBuilder which already has parameters configured");
        }
    }

    @Override
    public Query createQuery(EntityManager entityManager) {
        Query query = this.makeQueryObject(entityManager);
        this.populateQuery(entityManager, query);
        return query;
    }

    protected String getParameterDescription() {
        if (this.parameterBuilder == null) {
            return "";
        }
        return " " + this.parameterBuilder.toString();
    }

    protected void populateQuery(EntityManager entityManager, Query query) {
        if (this.parameterBuilder != null) {
            this.parameterBuilder.populateQuery(entityManager, query);
        }
    }

    protected abstract Query makeQueryObject(EntityManager var1);

    protected static abstract class ParameterBuilder {
        protected ParameterBuilder() {
        }

        public abstract void populateQuery(EntityManager var1, Query var2);
    }
}

