/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.JpaHelper;
import org.apache.camel.component.jpa.QueryBuilder;
import org.apache.camel.component.jpa.QueryFactory;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JpaProducer.class);
    private static final String PROPERTY_PREFIX = "property:";
    private Language simple;
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionStrategy transactionStrategy;
    private final Expression expression;
    private String query;
    private String namedQuery;
    private String nativeQuery;
    private boolean findEntity;
    private Map<String, Object> parameters;
    private Class<?> resultClass;
    private QueryFactory queryFactory;
    private Boolean useExecuteUpdate;

    public JpaProducer(JpaEndpoint endpoint, Expression expression) {
        super((Endpoint)endpoint);
        this.expression = expression;
        this.entityManagerFactory = endpoint.getEntityManagerFactory();
        this.transactionStrategy = endpoint.getTransactionStrategy();
    }

    public JpaEndpoint getEndpoint() {
        return (JpaEndpoint)super.getEndpoint();
    }

    public QueryFactory getQueryFactory() {
        if (this.queryFactory == null) {
            if (this.query != null) {
                this.queryFactory = QueryBuilder.query(this.query);
            } else if (this.namedQuery != null) {
                this.queryFactory = QueryBuilder.namedQuery(this.namedQuery);
            } else if (this.nativeQuery != null) {
                this.queryFactory = this.resultClass != null ? QueryBuilder.nativeQuery(this.nativeQuery, this.resultClass) : QueryBuilder.nativeQuery(this.nativeQuery);
            }
        }
        return this.queryFactory;
    }

    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public void setParameters(Map<String, Object> params) {
        this.parameters = params;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isFindEntity() {
        return this.findEntity;
    }

    public void setFindEntity(boolean findEntity) {
        this.findEntity = findEntity;
    }

    public Class<?> getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    public void setUseExecuteUpdate(Boolean executeUpdate) {
        this.useExecuteUpdate = executeUpdate;
    }

    public boolean isUseExecuteUpdate() {
        if (this.useExecuteUpdate == null) {
            this.useExecuteUpdate = this.query != null ? (this.query.regionMatches(true, 0, "select", 0, 6) ? Boolean.valueOf(false) : Boolean.valueOf(true)) : (this.nativeQuery != null ? (this.nativeQuery.regionMatches(true, 0, "select", 0, 6) ? Boolean.valueOf(false) : Boolean.valueOf(true)) : Boolean.valueOf(false));
        }
        return this.useExecuteUpdate;
    }

    public void process(Exchange exchange) {
        EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, this.getEndpoint().isUsePassedInEntityManager(), this.getEndpoint().isSharedEntityManager(), true);
        if (this.findEntity) {
            this.processFind(exchange, entityManager);
        } else if (this.getQueryFactory() != null) {
            this.processQuery(exchange, entityManager);
        } else {
            this.processEntity(exchange, entityManager);
        }
    }

    protected void processQuery(Exchange exchange, EntityManager entityManager) {
        Query innerQuery = this.getQueryFactory().createQuery(entityManager);
        this.configureParameters(innerQuery, exchange);
        this.transactionStrategy.executeInTransaction(() -> {
            if (this.getEndpoint().isJoinTransaction()) {
                entityManager.joinTransaction();
            }
            Object answer = this.isUseExecuteUpdate() ? Integer.valueOf(innerQuery.executeUpdate()) : (this.getEndpoint().isSingleResult() ? innerQuery.getSingleResult() : innerQuery.getResultList());
            JpaProducer.putAnswer(exchange, answer, this.getEndpoint().getOutputTarget());
            if (this.getEndpoint().isFlushOnSend()) {
                entityManager.flush();
            }
        });
    }

    private void configureParameters(Query query, Exchange exchange) {
        Map params;
        int firstResult;
        int maxResults = (Integer)exchange.getIn().getHeader("CamelJpaMaximumResults", (Object)this.getEndpoint().getMaximumResults(), Integer.class);
        if (maxResults > 0) {
            query.setMaxResults(maxResults);
        }
        if ((firstResult = ((Integer)exchange.getIn().getHeader("CamelJpaFirstResult", (Object)this.getEndpoint().getFirstResult(), Integer.class)).intValue()) > 0) {
            query.setFirstResult(firstResult);
        }
        if ((params = this.parameters != null ? this.parameters : (Map)exchange.getIn().getHeader("CamelJpaParameters", Map.class)) != null) {
            params.forEach((key, value) -> {
                Object resolvedValue = value;
                if (value instanceof String) {
                    resolvedValue = this.simple.createExpression((String)value).evaluate(exchange, Object.class);
                }
                query.setParameter(key, resolvedValue);
            });
        }
    }

    protected void processFind(Exchange exchange, EntityManager entityManager) {
        Object key = exchange.getMessage().getBody();
        if (key != null) {
            this.transactionStrategy.executeInTransaction(() -> {
                if (this.getEndpoint().isJoinTransaction()) {
                    entityManager.joinTransaction();
                }
                Object answer = entityManager.find(this.getEndpoint().getEntityType(), key);
                LOG.debug("Find: {} -> {}", key, answer);
                if (this.getEndpoint().isSingleResult() && answer == null) {
                    throw new NoResultException(String.format("No results for key %s and singleResult requested", key));
                }
                JpaProducer.putAnswer(exchange, answer, this.getEndpoint().getOutputTarget());
                if (this.getEndpoint().isFlushOnSend()) {
                    entityManager.flush();
                }
            });
        }
    }

    protected void processEntity(final Exchange exchange, final EntityManager entityManager) {
        final Object values = this.expression.evaluate(exchange, Object.class);
        if (values != null) {
            this.transactionStrategy.executeInTransaction(new Runnable(){

                @Override
                public void run() {
                    if (JpaProducer.this.getEndpoint().isJoinTransaction()) {
                        entityManager.joinTransaction();
                    }
                    if (values.getClass().isArray()) {
                        Object[] array = (Object[])values;
                        Object[] managedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            Object element = array[i];
                            Object managedEntity = !JpaProducer.this.getEndpoint().isRemove() ? this.save(element) : this.remove(element);
                            managedArray[i] = managedEntity;
                        }
                        if (!JpaProducer.this.getEndpoint().isUsePersist()) {
                            System.arraycopy(managedArray, 0, array, 0, array.length);
                            exchange.getIn().setBody((Object)array);
                        }
                    } else if (values instanceof Collection) {
                        Collection collection = (Collection)values;
                        ArrayList<Object> managedCollection = new ArrayList<Object>(collection.size());
                        for (Object entity : collection) {
                            Object managedEntity = !JpaProducer.this.getEndpoint().isRemove() ? this.save(entity) : this.remove(entity);
                            managedCollection.add(managedEntity);
                        }
                        if (!JpaProducer.this.getEndpoint().isUsePersist()) {
                            exchange.getIn().setBody(managedCollection);
                        }
                    } else {
                        Object managedEntity = !JpaProducer.this.getEndpoint().isRemove() ? this.save(values) : this.remove(values);
                        if (!JpaProducer.this.getEndpoint().isUsePersist()) {
                            exchange.getIn().setBody(managedEntity);
                        }
                    }
                    if (JpaProducer.this.getEndpoint().isFlushOnSend()) {
                        entityManager.flush();
                    }
                }

                private Object save(Object entity) {
                    LOG.debug("save: {}", entity);
                    if (JpaProducer.this.getEndpoint().isUsePersist()) {
                        entityManager.persist(entity);
                        return entity;
                    }
                    return entityManager.merge(entity);
                }

                private Object remove(Object entity) {
                    LOG.debug("remove: {}", entity);
                    Object managedEntity = entityManager.contains(entity) ? entity : entityManager.merge(entity);
                    entityManager.remove(managedEntity);
                    return managedEntity;
                }
            });
        }
    }

    private static void putAnswer(Exchange exchange, Object answer, String outputTarget) {
        if (outputTarget == null || outputTarget.isBlank()) {
            JpaProducer.getTargetMessage(exchange).setBody(answer);
        } else if (outputTarget.startsWith(PROPERTY_PREFIX)) {
            exchange.setProperty(outputTarget.substring(PROPERTY_PREFIX.length()), answer);
        } else {
            JpaProducer.getTargetMessage(exchange).setHeader(outputTarget, answer);
        }
    }

    private static Message getTargetMessage(Exchange exchange) {
        Message target;
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            target = exchange.getMessage();
            target.getHeaders().putAll(exchange.getIn().getHeaders());
        } else {
            target = exchange.getIn();
        }
        return target;
    }

    protected void doBuild() throws Exception {
        this.simple = this.getEndpoint().getCamelContext().resolveLanguage("simple");
    }
}

