/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Properties;
import kafka.producer.DefaultPartitioner;

public class KafkaConfiguration {
    private String zookeeperConnect;
    private String zookeeperHost;
    private int zookeeperPort = 2181;
    private String topic;
    private String groupId;
    private String partitioner = DefaultPartitioner.class.getCanonicalName();
    private int consumerStreams = 10;
    private String clientId;
    private String consumerId;
    private Integer socketTimeoutMs;
    private Integer socketReceiveBufferBytes;
    private Integer fetchMessageMaxBytes;
    private Boolean autoCommitEnable;
    private Integer autoCommitIntervalMs;
    private Integer queuedMaxMessages;
    private Integer rebalanceMaxRetries;
    private Integer fetchMinBytes;
    private Integer fetchWaitMaxMs;
    private Integer rebalanceBackoffMs;
    private Integer refreshLeaderBackoffMs;
    private String autoOffsetReset;
    private Integer consumerTimeoutMs;
    private Integer zookeeperSessionTimeoutMs;
    private Integer zookeeperConnectionTimeoutMs;
    private Integer zookeeperSyncTimeMs;
    private String producerType;
    private String compressionCodec;
    private String compressedTopics;
    private Integer messageSendMaxRetries;
    private Integer retryBackoffMs;
    private Integer topicMetadataRefreshIntervalMs;
    private Integer sendBufferBytes;
    private short requestRequiredAcks;
    private Integer requestTimeoutMs;
    private Integer queueBufferingMaxMs;
    private Integer queueBufferingMaxMessages;
    private Integer queueEnqueueTimeoutMs;
    private Integer batchNumMessages;
    private String serializerClass;
    private String keySerializerClass;

    public Properties createProducerProperties() {
        Properties props = new Properties();
        KafkaConfiguration.addPropertyIfNotNull(props, "request.required.acks", this.getRequestRequiredAcks());
        KafkaConfiguration.addPropertyIfNotNull(props, "partitioner.class", this.getPartitioner());
        KafkaConfiguration.addPropertyIfNotNull(props, "serializer.class", this.getSerializerClass());
        KafkaConfiguration.addPropertyIfNotNull(props, "key.serializer.class", this.getKeySerializerClass());
        KafkaConfiguration.addPropertyIfNotNull(props, "request.timeout.ms", this.getRequestTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "producer.type", this.getProducerType());
        KafkaConfiguration.addPropertyIfNotNull(props, "compression.codec", this.getCompressionCodec());
        KafkaConfiguration.addPropertyIfNotNull(props, "compressed.topics", this.getCompressedTopics());
        KafkaConfiguration.addPropertyIfNotNull(props, "message.send.max.retries", this.getMessageSendMaxRetries());
        KafkaConfiguration.addPropertyIfNotNull(props, "retry.backoff.ms", this.getRetryBackoffMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "topic.metadata.refresh.interval.ms", this.getTopicMetadataRefreshIntervalMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "queue.buffering.max.ms", this.getQueueBufferingMaxMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "queue.buffering.max.messages", this.getQueueBufferingMaxMessages());
        KafkaConfiguration.addPropertyIfNotNull(props, "queue.enqueue.timeout.ms", this.getQueueEnqueueTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "batch.num.messages", this.getBatchNumMessages());
        KafkaConfiguration.addPropertyIfNotNull(props, "send.buffer.bytes", this.getSendBufferBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "client.id", this.getClientId());
        return props;
    }

    public Properties createConsumerProperties() {
        Properties props = new Properties();
        KafkaConfiguration.addPropertyIfNotNull(props, "consumer.id", this.getConsumerId());
        KafkaConfiguration.addPropertyIfNotNull(props, "socket.timeout.ms", this.getSocketTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "socket.receive.buffer.bytes", this.getSocketReceiveBufferBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "fetch.message.max.bytes", this.getFetchMessageMaxBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "auto.commit.enable", this.isAutoCommitEnable());
        KafkaConfiguration.addPropertyIfNotNull(props, "auto.commit.interval.ms", this.getAutoCommitIntervalMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "queued.max.message.chunks", this.getQueueBufferingMaxMessages());
        KafkaConfiguration.addPropertyIfNotNull(props, "fetch.min.bytes", this.getFetchMinBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "fetch.wait.max.ms", this.getFetchWaitMaxMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "rebalance.max.retries", this.getRebalanceMaxRetries());
        KafkaConfiguration.addPropertyIfNotNull(props, "rebalance.backoff.ms", this.getRebalanceBackoffMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "refresh.leader.backoff.ms", this.getRefreshLeaderBackoffMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "auto.offset.reset", this.getAutoOffsetReset());
        KafkaConfiguration.addPropertyIfNotNull(props, "consumer.timeout.ms", this.getConsumerTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "client.id", this.getClientId());
        KafkaConfiguration.addPropertyIfNotNull(props, "zookeeper.session.timeout.ms", this.getZookeeperSessionTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "zookeeper.connection.timeout.ms", this.getZookeeperConnectionTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "zookeeper.sync.time.ms", this.getZookeeperSyncTimeMs());
        return props;
    }

    private static <T> void addPropertyIfNotNull(Properties props, String key, T value) {
        if (value != null) {
            props.put(key, value.toString());
        }
    }

    public String getZookeeperConnect() {
        if (this.zookeeperConnect != null) {
            return this.zookeeperConnect;
        }
        return this.getZookeeperHost() + ":" + this.getZookeeperPort();
    }

    public void setZookeeperConnect(String zookeeperConnect) {
        this.zookeeperConnect = zookeeperConnect;
        this.zookeeperHost = null;
        this.zookeeperPort = -1;
    }

    public String getZookeeperHost() {
        return this.zookeeperHost;
    }

    public void setZookeeperHost(String zookeeperHost) {
        if (this.zookeeperConnect == null) {
            this.zookeeperHost = zookeeperHost;
        }
    }

    public int getZookeeperPort() {
        return this.zookeeperPort;
    }

    public void setZookeeperPort(int zookeeperPort) {
        if (this.zookeeperConnect == null) {
            this.zookeeperPort = zookeeperPort;
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(String partitioner) {
        this.partitioner = partitioner;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getConsumerStreams() {
        return this.consumerStreams;
    }

    public void setConsumerStreams(int consumerStreams) {
        this.consumerStreams = consumerStreams;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public Integer getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public void setSocketTimeoutMs(Integer socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public Integer getSocketReceiveBufferBytes() {
        return this.socketReceiveBufferBytes;
    }

    public void setSocketReceiveBufferBytes(Integer socketReceiveBufferBytes) {
        this.socketReceiveBufferBytes = socketReceiveBufferBytes;
    }

    public Integer getFetchMessageMaxBytes() {
        return this.fetchMessageMaxBytes;
    }

    public void setFetchMessageMaxBytes(Integer fetchMessageMaxBytes) {
        this.fetchMessageMaxBytes = fetchMessageMaxBytes;
    }

    public Boolean isAutoCommitEnable() {
        return this.autoCommitEnable;
    }

    public void setAutoCommitEnable(Boolean autoCommitEnable) {
        this.autoCommitEnable = autoCommitEnable;
    }

    public Integer getAutoCommitIntervalMs() {
        return this.autoCommitIntervalMs;
    }

    public void setAutoCommitIntervalMs(Integer autoCommitIntervalMs) {
        this.autoCommitIntervalMs = autoCommitIntervalMs;
    }

    public Integer getQueuedMaxMessages() {
        return this.queuedMaxMessages;
    }

    public void setQueuedMaxMessages(Integer queuedMaxMessages) {
        this.queuedMaxMessages = queuedMaxMessages;
    }

    public Integer getRebalanceMaxRetries() {
        return this.rebalanceMaxRetries;
    }

    public void setRebalanceMaxRetries(Integer rebalanceMaxRetries) {
        this.rebalanceMaxRetries = rebalanceMaxRetries;
    }

    public Integer getFetchMinBytes() {
        return this.fetchMinBytes;
    }

    public void setFetchMinBytes(Integer fetchMinBytes) {
        this.fetchMinBytes = fetchMinBytes;
    }

    public Integer getFetchWaitMaxMs() {
        return this.fetchWaitMaxMs;
    }

    public void setFetchWaitMaxMs(Integer fetchWaitMaxMs) {
        this.fetchWaitMaxMs = fetchWaitMaxMs;
    }

    public Integer getRebalanceBackoffMs() {
        return this.rebalanceBackoffMs;
    }

    public void setRebalanceBackoffMs(Integer rebalanceBackoffMs) {
        this.rebalanceBackoffMs = rebalanceBackoffMs;
    }

    public Integer getRefreshLeaderBackoffMs() {
        return this.refreshLeaderBackoffMs;
    }

    public void setRefreshLeaderBackoffMs(Integer refreshLeaderBackoffMs) {
        this.refreshLeaderBackoffMs = refreshLeaderBackoffMs;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public Integer getConsumerTimeoutMs() {
        return this.consumerTimeoutMs;
    }

    public void setConsumerTimeoutMs(Integer consumerTimeoutMs) {
        this.consumerTimeoutMs = consumerTimeoutMs;
    }

    public Integer getZookeeperSessionTimeoutMs() {
        return this.zookeeperSessionTimeoutMs;
    }

    public void setZookeeperSessionTimeoutMs(Integer zookeeperSessionTimeoutMs) {
        this.zookeeperSessionTimeoutMs = zookeeperSessionTimeoutMs;
    }

    public Integer getZookeeperConnectionTimeoutMs() {
        return this.zookeeperConnectionTimeoutMs;
    }

    public void setZookeeperConnectionTimeoutMs(Integer zookeeperConnectionTimeoutMs) {
        this.zookeeperConnectionTimeoutMs = zookeeperConnectionTimeoutMs;
    }

    public Integer getZookeeperSyncTimeMs() {
        return this.zookeeperSyncTimeMs;
    }

    public void setZookeeperSyncTimeMs(Integer zookeeperSyncTimeMs) {
        this.zookeeperSyncTimeMs = zookeeperSyncTimeMs;
    }

    public String getProducerType() {
        return this.producerType;
    }

    public void setProducerType(String producerType) {
        this.producerType = producerType;
    }

    public String getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(String compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public String getCompressedTopics() {
        return this.compressedTopics;
    }

    public void setCompressedTopics(String compressedTopics) {
        this.compressedTopics = compressedTopics;
    }

    public Integer getMessageSendMaxRetries() {
        return this.messageSendMaxRetries;
    }

    public void setMessageSendMaxRetries(Integer messageSendMaxRetries) {
        this.messageSendMaxRetries = messageSendMaxRetries;
    }

    public Integer getRetryBackoffMs() {
        return this.retryBackoffMs;
    }

    public void setRetryBackoffMs(Integer retryBackoffMs) {
        this.retryBackoffMs = retryBackoffMs;
    }

    public Integer getTopicMetadataRefreshIntervalMs() {
        return this.topicMetadataRefreshIntervalMs;
    }

    public void setTopicMetadataRefreshIntervalMs(Integer topicMetadataRefreshIntervalMs) {
        this.topicMetadataRefreshIntervalMs = topicMetadataRefreshIntervalMs;
    }

    public Integer getSendBufferBytes() {
        return this.sendBufferBytes;
    }

    public void setSendBufferBytes(Integer sendBufferBytes) {
        this.sendBufferBytes = sendBufferBytes;
    }

    public short getRequestRequiredAcks() {
        return this.requestRequiredAcks;
    }

    public void setRequestRequiredAcks(short requestRequiredAcks) {
        this.requestRequiredAcks = requestRequiredAcks;
    }

    public Integer getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public void setRequestTimeoutMs(Integer requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public Integer getQueueBufferingMaxMs() {
        return this.queueBufferingMaxMs;
    }

    public void setQueueBufferingMaxMs(Integer queueBufferingMaxMs) {
        this.queueBufferingMaxMs = queueBufferingMaxMs;
    }

    public Integer getQueueBufferingMaxMessages() {
        return this.queueBufferingMaxMessages;
    }

    public void setQueueBufferingMaxMessages(Integer queueBufferingMaxMessages) {
        this.queueBufferingMaxMessages = queueBufferingMaxMessages;
    }

    public Integer getQueueEnqueueTimeoutMs() {
        return this.queueEnqueueTimeoutMs;
    }

    public void setQueueEnqueueTimeoutMs(Integer queueEnqueueTimeoutMs) {
        this.queueEnqueueTimeoutMs = queueEnqueueTimeoutMs;
    }

    public Integer getBatchNumMessages() {
        return this.batchNumMessages;
    }

    public void setBatchNumMessages(Integer batchNumMessages) {
        this.batchNumMessages = batchNumMessages;
    }

    public String getSerializerClass() {
        return this.serializerClass;
    }

    public void setSerializerClass(String serializerClass) {
        this.serializerClass = serializerClass;
    }

    public String getKeySerializerClass() {
        return this.keySerializerClass;
    }

    public void setKeySerializerClass(String keySerializerClass) {
        this.keySerializerClass = keySerializerClass;
    }
}

