/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.IOHelper;

public class SplitAttachmentsExpression
extends ExpressionAdapter {
    public static final String HEADER_NAME = "CamelSplitAttachmentId";

    public Object evaluate(Exchange exchange) {
        if (!((AttachmentMessage)exchange.getIn(AttachmentMessage.class)).hasAttachments()) {
            return null;
        }
        try {
            ArrayList<Message> answer = new ArrayList<Message>();
            AttachmentMessage inMessage = (AttachmentMessage)exchange.getIn(AttachmentMessage.class);
            for (Map.Entry entry : inMessage.getAttachmentObjects().entrySet()) {
                Message attachmentMessage = this.extractAttachment((Attachment)entry.getValue(), (String)entry.getKey(), exchange.getContext());
                if (attachmentMessage == null) continue;
                answer.add(attachmentMessage);
            }
            inMessage.getAttachmentObjects().clear();
            return answer;
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Unable to split attachments from MimeMultipart message", (Throwable)e);
        }
    }

    private Message extractAttachment(Attachment attachment, String attachmentName, CamelContext camelContext) throws Exception {
        DefaultMessage outMessage = new DefaultMessage(camelContext);
        outMessage.setHeader(HEADER_NAME, (Object)attachmentName);
        Object obj = attachment.getDataHandler().getContent();
        if (obj instanceof InputStream) {
            outMessage.setBody((Object)this.readMimePart((InputStream)obj));
            return outMessage;
        }
        if (obj instanceof String || obj instanceof byte[]) {
            outMessage.setBody(obj);
            return outMessage;
        }
        return null;
    }

    private byte[] readMimePart(InputStream mimePartStream) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelper.copyAndCloseInput((InputStream)mimePartStream, (OutputStream)bos);
        return bos.toByteArray();
    }
}

