/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.main.MainLifecycleStrategy;
import org.apache.camel.main.MainShutdownStrategy;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainDurationEventNotifier
extends EventNotifierSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MainLifecycleStrategy.class);
    private final CamelContext camelContext;
    private final int maxMessages;
    private final long maxIdleSeconds;
    private final MainShutdownStrategy shutdownStrategy;
    private final boolean stopCamelContext;
    private final boolean restartDuration;
    private final String action;
    private final AtomicInteger doneMessages;
    private volatile StopWatch watch;
    private volatile ScheduledExecutorService idleExecutorService;

    public MainDurationEventNotifier(CamelContext camelContext, int maxMessages, long maxIdleSeconds, MainShutdownStrategy shutdownStrategy, boolean stopCamelContext, boolean restartDuration, String action) {
        this.camelContext = camelContext;
        this.maxMessages = maxMessages;
        this.maxIdleSeconds = maxIdleSeconds;
        this.shutdownStrategy = shutdownStrategy;
        this.stopCamelContext = stopCamelContext;
        this.restartDuration = restartDuration;
        this.action = action.toLowerCase();
        this.doneMessages = new AtomicInteger();
        if (maxMessages == 0 && maxIdleSeconds == 0L) {
            this.setIgnoreExchangeEvents(true);
        }
    }

    public void notify(CamelEvent event) throws Exception {
        try {
            this.doNotify(event);
        }
        catch (Exception e) {
            LOG.warn("Error during processing CamelEvent: {}. This exception is ignored.", (Object)event, (Object)e);
        }
    }

    protected void doNotify(CamelEvent event) {
        boolean reloaded;
        if (!this.shutdownStrategy.isRunAllowed()) {
            return;
        }
        boolean bl = reloaded = event.getType() == CamelEvent.Type.RouteReloaded;
        if (reloaded) {
            if (this.restartDuration) {
                LOG.debug("Routes reloaded. Resetting maxMessages/maxIdleSeconds/maxSeconds");
                this.shutdownStrategy.restartAwait();
                this.doneMessages.set(0);
                if (this.watch != null) {
                    this.watch.restart();
                }
            }
            return;
        }
        boolean complete = false;
        if (this.maxMessages > 0) {
            boolean bl2 = complete = event.getType() == CamelEvent.Type.ExchangeCompleted || event.getType() == CamelEvent.Type.ExchangeFailed;
            if (complete) {
                boolean result;
                boolean bl3 = result = this.doneMessages.incrementAndGet() >= this.maxMessages;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Duration max messages check {} >= {} -> {}", new Object[]{this.doneMessages.get(), this.maxMessages, result});
                }
                if (result && this.shutdownStrategy.isRunAllowed()) {
                    if ("shutdown".equalsIgnoreCase(this.action)) {
                        LOG.info("Duration max messages triggering shutdown of the JVM");
                        this.camelContext.getExecutorServiceManager().newThread("CamelMainShutdownCamelContext", this::shutdownTask).start();
                    } else if ("stop".equalsIgnoreCase(this.action)) {
                        LOG.info("Duration max messages triggering stopping all routes");
                        this.camelContext.getExecutorServiceManager().newThread("CamelMainShutdownCamelContext", this::stopTask).start();
                    }
                }
            }
        }
        if (this.maxIdleSeconds > 0L) {
            boolean begin;
            boolean bl4 = begin = event.getType() == CamelEvent.Type.ExchangeCreated;
            if ((begin || complete) && this.watch != null) {
                LOG.trace("Message activity so restarting stop watch");
                this.watch.restart();
            }
        }
    }

    public boolean isEnabled(CamelEvent event) {
        return event.getType() == CamelEvent.Type.ExchangeCreated || event.getType() == CamelEvent.Type.ExchangeCompleted || event.getType() == CamelEvent.Type.ExchangeFailed || event.getType() == CamelEvent.Type.RouteReloaded;
    }

    public String toString() {
        return "MainDurationEventNotifier[" + this.maxMessages + " max messages]";
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (!this.action.equals("shutdown") && !this.action.equals("stop")) {
            throw new IllegalArgumentException("Unknown action: " + this.action);
        }
    }

    protected void doStart() throws Exception {
        if (this.maxIdleSeconds > 0L) {
            this.camelContext.addStartupListener((context, alreadyStarted) -> {
                this.watch = new StopWatch();
            });
            this.idleExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.idleExecutorService.scheduleAtFixedRate(this::idleTask, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    private void stopTask() {
        if (!this.shutdownStrategy.isRunAllowed()) {
            return;
        }
        try {
            this.camelContext.getRouteController().stopAllRoutes();
        }
        catch (Exception e) {
            LOG.warn("Error during stopping all routes. This exception is ignored.", (Throwable)e);
        }
    }

    private void shutdownTask() {
        if (!this.shutdownStrategy.isRunAllowed()) {
            return;
        }
        if (this.idleExecutorService != null) {
            this.idleExecutorService.shutdownNow();
        }
        try {
            if (this.stopCamelContext) {
                this.camelContext.stop();
            }
        }
        catch (Exception e) {
            LOG.warn("Error during stopping CamelContext. This exception is ignored.", (Throwable)e);
        }
        finally {
            this.shutdownStrategy.shutdown();
        }
    }

    private void idleTask() {
        if (!this.shutdownStrategy.isRunAllowed()) {
            return;
        }
        if (this.watch == null) {
            return;
        }
        int inflight = this.camelContext.getInflightRepository().size();
        if (inflight > 0) {
            LOG.trace("Duration max idle check is skipped due {} inflight messages", (Object)inflight);
            return;
        }
        long seconds = this.watch.taken() / 1000L;
        boolean result = seconds >= this.maxIdleSeconds;
        LOG.trace("Duration max idle check {} >= {} -> {}", new Object[]{seconds, this.maxIdleSeconds, result});
        if (result && this.shutdownStrategy.isRunAllowed()) {
            if ("shutdown".equals(this.action)) {
                LOG.info("Duration max idle triggering shutdown of the JVM");
                this.camelContext.getExecutorServiceManager().newThread("CamelMainShutdownCamelContext", this::shutdownTask).start();
            } else if ("stop".equals(this.action)) {
                LOG.info("Duration max idle triggering stopping all routes");
                this.camelContext.getExecutorServiceManager().newThread("CamelMainShutdownCamelContext", this::stopTask).start();
            }
        }
    }
}

