/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManager;
import org.apache.camel.CamelConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Configuration;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.NonManagedService;
import org.apache.camel.PropertiesLookupListener;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.StartupStep;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.debugger.DebuggerJmxConnectorService;
import org.apache.camel.impl.debugger.DefaultBacklogDebugger;
import org.apache.camel.impl.engine.DefaultCompileStrategy;
import org.apache.camel.impl.engine.DefaultRoutesLoader;
import org.apache.camel.main.DebuggerConfigurationProperties;
import org.apache.camel.main.DefaultConfigurationConfigurer;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.main.HealthConfigurationProperties;
import org.apache.camel.main.HttpServerConfigurationProperties;
import org.apache.camel.main.MainAutowiredLifecycleStrategy;
import org.apache.camel.main.MainConfigurationDevConsole;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainConstants;
import org.apache.camel.main.MainHelper;
import org.apache.camel.main.MainHttpServerFactory;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainPropertiesReload;
import org.apache.camel.main.MainSupportModelConfigurer;
import org.apache.camel.main.ProfileConfigurer;
import org.apache.camel.main.PropertiesRouteTemplateParametersSource;
import org.apache.camel.main.PropertyOptionKey;
import org.apache.camel.main.RestConfigurationProperties;
import org.apache.camel.main.RouteControllerConfigurationProperties;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.main.RoutesConfigurer;
import org.apache.camel.main.SSLConfigurationProperties;
import org.apache.camel.main.TracerConfigurationProperties;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.spi.AutowiredLifecycleStrategy;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.BacklogTracer;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.CamelMetricsService;
import org.apache.camel.spi.CamelTracingService;
import org.apache.camel.spi.CompileStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DebuggerFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RouteTemplateParameterSource;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.spi.StartupCondition;
import org.apache.camel.spi.StartupConditionStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.apache.camel.support.jsse.CipherSuitesParameters;
import org.apache.camel.support.jsse.FilterParameters;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.SSLContextServerParameters;
import org.apache.camel.support.jsse.SecureRandomParameters;
import org.apache.camel.support.jsse.TrustAllTrustManager;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.apache.camel.support.scan.PackageScanHelper;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.startup.BacklogStartupStepRecorder;
import org.apache.camel.support.startup.EnvStartupCondition;
import org.apache.camel.support.startup.FileStartupCondition;
import org.apache.camel.support.startup.LoggingStartupStepRecorder;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.LocationHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.StringHelper;
import org.apache.camel.vault.VaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMainSupport
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMainSupport.class);
    private static final String[] GROUP_PREFIXES = new String[]{"camel.context.", "camel.resilience4j.", "camel.faulttolerance.", "camel.rest.", "camel.vault.", "camel.threadpool.", "camel.health.", "camel.lra.", "camel.opentelemetry.", "camel.metrics.", "camel.routeTemplate", "camel.devConsole.", "camel.variable.", "camel.beans.", "camel.globalOptions.", "camel.server.", "camel.ssl.", "camel.debug.", "camel.trace.", "camel.routeController."};
    protected final List<MainListener> listeners = new ArrayList<MainListener>();
    protected volatile CamelContext camelContext;
    protected final MainConfigurationProperties mainConfigurationProperties = new MainConfigurationProperties();
    protected final OrderedLocationProperties wildcardProperties = new OrderedLocationProperties();
    protected RoutesCollector routesCollector = new DefaultRoutesCollector();
    protected String propertyPlaceholderLocations;
    protected String defaultPropertyPlaceholderLocation = "classpath:application.properties;optional=true,classpath:observability-services.properties;optional=true";
    protected Properties initialProperties;
    protected Properties overrideProperties;
    protected boolean standalone = true;
    protected final MainHelper helper;

    protected BaseMainSupport() {
        this.helper = new MainHelper();
    }

    protected BaseMainSupport(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.helper = new MainHelper();
    }

    public MainConfigurationProperties configure() {
        return this.mainConfigurationProperties;
    }

    public RoutesCollector getRoutesCollector() {
        return this.routesCollector;
    }

    public void setRoutesCollector(RoutesCollector routesCollector) {
        this.routesCollector = routesCollector;
    }

    public String getPropertyPlaceholderLocations() {
        return this.propertyPlaceholderLocations;
    }

    public void setPropertyPlaceholderLocations(String location) {
        this.propertyPlaceholderLocations = location;
    }

    public String getDefaultPropertyPlaceholderLocation() {
        return this.defaultPropertyPlaceholderLocation;
    }

    public void setDefaultPropertyPlaceholderLocation(String defaultPropertyPlaceholderLocation) {
        this.defaultPropertyPlaceholderLocation = defaultPropertyPlaceholderLocation;
    }

    public Properties getInitialProperties() {
        if (this.initialProperties == null) {
            this.initialProperties = new OrderedProperties();
        }
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public void setInitialProperties(Map<String, Object> initialProperties) {
        this.initialProperties = new OrderedProperties();
        this.initialProperties.putAll(initialProperties);
    }

    public void addProperty(String key, String value) {
        this.addInitialProperty(key, value);
    }

    public void addInitialProperty(String key, String value) {
        if (this.initialProperties == null) {
            this.initialProperties = new OrderedProperties();
        }
        this.initialProperties.setProperty(key, value);
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public void setOverrideProperties(Map<String, Object> initialProperties) {
        this.overrideProperties = new OrderedProperties();
        this.overrideProperties.putAll(initialProperties);
    }

    public void addOverrideProperty(String key, String value) {
        if (this.overrideProperties == null) {
            this.overrideProperties = new OrderedProperties();
        }
        this.overrideProperties.setProperty(key, value);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void addMainListener(MainListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeMainListener(MainListener listener) {
        this.listeners.remove(listener);
    }

    public List<MainListener> getMainListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    protected void loadCustomBeans(CamelContext camelContext) throws Exception {
        String basePackage = camelContext.getCamelContextExtension().getBasePackageScan();
        if (basePackage != null) {
            PackageScanHelper.registerBeans((CamelContext)camelContext, Set.of(basePackage));
        }
    }

    protected void loadConfigurations(CamelContext camelContext) throws Exception {
        String basePackage = camelContext.getCamelContextExtension().getBasePackageScan();
        if (basePackage != null) {
            this.setupBasePackage(camelContext, basePackage);
        }
        if (this.mainConfigurationProperties.getConfigurationClasses() != null) {
            this.setupConfigurationClasses(camelContext);
        }
        CamelBeanPostProcessor postProcessor = PluginHelper.getBeanPostProcessor((CamelContext)camelContext);
        Set registryConfigurations = camelContext.getRegistry().findByType(CamelConfiguration.class);
        for (CamelConfiguration camelConfiguration : registryConfigurations) {
            postProcessor.postProcessBeforeInitialization((Object)camelConfiguration, camelConfiguration.getClass().getName());
            postProcessor.postProcessAfterInitialization((Object)camelConfiguration, camelConfiguration.getClass().getName());
        }
        for (Object object : this.mainConfigurationProperties.getConfigurations()) {
            postProcessor.postProcessBeforeInitialization(object, object.getClass().getName());
            postProcessor.postProcessAfterInitialization(object, object.getClass().getName());
        }
        for (CamelConfiguration camelConfiguration : this.mainConfigurationProperties.getConfigurations()) {
            camelConfiguration.configure(camelContext);
        }
        for (CamelConfiguration camelConfiguration : registryConfigurations) {
            camelConfiguration.configure(camelContext);
        }
    }

    private void setupConfigurationClasses(CamelContext camelContext) {
        String[] configClasses;
        for (String configClass : configClasses = this.mainConfigurationProperties.getConfigurationClasses().split(",")) {
            Class configClazz = camelContext.getClassResolver().resolveClass(configClass, CamelConfiguration.class);
            boolean mainClass = false;
            try {
                configClazz.getDeclaredMethod("main", String[].class);
                mainClass = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (mainClass) continue;
            CamelConfiguration config = (CamelConfiguration)camelContext.getInjector().newInstance(configClazz);
            this.mainConfigurationProperties.addConfiguration(config);
        }
    }

    private void setupBasePackage(CamelContext camelContext, String basePackage) {
        PackageScanClassResolver pscr = PluginHelper.getPackageScanClassResolver((CamelContext)camelContext);
        Set found1 = pscr.findImplementations(CamelConfiguration.class, new String[]{basePackage});
        Set found2 = pscr.findAnnotated(Configuration.class, new String[]{basePackage});
        LinkedHashSet found = new LinkedHashSet();
        found.addAll(found1);
        found.addAll(found2);
        for (Class clazz : found) {
            Object config = camelContext.getInjector().newInstance(clazz);
            if (!(config instanceof CamelConfiguration)) continue;
            CamelConfiguration cc = (CamelConfiguration)config;
            LOG.debug("Discovered CamelConfiguration class: {}", (Object)cc);
            this.mainConfigurationProperties.addConfiguration(cc);
        }
    }

    protected void configurePropertiesService(CamelContext camelContext) throws Exception {
        Optional cloudLocations;
        Properties op;
        Properties ip;
        PropertiesComponent pc = camelContext.getPropertiesComponent();
        if (pc.getLocations().isEmpty()) {
            String locations = this.propertyPlaceholderLocations;
            if (locations == null) {
                String profile = MainHelper.lookupPropertyFromSysOrEnv("camel.main.profile").orElse(this.mainConfigurationProperties.getProfile());
                if (profile == null) {
                    Properties prop = new Properties();
                    try (InputStream is = ResourceHelper.resolveResourceAsInputStream((CamelContext)camelContext, (String)"application.properties");){
                        if (is != null) {
                            prop.load(is);
                        }
                    }
                    profile = prop.getProperty("camel.main.profile");
                }
                if (profile != null) {
                    this.mainConfigurationProperties.setProfile(profile);
                    String loc = MainConstants.profilePropertyPlaceholderLocation(profile);
                    if (!this.defaultPropertyPlaceholderLocation.contains(loc)) {
                        this.defaultPropertyPlaceholderLocation = loc + "," + this.defaultPropertyPlaceholderLocation;
                    }
                }
                locations = MainHelper.lookupPropertyFromSysOrEnv("camel.main.property-placeholder-location").orElse(this.defaultPropertyPlaceholderLocation);
            }
            if (locations != null) {
                locations = locations.trim();
            }
            if (ObjectHelper.isNotEmpty((String)locations) && !locations.endsWith("false")) {
                pc.addLocation(locations);
                if (this.defaultPropertyPlaceholderLocation.equals(locations)) {
                    LOG.debug("Properties location: {}", (Object)locations);
                } else {
                    LOG.info("Properties location: {}", (Object)locations);
                }
            }
        }
        if ((ip = this.tryLoadProperties(this.initialProperties, "camel.main.initial-properties-location", camelContext)) != null) {
            pc.setInitialProperties(ip);
        }
        if ((op = this.tryLoadProperties(this.overrideProperties, "camel.main.override-properties-location", camelContext)) != null) {
            pc.setOverrideProperties(op);
        }
        if ((cloudLocations = pc.resolveProperty("camel.main.cloud-properties-location")).isPresent()) {
            LOG.info("Cloud properties location: {}", (Object)cloudLocations);
            Properties kp = BaseMainSupport.tryLoadCloudProperties(op, (String)cloudLocations.get());
            if (kp != null) {
                pc.setOverrideProperties(kp);
            }
        }
    }

    private Properties tryLoadProperties(Properties initialProperties, String initialPropertiesLocation, CamelContext camelContext) throws IOException {
        Optional<String> location;
        Properties ip = initialProperties;
        if ((ip == null || ip.isEmpty()) && (location = MainHelper.lookupPropertyFromSysOrEnv(initialPropertiesLocation)).isPresent()) {
            try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)location.get());){
                ip = new Properties();
                ip.load(is);
            }
        }
        return ip;
    }

    private static Properties tryLoadCloudProperties(Properties overridProperties, String cloudPropertiesLocations) throws IOException {
        final OrderedLocationProperties cp = new OrderedLocationProperties();
        try {
            String[] locations;
            for (final String loc : locations = cloudPropertiesLocations.split(",")) {
                Path confPath = Paths.get(loc, new String[0]);
                if (!Files.exists(confPath, new LinkOption[0]) || !Files.isDirectory(confPath, new LinkOption[0])) continue;
                Files.walkFileTree(confPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (!Files.isDirectory(file, new LinkOption[0])) {
                            try {
                                String val = new String(Files.readAllBytes(file));
                                cp.put(loc, (Object)file.getFileName().toString(), (Object)val);
                            }
                            catch (IOException e) {
                                LOG.warn("Some error happened while reading property from cloud configuration file {}", (Object)file, (Object)e);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (overridProperties == null) {
            return cp;
        }
        Properties mergedProperties = new Properties(overridProperties);
        mergedProperties.putAll((Map<?, ?>)cp);
        return mergedProperties;
    }

    protected void configureLifecycle(CamelContext camelContext) throws Exception {
    }

    protected void autoconfigure(CamelContext camelContext) throws Exception {
        MainConfigurationDevConsole mc;
        DevConsoleRegistry dcr;
        StartupStepRecorder recorder = camelContext.getCamelContextExtension().getStartupStepRecorder();
        OrderedLocationProperties autoConfiguredProperties = new OrderedLocationProperties();
        StartupStep step = recorder.beginStep(BaseMainSupport.class, "configureMain", "Profile Configure");
        this.doInitFileConfigurations(camelContext, this.mainConfigurationProperties);
        ProfileConfigurer.configureMain(camelContext, this.mainConfigurationProperties.getProfile(), this.mainConfigurationProperties);
        recorder.endStep(step);
        step = recorder.beginStep(BaseMainSupport.class, "configureVault", "Configure Vault");
        this.doConfigureVaultFromMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        recorder.endStep(step);
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            step = recorder.beginStep(BaseMainSupport.class, "autoConfigurationFailFast", "Auto Configure");
            this.autoConfigurationFailFast(camelContext, autoConfiguredProperties);
            recorder.endStep(step);
            step = recorder.beginStep(BaseMainSupport.class, "autoConfigurationPropertiesComponent", "Auto Configure");
            this.autoConfigurationPropertiesComponent(camelContext, autoConfiguredProperties);
            recorder.endStep(step);
            step = recorder.beginStep(BaseMainSupport.class, "autoConfigurationSingleOption", "Auto Configure");
            this.autoConfigurationSingleOption(camelContext, autoConfiguredProperties, "camel.main.routesIncludePattern", value -> {
                this.mainConfigurationProperties.setRoutesIncludePattern((String)value);
                return null;
            });
            recorder.endStep(step);
            if (this.mainConfigurationProperties.isModeline()) {
                camelContext.setModeline(Boolean.valueOf(true));
            }
            step = recorder.beginStep(BaseMainSupport.class, "modelineRoutes", "Auto Configure");
            this.modelineRoutes(camelContext);
            recorder.endStep(step);
            step = recorder.beginStep(BaseMainSupport.class, "autoConfigurationMainConfiguration", "Auto Configure");
            this.autoConfigurationMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
            recorder.endStep(step);
        }
        this.configureMainListener(camelContext);
        step = recorder.beginStep(BaseMainSupport.class, "autoConfigurationStartupConditions", "Auto Configure");
        this.autoConfigurationStartupConditions(camelContext, autoConfiguredProperties);
        recorder.endStep(step);
        step = recorder.beginStep(BaseMainSupport.class, "doConfigureCamelContextFromMainConfiguration", "Auto Configure");
        this.doConfigureCamelContextFromMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        recorder.endStep(step);
        step = recorder.beginStep(BaseMainSupport.class, "configurePackageScan", "Auto Configure");
        this.configurePackageScan(camelContext);
        recorder.endStep(step);
        step = recorder.beginStep(BaseMainSupport.class, "loadCustomBeans", "Auto Configure");
        this.loadCustomBeans(camelContext);
        recorder.endStep(step);
        step = recorder.beginStep(BaseMainSupport.class, "loadConfigurations", "Auto Configure");
        this.loadConfigurations(camelContext);
        recorder.endStep(step);
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            step = recorder.beginStep(BaseMainSupport.class, "autoConfigurationFromProperties", "Auto Configure");
            this.autoConfigurationFromProperties(camelContext, autoConfiguredProperties);
            recorder.endStep(step);
            step = recorder.beginStep(BaseMainSupport.class, "autowireWildcardProperties", "Auto Configure");
            this.autowireWildcardProperties(camelContext);
            recorder.endStep(step);
            camelContext.addService((Object)new MainPropertiesReload(this));
        }
        if ((dcr = (DevConsoleRegistry)camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)) != null && (mc = (MainConfigurationDevConsole)dcr.resolveById("main-configuration")) != null) {
            mc.addStartupConfiguration(autoConfiguredProperties);
        }
        if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
            BaseMainSupport.logConfigurationSummary(autoConfiguredProperties);
        }
        this.helper.bootstrapDone();
    }

    private static void logConfigurationSummary(OrderedLocationProperties autoConfiguredProperties) {
        MainHelper.logConfigurationSummary(LOG, autoConfiguredProperties, "Variables summary", k -> k.startsWith("camel.variable."));
        MainHelper.logConfigurationSummary(LOG, autoConfiguredProperties, "Auto-configuration summary", null);
    }

    protected void configureStartupRecorder(CamelContext camelContext) {
        StartupStepRecorder fr;
        ExtendedCamelContext ecc = camelContext.getCamelContextExtension();
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        Object value = prop.remove("camel.main.startupRecorder");
        if (ObjectHelper.isNotEmpty((Object)value)) {
            this.mainConfigurationProperties.setStartupRecorder(value.toString());
        }
        if (ObjectHelper.isNotEmpty((Object)(value = prop.remove("camel.main.startupRecorderRecording")))) {
            this.mainConfigurationProperties.setStartupRecorderRecording("true".equalsIgnoreCase(value.toString()));
        }
        if (ObjectHelper.isNotEmpty((Object)(value = prop.remove("camel.main.startupRecorderProfile")))) {
            this.mainConfigurationProperties.setStartupRecorderProfile(CamelContextHelper.parseText((CamelContext)camelContext, (String)value.toString()));
        }
        if (ObjectHelper.isNotEmpty((Object)(value = prop.remove("camel.main.startupRecorderDuration")))) {
            this.mainConfigurationProperties.setStartupRecorderDuration(Long.parseLong(value.toString()));
        }
        if (ObjectHelper.isNotEmpty((Object)(value = prop.remove("camel.main.startupRecorderMaxDepth")))) {
            this.mainConfigurationProperties.setStartupRecorderMaxDepth(Integer.parseInt(value.toString()));
        }
        if ("off".equals(this.mainConfigurationProperties.getStartupRecorder()) || "false".equals(this.mainConfigurationProperties.getStartupRecorder())) {
            ecc.getStartupStepRecorder().setEnabled(false);
        } else if ("logging".equals(this.mainConfigurationProperties.getStartupRecorder())) {
            if (!(ecc.getStartupStepRecorder() instanceof LoggingStartupStepRecorder)) {
                ecc.setStartupStepRecorder((StartupStepRecorder)new LoggingStartupStepRecorder());
            }
        } else if ("backlog".equals(this.mainConfigurationProperties.getStartupRecorder())) {
            if (!(ecc.getStartupStepRecorder() instanceof BacklogStartupStepRecorder)) {
                ecc.setStartupStepRecorder((StartupStepRecorder)new BacklogStartupStepRecorder());
            }
        } else if (("jfr".equals(this.mainConfigurationProperties.getStartupRecorder()) || "java-flight-recorder".equals(this.mainConfigurationProperties.getStartupRecorder()) || this.mainConfigurationProperties.getStartupRecorder() == null) && (fr = (StartupStepRecorder)ecc.getBootstrapFactoryFinder().newInstance("startup-step-recorder", StartupStepRecorder.class).orElse(null)) != null) {
            LOG.debug("Discovered startup recorder: {} from classpath", (Object)fr);
            fr.setRecording(this.mainConfigurationProperties.isStartupRecorderRecording());
            fr.setStartupRecorderDuration(this.mainConfigurationProperties.getStartupRecorderDuration());
            fr.setRecordingProfile(this.mainConfigurationProperties.getStartupRecorderProfile());
            fr.setMaxDepth(this.mainConfigurationProperties.getStartupRecorderMaxDepth());
            camelContext.getCamelContextExtension().setStartupStepRecorder(fr);
        }
    }

    protected void configurePackageScan(CamelContext camelContext) {
        if (this.mainConfigurationProperties.isBasePackageScanEnabled()) {
            String base = this.mainConfigurationProperties.getBasePackageScan();
            String current = camelContext.getCamelContextExtension().getBasePackageScan();
            if (base != null && !base.equals(current)) {
                camelContext.getCamelContextExtension().setBasePackageScan(base);
                LOG.info("Classpath scanning enabled from base package: {}", (Object)base);
            }
        }
    }

    protected void configureMainListener(CamelContext camelContext) throws Exception {
        camelContext.getRegistry().findByType(MainListener.class).forEach(this::addMainListener);
        this.mainConfigurationProperties.getMainListeners().forEach(this::addMainListener);
        if (this.mainConfigurationProperties.getMainListenerClasses() != null) {
            for (String fqn : this.mainConfigurationProperties.getMainListenerClasses().split(",")) {
                String target = fqn.trim();
                boolean added = this.listeners.stream().map(l -> l.getClass().getName()).anyMatch(l -> l.equals(target));
                if (added) continue;
                Class clazz = camelContext.getClassResolver().resolveMandatoryClass(fqn, MainListener.class);
                this.addMainListener((MainListener)camelContext.getInjector().newInstance(clazz));
            }
        }
    }

    protected void autoConfigurationStartupConditions(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        String classes;
        String file;
        Properties propJVM;
        Properties propENV;
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.startupcondition."})).isEmpty()) {
            prop.putAll("ENV", propENV);
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.startupcondition."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
        }
        OrderedLocationProperties properties = new OrderedLocationProperties();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.startupcondition.")) continue;
            int dot = key.indexOf(46, 22);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            MainHelper.validateOptionAndValue(key, option, value);
            String loc = prop.getLocation((Object)key);
            properties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring startup condition from loaded properties: {}", (Object)properties.size());
            MainHelper.setPropertiesOnTarget(camelContext, this.mainConfigurationProperties.startupCondition(), properties, "camel.startupcondition.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.startupcondition.{}={} on object: {}", new Object[]{k, v, this.mainConfigurationProperties.startupCondition()}));
        }
        StartupConditionStrategy scs = (StartupConditionStrategy)camelContext.getCamelContextExtension().getContextPlugin(StartupConditionStrategy.class);
        scs.setEnabled(this.mainConfigurationProperties.startupCondition().isEnabled());
        scs.setInterval(this.mainConfigurationProperties.startupCondition().getInterval());
        scs.setTimeout(this.mainConfigurationProperties.startupCondition().getTimeout());
        scs.setOnTimeout(this.mainConfigurationProperties.startupCondition().getOnTimeout());
        String env = this.mainConfigurationProperties.startupCondition().getEnvironmentVariableExists();
        if (env != null) {
            scs.addStartupCondition((StartupCondition)new EnvStartupCondition(env));
        }
        if ((file = this.mainConfigurationProperties.startupCondition().getFileExists()) != null) {
            scs.addStartupCondition((StartupCondition)new FileStartupCondition(file));
        }
        if ((classes = this.mainConfigurationProperties.startupCondition().getCustomClassNames()) != null) {
            for (String fqn : classes.split(",")) {
                fqn = fqn.trim();
                Class clazz = camelContext.getClassResolver().resolveMandatoryClass(fqn, StartupCondition.class);
                scs.addStartupCondition((StartupCondition)camelContext.getInjector().newInstance(clazz));
            }
        }
    }

    protected void configureRoutesLoader(CamelContext camelContext) {
        ExtendedCamelContext ecc = camelContext.getCamelContextExtension();
        if (this.mainConfigurationProperties.getCompileWorkDir() != null) {
            CompileStrategy cs = (CompileStrategy)camelContext.getCamelContextExtension().getContextPlugin(CompileStrategy.class);
            if (cs == null) {
                cs = new DefaultCompileStrategy();
                ecc.addContextPlugin(CompileStrategy.class, (Object)cs);
            }
            cs.setWorkDir(this.mainConfigurationProperties.getCompileWorkDir());
        }
        DefaultRoutesLoader loader = new DefaultRoutesLoader();
        loader.setIgnoreLoadingError(this.mainConfigurationProperties.isRoutesCollectorIgnoreLoadingError());
        ecc.addContextPlugin(RoutesLoader.class, (Object)loader);
    }

    protected void modelineRoutes(CamelContext camelContext) throws Exception {
        RoutesConfigurer configurer = this.doCommonRouteConfiguration(camelContext);
        configurer.configureModeline(camelContext);
    }

    protected void configureRoutes(CamelContext camelContext) throws Exception {
        RoutesConfigurer configurer = this.doCommonRouteConfiguration(camelContext);
        configurer.configureRoutes(camelContext);
    }

    private RoutesConfigurer doCommonRouteConfiguration(CamelContext camelContext) {
        RoutesConfigurer configurer = new RoutesConfigurer();
        this.routesCollector.setIgnoreLoadingError(this.mainConfigurationProperties.isRoutesCollectorIgnoreLoadingError());
        if (this.mainConfigurationProperties.isRoutesCollectorEnabled()) {
            configurer.setRoutesCollector(this.routesCollector);
            configurer.setIgnoreLoadingError(this.mainConfigurationProperties.isRoutesCollectorIgnoreLoadingError());
        }
        configurer.setBeanPostProcessor(PluginHelper.getBeanPostProcessor((CamelContext)camelContext));
        configurer.setRoutesBuilders(this.mainConfigurationProperties.getRoutesBuilders());
        configurer.setRoutesBuilderClasses(this.mainConfigurationProperties.getRoutesBuilderClasses());
        if (this.mainConfigurationProperties.isBasePackageScanEnabled()) {
            configurer.setBasePackageScan(this.mainConfigurationProperties.getBasePackageScan());
        }
        configurer.setJavaRoutesExcludePattern(this.mainConfigurationProperties.getJavaRoutesExcludePattern());
        configurer.setJavaRoutesIncludePattern(this.mainConfigurationProperties.getJavaRoutesIncludePattern());
        configurer.setRoutesExcludePattern(this.mainConfigurationProperties.getRoutesExcludePattern());
        configurer.setRoutesIncludePattern(this.mainConfigurationProperties.getRoutesIncludePattern());
        return configurer;
    }

    protected LifecycleStrategy createLifecycleStrategy(CamelContext camelContext) {
        return new MainAutowiredLifecycleStrategy(camelContext);
    }

    protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        StartupStep step;
        OrderedLocationProperties propertyPlaceholders = new OrderedLocationProperties();
        camelContext.getLifecycleStrategies().removeIf(s -> s instanceof AutowiredLifecycleStrategy);
        camelContext.addLifecycleStrategy(this.createLifecycleStrategy(camelContext));
        this.configurePropertiesService(camelContext);
        PropertiesComponent pc = camelContext.getPropertiesComponent();
        pc.addPropertiesLookupListener((PropertiesLookupListener)new PropertyPlaceholderListener(propertyPlaceholders));
        this.configureStartupRecorder(camelContext);
        this.configurePackageScan(camelContext);
        this.configureRoutesLoader(camelContext);
        this.configureMainListener(camelContext);
        camelContext.build();
        StartupStepRecorder recorder = camelContext.getCamelContextExtension().getStartupStepRecorder();
        if (!this.listeners.isEmpty()) {
            step = recorder.beginStep(BaseMainSupport.class, "beforeInitialize", "MainListener");
            for (MainListener listener : this.listeners) {
                listener.beforeInitialize(this);
            }
            recorder.endStep(step);
            step = recorder.beginStep(BaseMainSupport.class, "beforeConfigure", "MainListener");
            for (MainListener listener : this.listeners) {
                listener.beforeConfigure(this);
            }
            recorder.endStep(step);
        }
        if (this.standalone) {
            step = recorder.beginStep(BaseMainSupport.class, "autoconfigure", "Auto Configure");
            this.autoconfigure(camelContext);
            recorder.endStep(step);
        }
        this.configureLifecycle(camelContext);
        if (this.standalone) {
            this.detectCamelDebugJar(camelContext);
            step = recorder.beginStep(BaseMainSupport.class, "configureRoutes", "Collect Routes");
            this.configureRoutes(camelContext);
            recorder.endStep(step);
        }
        this.postProcessCamelRegistry(camelContext, this.mainConfigurationProperties);
        if (!this.listeners.isEmpty()) {
            step = recorder.beginStep(BaseMainSupport.class, "afterConfigure", "MainListener");
            for (MainListener listener : this.listeners) {
                listener.afterConfigure(this);
            }
            recorder.endStep(step);
        }
        if (this.standalone && this.mainConfigurationProperties.isAutoConfigurationLogSummary()) {
            camelContext.getManagementStrategy().addEventNotifier((EventNotifier)new PlaceholderSummaryEventNotifier(propertyPlaceholders));
        }
    }

    protected void detectCamelDebugJar(CamelContext camelContext) {
        DebuggerFactory df = camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("debugger-factory", DebuggerFactory.class).orElse(null);
        if (df != null) {
            camelContext.setSourceLocationEnabled(Boolean.valueOf(true));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void autoConfigurationFailFast(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Object val;
        Object failFast;
        Object jvmEnabled;
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        LOG.debug("Properties from Camel properties component:");
        for (String key : prop.stringPropertyNames()) {
            LOG.debug("    {}={}", (Object)key, (Object)prop.getProperty(key));
        }
        Object envEnabled = prop.remove((Object)"camel.main.autoConfigurationEnvironmentVariablesEnabled");
        if (ObjectHelper.isNotEmpty((Object)envEnabled)) {
            this.mainConfigurationProperties.setAutoConfigurationEnvironmentVariablesEnabled(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)envEnabled.toString()));
            String loc = prop.getLocation((Object)"camel.main.autoConfigurationEnvironmentVariablesEnabled");
            autoConfiguredProperties.put(loc, (Object)"camel.main.autoConfigurationEnvironmentVariablesEnabled", (Object)envEnabled.toString());
        }
        if (ObjectHelper.isNotEmpty((Object)(jvmEnabled = prop.remove((Object)"camel.main.autoConfigurationSystemPropertiesEnabled")))) {
            this.mainConfigurationProperties.setAutoConfigurationSystemPropertiesEnabled(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)jvmEnabled.toString()));
            String loc = prop.getLocation((Object)"camel.main.autoConfigurationSystemPropertiesEnabled");
            autoConfiguredProperties.put(loc, (Object)"camel.autoConfigurationSystemPropertiesEnabled", (Object)jvmEnabled.toString());
        }
        Properties propENV = null;
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll((Map)propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String string : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)string, (Object)propENV.getProperty(string));
            }
        }
        Properties propJVM = null;
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll((Map)propJVM);
            LOG.debug("Properties from JVM system properties:");
            for (String key : propJVM.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
            }
        }
        String string = "ENV";
        Object object = failFast = propENV != null ? propENV.remove("camel.main.autoconfigurationfailfast") : null;
        if (ObjectHelper.isNotEmpty((Map)propJVM) && ObjectHelper.isNotEmpty((Object)(val = propJVM.remove("camel.main.autoconfigurationfailfast")))) {
            String string2 = "SYS";
            failFast = val;
        }
        if (ObjectHelper.isNotEmpty((Object)failFast)) {
            void var8_13;
            this.mainConfigurationProperties.setAutoConfigurationFailFast(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)failFast.toString()));
            autoConfiguredProperties.put((String)var8_13, (Object)"camel.main.autoConfigurationFailFast", (Object)failFast.toString());
        } else {
            String string3 = prop.getLocation((Object)"camel.main.autoConfigurationFailFast");
            failFast = prop.remove((Object)"camel.main.autoConfigurationFailFast");
            if (ObjectHelper.isNotEmpty((Object)failFast)) {
                this.mainConfigurationProperties.setAutoConfigurationFailFast(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)failFast.toString()));
                autoConfiguredProperties.put(string3, (Object)"camel.main.autoConfigurationFailFast", (Object)failFast.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void autoConfigurationSingleOption(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties, String optionName, Function<String, Object> setter) {
        Object val;
        Object value;
        String lowerOptionName = optionName.toLowerCase(Locale.US);
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        LOG.debug("Properties from Camel properties component:");
        for (Object key : prop.stringPropertyNames()) {
            LOG.debug("    {}={}", key, (Object)prop.getProperty((String)key));
        }
        Properties propENV = null;
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll("ENV", propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String string : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)string, (Object)propENV.getProperty(string));
            }
        }
        Properties propJVM = null;
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
            LOG.debug("Properties from JVM system properties:");
            for (String key : propJVM.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
            }
        }
        String string = "ENV";
        Object object = value = propENV != null ? propENV.remove(lowerOptionName) : null;
        if (ObjectHelper.isNotEmpty((Map)propJVM) && ObjectHelper.isNotEmpty((Object)(val = propJVM.remove(optionName)))) {
            String string2 = "SYS";
            value = val;
        }
        if (ObjectHelper.isEmpty((Object)value)) {
            String string3 = prop.getLocation((Object)optionName);
            value = prop.remove((Object)optionName);
        }
        if (ObjectHelper.isEmpty((Object)value)) {
            value = this.getInitialProperties().getProperty(optionName);
            String string4 = "initial";
        }
        if (ObjectHelper.isNotEmpty((Object)value)) {
            void var9_18;
            String str = CamelContextHelper.parseText((CamelContext)camelContext, (String)value.toString());
            setter.apply(str);
            autoConfiguredProperties.put((String)var9_18, (Object)optionName, (Object)value.toString());
        }
    }

    protected void doConfigureVaultFromMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Properties propJVM;
        Properties propENV;
        OrderedLocationProperties vaultProperties = new OrderedLocationProperties();
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(GROUP_PREFIXES)).isEmpty()) {
            prop.putAll("ENV", propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String key : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propENV.getProperty(key));
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(GROUP_PREFIXES)).isEmpty()) {
            prop.putAll("SYS", propJVM);
            LOG.debug("Properties from JVM system properties:");
            for (String key : propJVM.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
            }
        }
        for (String key : prop.stringPropertyNames()) {
            String loc = prop.getLocation((Object)key);
            if (!StringHelper.startsWithIgnoreCase((String)key, (String)"camel.vault.")) continue;
            String value = prop.getProperty(key);
            String option = key.substring(12);
            MainHelper.validateOptionAndValue(key, option, value);
            vaultProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
        }
        if (!vaultProperties.isEmpty() || this.mainConfigurationProperties.hasVaultConfiguration()) {
            LOG.debug("Auto-configuring Vault from loaded properties: {}", (Object)vaultProperties.size());
            this.setVaultProperties(camelContext, vaultProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!vaultProperties.isEmpty()) {
            vaultProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.vault.{}={}", k, v));
        }
    }

    protected void doInitFileConfigurations(CamelContext camelContext, MainConfigurationProperties config) throws Exception {
        if (ObjectHelper.isNotEmpty((String)config.getFileConfigurations())) {
            String[] locs;
            for (String loc : locs = config.getFileConfigurations().split(",")) {
                String pattern;
                File[] files;
                String path = FileUtil.onlyPath((String)loc);
                if (path == null || (files = new File(path).listFiles(arg_0 -> BaseMainSupport.lambda$doInitFileConfigurations$12(pattern = loc.length() > path.length() ? loc.substring(path.length() + 1) : null, arg_0))) == null) continue;
                for (File file : files) {
                    Properties props = new Properties();
                    try (FileInputStream is = new FileInputStream(file);){
                        props.load(is);
                    }
                    if (props.isEmpty()) continue;
                    if (this.overrideProperties == null) {
                        this.overrideProperties = new Properties();
                        PropertiesComponent pc = camelContext.getPropertiesComponent();
                        pc.setOverrideProperties(this.overrideProperties);
                    }
                    LOG.info("Loaded additional {} properties from file: {}", (Object)props.size(), (Object)file);
                    this.overrideProperties.putAll((Map<?, ?>)props);
                }
            }
        }
    }

    protected void doConfigureCamelContextFromMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        boolean hc;
        Properties propJVM;
        Properties propENV;
        DefaultConfigurationConfigurer.configure(camelContext, config);
        this.preProcessCamelRegistry(camelContext, config);
        DefaultConfigurationConfigurer.afterConfigure(camelContext);
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(GROUP_PREFIXES)).isEmpty()) {
            prop.putAll("ENV", propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String key : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propENV.getProperty(key));
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(GROUP_PREFIXES)).isEmpty()) {
            prop.putAll("SYS", propJVM);
            LOG.debug("Properties from JVM system properties:");
            for (String key : propJVM.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
            }
        }
        OrderedLocationProperties contextProperties = new OrderedLocationProperties();
        OrderedLocationProperties resilience4jProperties = new OrderedLocationProperties();
        OrderedLocationProperties faultToleranceProperties = new OrderedLocationProperties();
        OrderedLocationProperties restProperties = new OrderedLocationProperties();
        OrderedLocationProperties threadPoolProperties = new OrderedLocationProperties();
        OrderedLocationProperties healthProperties = new OrderedLocationProperties();
        OrderedLocationProperties lraProperties = new OrderedLocationProperties();
        OrderedLocationProperties otelProperties = new OrderedLocationProperties();
        OrderedLocationProperties metricsProperties = new OrderedLocationProperties();
        OrderedLocationProperties routeTemplateProperties = new OrderedLocationProperties();
        OrderedLocationProperties variableProperties = new OrderedLocationProperties();
        OrderedLocationProperties beansProperties = new OrderedLocationProperties();
        OrderedLocationProperties devConsoleProperties = new OrderedLocationProperties();
        OrderedLocationProperties globalOptions = new OrderedLocationProperties();
        OrderedLocationProperties httpServerProperties = new OrderedLocationProperties();
        OrderedLocationProperties sslProperties = new OrderedLocationProperties();
        OrderedLocationProperties debuggerProperties = new OrderedLocationProperties();
        OrderedLocationProperties tracerProperties = new OrderedLocationProperties();
        OrderedLocationProperties routeControllerProperties = new OrderedLocationProperties();
        for (String key : prop.stringPropertyNames()) {
            String option;
            String value;
            String loc = prop.getLocation((Object)key);
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.context.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                MainHelper.validateOptionAndValue(key, option, value);
                contextProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.resilience4j.")) {
                value = prop.getProperty(key);
                option = key.substring(19);
                MainHelper.validateOptionAndValue(key, option, value);
                resilience4jProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.faulttolerance.")) {
                value = prop.getProperty(key);
                option = key.substring(21);
                MainHelper.validateOptionAndValue(key, option, value);
                faultToleranceProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.rest.")) {
                value = prop.getProperty(key);
                option = key.substring(11);
                MainHelper.validateOptionAndValue(key, option, value);
                restProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.threadpool.")) {
                value = prop.getProperty(key);
                option = key.substring(17);
                MainHelper.validateOptionAndValue(key, option, value);
                threadPoolProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.health.")) {
                value = prop.getProperty(key);
                option = key.substring(13);
                MainHelper.validateOptionAndValue(key, option, value);
                healthProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.lra.")) {
                value = prop.getProperty(key);
                option = key.substring(10);
                MainHelper.validateOptionAndValue(key, option, value);
                lraProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.opentelemetry.")) {
                value = prop.getProperty(key);
                option = key.substring(20);
                MainHelper.validateOptionAndValue(key, option, value);
                otelProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.metrics.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                MainHelper.validateOptionAndValue(key, option, value);
                metricsProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.routeTemplate")) {
                value = prop.getProperty(key);
                option = key.substring(19);
                MainHelper.validateOptionAndValue(key, option, value);
                routeTemplateProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.devConsole.")) {
                value = prop.getProperty(key);
                option = key.substring(17);
                MainHelper.validateOptionAndValue(key, option, value);
                devConsoleProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.variable.")) {
                value = prop.getProperty(key);
                option = key.substring(15);
                MainHelper.validateOptionAndValue(key, option, value);
                variableProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.beans.")) {
                value = prop.getProperty(key);
                option = key.substring(12);
                MainHelper.validateOptionAndValue(key, option, value);
                beansProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.globalOptions.")) {
                value = prop.getProperty(key);
                option = key.substring(20);
                MainHelper.validateOptionAndValue(key, option, value);
                globalOptions.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.server.")) {
                value = prop.getProperty(key);
                option = key.substring(13);
                MainHelper.validateOptionAndValue(key, option, value);
                httpServerProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.ssl.")) {
                value = prop.getProperty(key);
                option = key.substring(10);
                MainHelper.validateOptionAndValue(key, option, value);
                sslProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.debug.")) {
                value = prop.getProperty(key);
                option = key.substring(12);
                MainHelper.validateOptionAndValue(key, option, value);
                debuggerProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase((String)key, (String)"camel.trace.")) {
                value = prop.getProperty(key);
                option = key.substring(12);
                MainHelper.validateOptionAndValue(key, option, value);
                tracerProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (!StringHelper.startsWithIgnoreCase((String)key, (String)"camel.routeController.")) continue;
            value = prop.getProperty(key);
            option = key.substring(22);
            MainHelper.validateOptionAndValue(key, option, value);
            routeControllerProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
        }
        if (!globalOptions.isEmpty()) {
            for (String name2 : globalOptions.stringPropertyNames()) {
                String value = globalOptions.getProperty(name2);
                this.mainConfigurationProperties.addGlobalOption(name2, value);
            }
        }
        if (!variableProperties.isEmpty()) {
            LOG.debug("Auto-configuring Variables from loaded properties: {}", (Object)variableProperties.size());
            MainSupportModelConfigurer.setVariableProperties(camelContext, variableProperties, autoConfiguredProperties);
        }
        if (!beansProperties.isEmpty()) {
            LOG.debug("Creating and binding beans to registry from loaded properties: {}", (Object)beansProperties.size());
            this.bindBeansToRegistry(camelContext, beansProperties, "camel.beans.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), this.mainConfigurationProperties.isAutoConfigurationLogSummary(), true, autoConfiguredProperties);
        }
        if (!contextProperties.isEmpty()) {
            LOG.debug("Auto-configuring CamelContext from loaded properties: {}", (Object)contextProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, camelContext, contextProperties, "camel.context.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            MainHelper.setPropertiesOnTarget(camelContext, camelContext.getCamelContextExtension(), contextProperties, "camel.context.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!restProperties.isEmpty() || this.mainConfigurationProperties.hasRestConfiguration()) {
            RestConfigurationProperties rest = this.mainConfigurationProperties.rest();
            LOG.debug("Auto-configuring Rest DSL from loaded properties: {}", (Object)restProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, (Object)rest, restProperties, "camel.rest.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            camelContext.setRestConfiguration((RestConfiguration)rest);
        }
        if (!httpServerProperties.isEmpty() || this.mainConfigurationProperties.hasHttpServerConfiguration()) {
            LOG.debug("Auto-configuring HTTP Server from loaded properties: {}", (Object)httpServerProperties.size());
            this.setHttpServerProperties(camelContext, httpServerProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!threadPoolProperties.isEmpty() || this.mainConfigurationProperties.hasThreadPoolConfiguration()) {
            LOG.debug("Auto-configuring Thread Pool from loaded properties: {}", (Object)threadPoolProperties.size());
            MainSupportModelConfigurer.setThreadPoolProperties(camelContext, this.mainConfigurationProperties, threadPoolProperties, autoConfiguredProperties);
        }
        boolean bl = hc = this.mainConfigurationProperties.health().getEnabled() != null;
        if (hc || !healthProperties.isEmpty() || this.mainConfigurationProperties.hasHealthCheckConfiguration()) {
            LOG.debug("Auto-configuring HealthCheck from loaded properties: {}", (Object)healthProperties.size());
            this.setHealthCheckProperties(camelContext, healthProperties, autoConfiguredProperties);
        }
        if (!routeTemplateProperties.isEmpty()) {
            LOG.debug("Auto-configuring Route templates from loaded properties: {}", (Object)routeTemplateProperties.size());
            this.setRouteTemplateProperties(camelContext, routeTemplateProperties, autoConfiguredProperties);
        }
        if (!lraProperties.isEmpty() || this.mainConfigurationProperties.hasLraConfiguration()) {
            LOG.debug("Auto-configuring Saga LRA from loaded properties: {}", (Object)lraProperties.size());
            this.setLraCheckProperties(camelContext, lraProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!otelProperties.isEmpty() || this.mainConfigurationProperties.hasOtelConfiguration()) {
            LOG.debug("Auto-configuring OpenTelemetry from loaded properties: {}", (Object)otelProperties.size());
            this.setOtelProperties(camelContext, otelProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!metricsProperties.isEmpty() || this.mainConfigurationProperties.hasMetricsConfiguration()) {
            LOG.debug("Auto-configuring Micrometer metrics from loaded properties: {}", (Object)metricsProperties.size());
            this.setMetricsProperties(camelContext, metricsProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!devConsoleProperties.isEmpty()) {
            LOG.debug("Auto-configuring Dev Console from loaded properties: {}", (Object)devConsoleProperties.size());
            this.setDevConsoleProperties(camelContext, devConsoleProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!sslProperties.isEmpty() || this.mainConfigurationProperties.hasSslConfiguration()) {
            LOG.debug("Auto-configuring SSL from loaded properties: {}", (Object)sslProperties.size());
            this.setSslProperties(camelContext, sslProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!debuggerProperties.isEmpty() || this.mainConfigurationProperties.hasDebuggerConfiguration()) {
            LOG.debug("Auto-configuring Debugger from loaded properties: {}", (Object)debuggerProperties.size());
            this.setDebuggerProperties(camelContext, debuggerProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!tracerProperties.isEmpty() || this.mainConfigurationProperties.hasTracerConfiguration()) {
            LOG.debug("Auto-configuring Tracer from loaded properties: {}", (Object)tracerProperties.size());
            this.setTracerProperties(camelContext, tracerProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!routeControllerProperties.isEmpty() || this.mainConfigurationProperties.hasRouteControllerConfiguration()) {
            LOG.debug("Auto-configuring Route Controller from loaded properties: {}", (Object)routeControllerProperties.size());
            this.setRouteControllerProperties(camelContext, routeControllerProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        MainSupportModelConfigurer.configureModelCamelContext(camelContext, this.mainConfigurationProperties, autoConfiguredProperties, resilience4jProperties, faultToleranceProperties);
        if (!variableProperties.isEmpty()) {
            variableProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.variable.{}={}", k, v));
        }
        if (!beansProperties.isEmpty()) {
            beansProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.beans.{}={}", k, v));
        }
        if (!contextProperties.isEmpty()) {
            contextProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.context.{}={}", k, v));
        }
        if (!resilience4jProperties.isEmpty()) {
            resilience4jProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.resilience4j.{}={}", k, v));
        }
        if (!faultToleranceProperties.isEmpty()) {
            faultToleranceProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.faulttolerance.{}={}", k, v));
        }
        if (!restProperties.isEmpty()) {
            restProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.rest.{}={}", k, v));
        }
        if (!threadPoolProperties.isEmpty()) {
            threadPoolProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.threadpool.{}={}", k, v));
        }
        if (!healthProperties.isEmpty()) {
            healthProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.health.{}={}", k, v));
        }
        if (!sslProperties.isEmpty()) {
            sslProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.ssl.{}={}", k, v));
        }
        if (!debuggerProperties.isEmpty()) {
            debuggerProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.debug.{}={}", k, v));
        }
        if (!routeControllerProperties.isEmpty()) {
            routeControllerProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.routeController.{}={}", k, v));
        }
        if (!devConsoleProperties.isEmpty()) {
            devConsoleProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.devConsole.{}={}", k, v));
        }
        if (!routeTemplateProperties.isEmpty()) {
            routeTemplateProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.routetemplate.{}={}", k, v));
        }
        if (!lraProperties.isEmpty()) {
            lraProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.lra.{}={}", k, v));
        }
        if (!otelProperties.isEmpty()) {
            otelProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.opentelemetry.{}={}", k, v));
        }
        if (!httpServerProperties.isEmpty()) {
            httpServerProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.server.{}={}", k, v));
        }
        DefaultConfigurationConfigurer.afterPropertiesSet(camelContext);
    }

    protected void preProcessCamelRegistry(CamelContext camelContext, MainConfigurationProperties config) {
    }

    protected void postProcessCamelRegistry(CamelContext camelContext, MainConfigurationProperties config) {
    }

    private void setRouteTemplateProperties(CamelContext camelContext, OrderedLocationProperties routeTemplateProperties, OrderedLocationProperties autoConfiguredProperties) {
        PropertiesRouteTemplateParametersSource source = new PropertiesRouteTemplateParametersSource();
        for (Map.Entry entry : routeTemplateProperties.entrySet()) {
            String key = entry.getKey().toString();
            String id = StringHelper.between((String)key, (String)"[", (String)"]");
            key = StringHelper.after((String)key, (String)"].");
            source.addParameter(id, key, entry.getValue());
        }
        camelContext.getRegistry().bind("CamelMainRouteTemplateParametersSource", RouteTemplateParameterSource.class, (Object)source);
        TreeMap<String, Object> sorted = new TreeMap<String, Object>(routeTemplateProperties.asMap());
        sorted.forEach((k, v) -> {
            String loc = routeTemplateProperties.getLocation(k);
            autoConfiguredProperties.put(loc, (Object)("camel.routeTemplate" + k), (Object)v.toString());
        });
        routeTemplateProperties.clear();
    }

    private void setHealthCheckProperties(CamelContext camelContext, OrderedLocationProperties healthCheckProperties, OrderedLocationProperties autoConfiguredProperties) {
        HealthCheck hc;
        HealthConfigurationProperties health = this.mainConfigurationProperties.health();
        MainHelper.setPropertiesOnTarget(camelContext, health, healthCheckProperties, "camel.health.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        if (health.getEnabled() != null && !health.getEnabled().booleanValue()) {
            return;
        }
        HealthCheckRegistry hcr = (HealthCheckRegistry)camelContext.getCamelContextExtension().getContextPlugin(HealthCheckRegistry.class);
        if (hcr == null) {
            if (health.getEnabled() != null && health.getEnabled().booleanValue()) {
                LOG.warn("Cannot find HealthCheckRegistry from classpath. Add camel-health to classpath.");
            }
            return;
        }
        if (health.getEnabled() != null) {
            hcr.setEnabled(health.getEnabled().booleanValue());
        }
        if (health.getExcludePattern() != null) {
            hcr.setExcludePattern(health.getExcludePattern());
        }
        if (health.getExposureLevel() != null) {
            hcr.setExposureLevel(health.getExposureLevel());
        }
        if (health.getInitialState() != null) {
            hcr.setInitialState((HealthCheck.State)camelContext.getTypeConverter().convertTo(HealthCheck.State.class, (Object)health.getInitialState()));
        }
        if (hcr.isEnabled() && (hc = (HealthCheck)hcr.resolveById("context")) != null) {
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("routes").orElse((HealthCheckRepository)hcr.resolveById("routes"))) != null) {
            if (health.getRoutesEnabled() != null) {
                hc.setEnabled(health.getRoutesEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("producers").orElse((HealthCheckRepository)hcr.resolveById("producers"))) != null) {
            if (health.getProducersEnabled() == null) {
                hc.setEnabled(false);
            } else {
                hc.setEnabled(health.getProducersEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("consumers").orElse((HealthCheckRepository)hcr.resolveById("consumers"))) != null) {
            if (health.getConsumersEnabled() != null) {
                hc.setEnabled(health.getConsumersEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("registry").orElse((HealthCheckRepository)hcr.resolveById("registry"))) != null) {
            if (health.getRegistryEnabled() != null) {
                hc.setEnabled(health.getRegistryEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
    }

    private void setLraCheckProperties(CamelContext camelContext, OrderedLocationProperties lraProperties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        boolean enabled;
        String loc = lraProperties.getLocation((Object)"enabled");
        Object obj = lraProperties.remove((Object)"enabled");
        if (ObjectHelper.isNotEmpty((Object)obj)) {
            autoConfiguredProperties.put(loc, (Object)"camel.lra.enabled", (Object)obj.toString());
        }
        boolean bl = enabled = obj != null ? CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)obj.toString()) : true;
        if (enabled) {
            CamelSagaService css = BaseMainSupport.resolveLraSagaService(camelContext);
            MainHelper.setPropertiesOnTarget(camelContext, css, lraProperties, "camel.lra.", failIfNotSet, true, autoConfiguredProperties);
            camelContext.addService((Object)css, true, true);
        }
    }

    private void setOtelProperties(CamelContext camelContext, OrderedLocationProperties otelProperties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        boolean enabled;
        String loc = otelProperties.getLocation((Object)"enabled");
        Object obj = otelProperties.remove((Object)"enabled");
        if (ObjectHelper.isNotEmpty((Object)obj)) {
            autoConfiguredProperties.put(loc, (Object)"camel.opentelemetry.enabled", (Object)obj.toString());
        }
        boolean bl = enabled = obj != null ? CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)obj.toString()) : true;
        if (enabled) {
            CamelTracingService otel = BaseMainSupport.resolveOtelService(camelContext);
            MainHelper.setPropertiesOnTarget(camelContext, otel, otelProperties, "camel.opentelemetry.", failIfNotSet, true, autoConfiguredProperties);
            if (camelContext.hasService(CamelTracingService.class) == null) {
                camelContext.addService((Object)otel, true, true);
            }
        }
    }

    private void setMetricsProperties(CamelContext camelContext, OrderedLocationProperties metricsProperties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        boolean enabled;
        String loc = metricsProperties.getLocation((Object)"enabled");
        Object obj = metricsProperties.remove((Object)"enabled");
        if (ObjectHelper.isNotEmpty((Object)obj)) {
            autoConfiguredProperties.put(loc, (Object)"camel.metrics.enabled", (Object)obj.toString());
        }
        boolean bl = enabled = obj != null ? CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)obj.toString()) : true;
        if (enabled) {
            CamelMetricsService micrometer = BaseMainSupport.resolveMicrometerService(camelContext);
            MainHelper.setPropertiesOnTarget(camelContext, micrometer, metricsProperties, "camel.metrics.", failIfNotSet, true, autoConfiguredProperties);
            if (camelContext.hasService(CamelMetricsService.class) == null) {
                camelContext.addService((Object)micrometer, true, true);
            }
        }
    }

    private void setDevConsoleProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) {
        LinkedHashSet keys = new LinkedHashSet(properties.asMap().keySet());
        for (String key : keys) {
            String name = StringHelper.before((String)key, (String)".");
            DevConsole console = ((DevConsoleRegistry)camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById(name);
            if (console == null) {
                throw new IllegalArgumentException("Cannot resolve DevConsole with id: " + name);
            }
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + ".");
            MainHelper.setPropertiesOnTarget(camelContext, console, config, "camel.devConsole." + name + ".", failIfNotSet, true, autoConfiguredProperties);
        }
    }

    private void setHttpServerProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        HttpServerConfigurationProperties server = this.mainConfigurationProperties.httpServer();
        MainHelper.setPropertiesOnTarget(camelContext, server, properties, "camel.server.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        if (!server.isEnabled()) {
            return;
        }
        MainHttpServerFactory sf = BaseMainSupport.resolveMainHttpServerFactory(camelContext);
        Service http = sf.newHttpServer(camelContext, server);
        camelContext.addService((Object)http, true, true);
    }

    private void setVaultProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) {
        if (this.mainConfigurationProperties.hasVaultConfiguration()) {
            camelContext.setVaultConfiguration((VaultConfiguration)this.mainConfigurationProperties.vault());
        }
        VaultConfiguration target = camelContext.getVaultConfiguration();
        LinkedHashSet keys = new LinkedHashSet(properties.asMap().keySet());
        for (String key : keys) {
            String name = StringHelper.before((String)key, (String)".");
            if ("aws".equalsIgnoreCase(name)) {
                target = target.aws();
            }
            if ("gcp".equalsIgnoreCase(name)) {
                target = target.gcp();
            }
            if ("azure".equalsIgnoreCase(name)) {
                target = target.azure();
            }
            if ("hashicorp".equalsIgnoreCase(name)) {
                target = target.hashicorp();
            }
            if ("kubernetes".equalsIgnoreCase(name)) {
                target = target.kubernetes();
            }
            if ("kubernetescm".equalsIgnoreCase(name)) {
                target = target.kubernetesConfigmaps();
            }
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + ".");
            MainHelper.setPropertiesOnTarget(camelContext, target, config, "camel.vault." + name + ".", failIfNotSet, true, autoConfiguredProperties);
        }
    }

    private void setSslProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) {
        SSLConfigurationProperties sslConfig = this.mainConfigurationProperties.sslConfig();
        MainHelper.setPropertiesOnTarget(camelContext, sslConfig, properties, "camel.ssl.", failIfNotSet, true, autoConfiguredProperties);
        if (!sslConfig.isEnabled()) {
            return;
        }
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setCamelContext(camelContext);
        ksp.setResource(sslConfig.getKeyStore());
        ksp.setType(sslConfig.getKeyStoreType());
        ksp.setPassword(sslConfig.getKeystorePassword());
        ksp.setProvider(sslConfig.getKeyStoreProvider());
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setCamelContext(camelContext);
        kmp.setKeyPassword(sslConfig.getKeystorePassword());
        kmp.setKeyStore(ksp);
        kmp.setAlgorithm(sslConfig.getKeyManagerAlgorithm());
        kmp.setProvider(sslConfig.getKeyManagerProvider());
        SSLContextParameters sslContextParameters = BaseMainSupport.createSSLContextParameters(camelContext, sslConfig, kmp);
        camelContext.setSSLContextParameters(sslContextParameters);
    }

    private static SSLContextParameters createSSLContextParameters(CamelContext camelContext, SSLConfigurationProperties sslConfig, KeyManagersParameters kmp) {
        TrustManagersParameters tmp = null;
        if (sslConfig.isTrustAllCertificates()) {
            tmp = new TrustManagersParameters();
            tmp.setCamelContext(camelContext);
            tmp.setTrustManager((TrustManager)TrustAllTrustManager.INSTANCE);
            LOG.warn("Trust all certifications enabled. Using this in production can expose the application to man-in-the-middle attacks");
        } else if (sslConfig.getTrustStore() != null) {
            KeyStoreParameters tsp = new KeyStoreParameters();
            String store = sslConfig.getTrustStore();
            if (store != null && store.startsWith("#bean:")) {
                tsp.setKeyStore((KeyStore)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)store.substring(6), KeyStore.class));
            } else {
                tsp.setResource(store);
            }
            tsp.setPassword(sslConfig.getTrustStorePassword());
            tmp = new TrustManagersParameters();
            tmp.setCamelContext(camelContext);
            tmp.setKeyStore(tsp);
        }
        SSLContextServerParameters scsp = new SSLContextServerParameters();
        scsp.setCamelContext(camelContext);
        scsp.setClientAuthentication(sslConfig.getClientAuthentication());
        SecureRandomParameters srp = null;
        if (sslConfig.getSecureRandomAlgorithm() != null || sslConfig.getSecureRandomProvider() != null) {
            srp = new SecureRandomParameters();
            srp.setCamelContext(camelContext);
            srp.setAlgorithm(sslConfig.getSecureRandomAlgorithm());
            srp.setProvider(sslConfig.getSecureRandomProvider());
        }
        SSLContextParameters sslContextParameters = new SSLContextParameters();
        sslContextParameters.setCamelContext(camelContext);
        sslContextParameters.setProvider(sslConfig.getProvider());
        sslContextParameters.setSecureSocketProtocol(sslConfig.getSecureSocketProtocol());
        sslContextParameters.setCertAlias(sslConfig.getCertAlias());
        if (sslConfig.getSessionTimeout() > 0) {
            sslContextParameters.setSessionTimeout("" + sslConfig.getSessionTimeout());
        }
        if (sslConfig.getCipherSuites() != null) {
            CipherSuitesParameters csp = new CipherSuitesParameters();
            for (String c : sslConfig.getCipherSuites().split(",")) {
                csp.addCipherSuite(c);
            }
            sslContextParameters.setCipherSuites(csp);
        }
        if (sslConfig.getCipherSuitesInclude() != null || sslConfig.getCipherSuitesExclude() != null) {
            FilterParameters fp = new FilterParameters();
            if (sslConfig.getCipherSuitesInclude() != null) {
                for (String c : sslConfig.getCipherSuitesInclude().split(",")) {
                    fp.addInclude(c);
                }
            }
            if (sslConfig.getCipherSuitesExclude() != null) {
                for (String c : sslConfig.getCipherSuitesExclude().split(",")) {
                    fp.addExclude(c);
                }
            }
            sslContextParameters.setCipherSuitesFilter(fp);
        }
        sslContextParameters.setKeyManagers(kmp);
        sslContextParameters.setTrustManagers(tmp);
        sslContextParameters.setServerParameters(scsp);
        sslContextParameters.setSecureRandom(srp);
        return sslContextParameters;
    }

    private void setDebuggerProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        DebuggerConfigurationProperties config = this.mainConfigurationProperties.debuggerConfig();
        MainHelper.setPropertiesOnTarget(camelContext, config, properties, "camel.debug.", failIfNotSet, true, autoConfiguredProperties);
        if (!config.isEnabled() && !config.isStandby()) {
            return;
        }
        camelContext.setSourceLocationEnabled(Boolean.valueOf(true));
        camelContext.setMessageHistory(Boolean.valueOf(true));
        camelContext.setDebugging(Boolean.valueOf(config.isEnabled()));
        camelContext.setDebugStandby(config.isStandby());
        final BacklogDebugger debugger = DefaultBacklogDebugger.createDebugger((CamelContext)camelContext);
        debugger.setStandby(config.isStandby());
        debugger.setInitialBreakpoints(config.getBreakpoints());
        debugger.setSingleStepIncludeStartEnd(config.isSingleStepIncludeStartEnd());
        debugger.setBodyMaxChars(config.getBodyMaxChars());
        debugger.setBodyIncludeStreams(config.isBodyIncludeStreams());
        debugger.setBodyIncludeFiles(config.isBodyIncludeFiles());
        debugger.setIncludeExchangeProperties(config.isIncludeExchangeProperties());
        debugger.setIncludeExchangeVariables(config.isIncludeExchangeVariables());
        debugger.setIncludeException(config.isIncludeException());
        debugger.setLoggingLevel(config.getLoggingLevel().name());
        debugger.setSuspendMode(config.isWaitForAttach());
        debugger.setFallbackTimeout(config.getFallbackTimeout());
        if (config.isJmxConnectorEnabled()) {
            DebuggerJmxConnectorService connector = new DebuggerJmxConnectorService();
            connector.setCreateConnector(true);
            connector.setRegistryPort(config.getJmxConnectorPort());
            camelContext.addService((Object)connector);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onContextStarted(CamelContext context) {
                if (!debugger.isStandby()) {
                    debugger.enableDebugger();
                }
            }

            public void onContextStopping(CamelContext context) {
                debugger.disableDebugger();
            }
        });
        camelContext.addService((Object)debugger);
    }

    private void setTracerProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        TracerConfigurationProperties config = this.mainConfigurationProperties.tracerConfig();
        MainHelper.setPropertiesOnTarget(camelContext, config, properties, "camel.trace.", failIfNotSet, true, autoConfiguredProperties);
        if (!config.isEnabled() && !config.isStandby()) {
            return;
        }
        camelContext.setSourceLocationEnabled(Boolean.valueOf(true));
        camelContext.setBacklogTracing(Boolean.valueOf(config.isEnabled()));
        camelContext.setBacklogTracingStandby(config.isStandby());
        camelContext.setBacklogTracingTemplates(config.isTraceTemplates());
        org.apache.camel.impl.debugger.BacklogTracer tracer = org.apache.camel.impl.debugger.BacklogTracer.createTracer((CamelContext)camelContext);
        tracer.setEnabled(config.isEnabled());
        tracer.setStandby(config.isStandby());
        tracer.setBacklogSize(config.getBacklogSize());
        tracer.setRemoveOnDump(config.isRemoveOnDump());
        tracer.setBodyMaxChars(config.getBodyMaxChars());
        tracer.setBodyIncludeStreams(config.isBodyIncludeStreams());
        tracer.setBodyIncludeFiles(config.isBodyIncludeFiles());
        tracer.setIncludeExchangeProperties(config.isIncludeExchangeProperties());
        tracer.setIncludeExchangeVariables(config.isIncludeExchangeVariables());
        tracer.setIncludeException(config.isIncludeException());
        tracer.setTraceRests(config.isTraceRests());
        tracer.setTraceTemplates(config.isTraceTemplates());
        tracer.setTracePattern(config.getTracePattern());
        tracer.setTraceFilter(config.getTraceFilter());
        camelContext.getCamelContextExtension().addContextPlugin(BacklogTracer.class, (Object)tracer);
        camelContext.addService((Object)tracer);
    }

    private void setRouteControllerProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        RouteControllerConfigurationProperties config = this.mainConfigurationProperties.routeControllerConfig();
        MainHelper.setPropertiesOnTarget(camelContext, config, properties, "camel.routeController.", failIfNotSet, true, autoConfiguredProperties);
        if (config.isEnabled()) {
            SupervisingRouteController src = camelContext.getRouteController().supervising();
            if (config.getIncludeRoutes() != null) {
                src.setIncludeRoutes(config.getIncludeRoutes());
            }
            if (config.getExcludeRoutes() != null) {
                src.setExcludeRoutes(config.getExcludeRoutes());
            }
            if (config.getThreadPoolSize() > 0) {
                src.setThreadPoolSize(config.getThreadPoolSize());
            }
            if (config.getBackOffDelay() > 0L) {
                src.setBackOffDelay(config.getBackOffDelay());
            }
            if (config.getInitialDelay() > 0L) {
                src.setInitialDelay(config.getInitialDelay());
            }
            if (config.getBackOffMaxAttempts() > 0L) {
                src.setBackOffMaxAttempts(config.getBackOffMaxAttempts());
            }
            if (config.getBackOffMaxDelay() > 0L) {
                src.setBackOffMaxDelay(config.getBackOffDelay());
            }
            if (config.getBackOffMaxElapsedTime() > 0L) {
                src.setBackOffMaxElapsedTime(config.getBackOffMaxElapsedTime());
            }
            if (config.getBackOffMultiplier() > 0.0) {
                src.setBackOffMultiplier(config.getBackOffMultiplier());
            }
            src.setUnhealthyOnExhausted(config.isUnhealthyOnExhausted());
            src.setUnhealthyOnRestarting(config.isUnhealthyOnRestarting());
        }
    }

    private void bindBeansToRegistry(CamelContext camelContext, OrderedLocationProperties properties, String optionPrefix, boolean failIfNotSet, boolean logSummary, boolean ignoreCase, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Object bean;
        LinkedHashSet keys = new LinkedHashSet(properties.asMap().keySet());
        Set beansDot = properties.keySet().stream().map(k -> StringHelper.before((String)k.toString(), (String)".", (String)k.toString())).filter(k -> k.indexOf(91) == -1).collect(Collectors.toSet());
        Set beansMap = properties.keySet().stream().map(k -> StringHelper.before((String)k.toString(), (String)"[", (String)k.toString())).filter(k -> k.indexOf(46) == -1).collect(Collectors.toSet());
        for (String key2 : keys) {
            if (key2.indexOf(46) != -1 || key2.indexOf(91) != -1) continue;
            Object value = properties.remove((Object)key2);
            Object bean2 = PropertyBindingSupport.resolveBean((CamelContext)camelContext, (Object)value);
            if (bean2 == null) {
                throw new IllegalArgumentException("Cannot create/resolve bean with name " + key2 + " from value: " + String.valueOf(value));
            }
            if (logSummary) {
                LOG.info("Binding bean: {} (type: {}) to the registry", (Object)key2, (Object)ObjectHelper.classCanonicalName((Object)bean2));
            } else {
                LOG.debug("Binding bean: {} (type: {}) to the registry", (Object)key2, (Object)ObjectHelper.classCanonicalName((Object)bean2));
            }
            camelContext.getRegistry().bind(key2, bean2);
        }
        for (String name : beansMap) {
            Cloneable bean3;
            if (camelContext.getRegistry().lookupByName(name) != null) continue;
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + "[", "]", false);
            boolean list = config.keySet().stream().map(Object::toString).allMatch(StringHelper::isDigit);
            Cloneable cloneable = bean3 = list ? new ArrayList() : new LinkedHashMap();
            if (logSummary) {
                LOG.info("Binding bean: {} (type: {}) to the registry", (Object)name, (Object)ObjectHelper.classCanonicalName(bean3));
            } else {
                LOG.debug("Binding bean: {} (type: {}) to the registry", (Object)name, (Object)ObjectHelper.classCanonicalName(bean3));
            }
            camelContext.getRegistry().bind(name, bean3);
        }
        for (String name : beansDot) {
            bean = camelContext.getRegistry().lookupByName(name);
            if (bean == null) {
                throw new IllegalArgumentException("Cannot resolve bean with name " + name);
            }
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + ".");
            MainHelper.setPropertiesOnTarget(camelContext, bean, config, optionPrefix + name + ".", failIfNotSet, ignoreCase, autoConfiguredProperties);
        }
        for (String name : beansMap) {
            bean = camelContext.getRegistry().lookupByName(name);
            if (bean == null) {
                throw new IllegalArgumentException("Cannot resolve bean with name " + name);
            }
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + "[", "]", true, key -> {
                if (key.startsWith(name + "[")) {
                    return key.substring(name.length());
                }
                return key;
            });
            MainHelper.setPropertiesOnTarget(camelContext, bean, config, optionPrefix + name + ".", failIfNotSet, ignoreCase, autoConfiguredProperties);
        }
    }

    protected void autoConfigurationPropertiesComponent(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Properties propJVM;
        Properties propENV;
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll("ENV", propENV);
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
        }
        OrderedLocationProperties properties = new OrderedLocationProperties();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.component.properties.")) continue;
            int dot = key.indexOf(46, 26);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            MainHelper.validateOptionAndValue(key, option, value);
            String loc = prop.getLocation((Object)key);
            properties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring properties component from loaded properties: {}", (Object)properties.size());
            MainHelper.setPropertiesOnTarget(camelContext, camelContext.getPropertiesComponent(), properties, "camel.component.properties.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.component.properties.{}={} on object: {}", new Object[]{k, v, camelContext.getPropertiesComponent()}));
        }
    }

    protected void autoConfigurationMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            Properties propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."});
            propENV.remove("camel.main.initial-properties-location".replace('-', '.'));
            propENV.remove("camel.main.override-properties-location".replace('-', '.'));
            propENV.remove("camel.main.property-placeholder-location".replace('-', '.'));
            if (!propENV.isEmpty()) {
                prop.putAll("ENV", propENV);
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled()) {
            Properties propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.main."});
            propJVM.remove("camel.main.initial-properties-location");
            propJVM.remove(StringHelper.dashToCamelCase((String)"camel.main.initial-properties-location"));
            propJVM.remove("camel.main.override-properties-location");
            propJVM.remove(StringHelper.dashToCamelCase((String)"camel.main.override-properties-location"));
            propJVM.remove("camel.main.property-placeholder-location");
            propJVM.remove(StringHelper.dashToCamelCase((String)"camel.main.property-placeholder-location"));
            if (!propJVM.isEmpty()) {
                prop.putAll("SYS", propJVM);
            }
        }
        OrderedLocationProperties properties = new OrderedLocationProperties();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.main.")) continue;
            String value = prop.getProperty(key);
            String option = key.substring(11);
            MainHelper.validateOptionAndValue(key, option, value);
            String loc = prop.getLocation((Object)key);
            properties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring main from loaded properties: {}", (Object)properties.size());
            MainHelper.setPropertiesOnTarget(camelContext, config, properties, "camel.main.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.main.{}={} on bean: {}", new Object[]{k, v, config}));
        }
    }

    protected void autoConfigurationFromProperties(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Properties propJVM;
        OrderedLocationProperties prop = new OrderedLocationProperties();
        OrderedLocationProperties propPC = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        prop.putAll(propPC);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            Map<String, String> env = MainHelper.filterEnvVariables(new String[]{"camel.component.", "camel.dataformat.", "camel.language."});
            LOG.debug("Gathered {} ENV variables to configure components, dataformats, languages", (Object)env.size());
            OrderedProperties propENV = new OrderedProperties();
            this.helper.addComponentEnvVariables(env, (Properties)propENV, false);
            this.helper.addDataFormatEnvVariables(env, (Properties)propENV, false);
            this.helper.addLanguageEnvVariables(env, (Properties)propENV, false);
            if (!env.isEmpty()) {
                LOG.debug("Remaining {} ENV variables to configure custom components, dataformats, languages", (Object)env.size());
                this.helper.addComponentEnvVariables(env, (Properties)propENV, true);
                this.helper.addDataFormatEnvVariables(env, (Properties)propENV, true);
                this.helper.addLanguageEnvVariables(env, (Properties)propENV, true);
            }
            if (!propENV.isEmpty()) {
                prop.putAll("ENV", (Properties)propENV);
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.component.", "camel.dataformat.", "camel.language."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
        }
        LinkedHashMap<PropertyOptionKey, OrderedLocationProperties> properties = new LinkedHashMap<PropertyOptionKey, OrderedLocationProperties>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.contains("*")) continue;
            String loc = prop.getLocation((Object)key);
            this.wildcardProperties.put(loc, (Object)key, (Object)prop.getProperty(key));
        }
        for (String key : this.wildcardProperties.stringPropertyNames()) {
            prop.remove((Object)key);
        }
        this.doAutoConfigurationFromProperties(camelContext, prop, properties, false, autoConfiguredProperties);
    }

    protected void autoConfigurationFromReloadedProperties(CamelContext camelContext, OrderedLocationProperties reloadedProperties) throws Exception {
        LinkedHashMap<PropertyOptionKey, OrderedLocationProperties> properties = new LinkedHashMap<PropertyOptionKey, OrderedLocationProperties>();
        for (String key : reloadedProperties.stringPropertyNames()) {
            if (!key.contains("*")) continue;
            String loc = reloadedProperties.getLocation((Object)key);
            this.wildcardProperties.put(loc, (Object)key, (Object)reloadedProperties.getProperty(key));
        }
        for (String key : this.wildcardProperties.stringPropertyNames()) {
            reloadedProperties.remove((Object)key);
        }
        OrderedLocationProperties autoConfiguredProperties = new OrderedLocationProperties();
        this.doAutoConfigurationFromProperties(camelContext, reloadedProperties, properties, true, autoConfiguredProperties);
        if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
            BaseMainSupport.logConfigurationSummary(autoConfiguredProperties);
        }
    }

    protected void doAutoConfigurationFromProperties(CamelContext camelContext, OrderedLocationProperties prop, Map<PropertyOptionKey, OrderedLocationProperties> properties, boolean reload, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        for (String string : prop.stringPropertyNames()) {
            MainHelper.computeProperties("camel.component.", string, prop, properties, name -> {
                Component target;
                boolean optional = name.startsWith("?");
                if (optional) {
                    name = name.substring(1);
                }
                if (reload) {
                    camelContext.removeComponent(name);
                }
                Component component = target = optional ? camelContext.hasComponent(name) : camelContext.getComponent(name);
                if (target == null && !optional) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find component with name " + name + ". Make sure you have the component on the classpath");
                }
                if (target == null) {
                    return Collections.EMPTY_LIST;
                }
                return Collections.singleton(target);
            });
            MainHelper.computeProperties("camel.dataformat.", string, prop, properties, name -> {
                DataFormat target = camelContext.resolveDataFormat(name);
                if (target == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find dataformat with name " + name + ". Make sure you have the dataformat on the classpath");
                }
                return Collections.singleton(target);
            });
            MainHelper.computeProperties("camel.language.", string, prop, properties, name -> {
                Language target;
                try {
                    target = camelContext.resolveLanguage(name);
                }
                catch (NoSuchLanguageException e) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find language with name " + name + ". Make sure you have the language on the classpath");
                }
                return Collections.singleton(target);
            });
        }
        if (!properties.isEmpty()) {
            long total = properties.values().stream().mapToLong(Map::size).sum();
            LOG.debug("Auto-configuring {} components/dataformat/languages from loaded properties: {}", (Object)properties.size(), (Object)total);
        }
        for (Map.Entry entry : properties.entrySet()) {
            MainHelper.setPropertiesOnTarget(camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (OrderedLocationProperties)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                PropertyOptionKey pok = (PropertyOptionKey)entry.getKey();
                OrderedLocationProperties values = (OrderedLocationProperties)entry.getValue();
                values.forEach((k, v) -> {
                    String stringValue = v != null ? v.toString() : null;
                    LOG.warn("Property ({}={}) not auto-configured with name: {} on bean: {} with value: {}", new Object[]{pok.getOptionPrefix() + "." + String.valueOf(k), stringValue, k, pok.getInstance(), stringValue});
                });
            }
        }
    }

    protected void autowireWildcardProperties(CamelContext camelContext) {
        if (this.wildcardProperties.isEmpty()) {
            return;
        }
        for (String name : camelContext.getComponentNames()) {
            Component comp = camelContext.getComponent(name);
            this.doAutowireWildcardProperties(name, comp);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onComponentAdd(String name, Component component) {
                BaseMainSupport.this.doAutowireWildcardProperties(name, component);
            }
        });
        this.wildcardProperties.clear();
    }

    protected void doAutowireWildcardProperties(String name, Component component) {
        LinkedHashMap<PropertyOptionKey, OrderedLocationProperties> properties = new LinkedHashMap<PropertyOptionKey, OrderedLocationProperties>();
        OrderedLocationProperties autoConfiguredProperties = new OrderedLocationProperties();
        String match = ("camel.component." + name).toLowerCase(Locale.US);
        for (String string : this.wildcardProperties.stringPropertyNames()) {
            String mKey = string.substring(0, string.indexOf(42)).toLowerCase(Locale.US);
            if (!match.startsWith(mKey)) continue;
            MainHelper.computeProperties("camel.component.", string, this.wildcardProperties, properties, s -> Collections.singleton(component));
        }
        try {
            for (Map.Entry entry : properties.entrySet()) {
                MainHelper.setPropertiesOnTarget(this.camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (OrderedLocationProperties)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            }
            if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
                MainConfigurationDevConsole mc = null;
                DevConsoleRegistry devConsoleRegistry = (DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class);
                if (devConsoleRegistry != null) {
                    mc = (MainConfigurationDevConsole)devConsoleRegistry.resolveById("main-configuration");
                }
                boolean header = false;
                for (Map.Entry entry : autoConfiguredProperties.entrySet()) {
                    boolean debug;
                    String k = entry.getKey().toString();
                    Object v = entry.getValue();
                    String loc = LocationHelper.locationSummary((OrderedLocationProperties)autoConfiguredProperties, (String)k);
                    if (mc != null) {
                        mc.addStartupConfiguration(loc, k, v);
                    }
                    if ((debug = loc.contains("[camel-main]")) && !LOG.isDebugEnabled()) continue;
                    if (!header) {
                        LOG.info("Auto-configuration component {} summary", (Object)name);
                        header = true;
                    }
                    MainHelper.sensitiveAwareLogging(LOG, k, v, loc, debug);
                }
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    private static CamelSagaService resolveLraSagaService(CamelContext camelContext) throws Exception {
        CamelSagaService answer = (CamelSagaService)camelContext.hasService(CamelSagaService.class);
        if (answer == null) {
            answer = (CamelSagaService)camelContext.getRegistry().findSingleByType(CamelSagaService.class);
        }
        if (answer == null) {
            answer = (CamelSagaService)camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("lra-saga-service", CamelSagaService.class).orElseThrow(() -> new IllegalArgumentException("Cannot find LRASagaService on classpath. Add camel-lra to classpath."));
        }
        return answer;
    }

    private static CamelTracingService resolveOtelService(CamelContext camelContext) throws Exception {
        CamelTracingService answer = (CamelTracingService)camelContext.hasService(CamelTracingService.class);
        if (answer == null) {
            answer = (CamelTracingService)camelContext.getRegistry().findSingleByType(CamelTracingService.class);
        }
        if (answer == null) {
            answer = (CamelTracingService)camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("opentelemetry-tracer", CamelTracingService.class).orElseThrow(() -> new IllegalArgumentException("Cannot find OpenTelemetryTracer on classpath. Add camel-opentelemetry to classpath."));
        }
        return answer;
    }

    private static CamelMetricsService resolveMicrometerService(CamelContext camelContext) throws Exception {
        CamelMetricsService answer = (CamelMetricsService)camelContext.hasService(CamelMetricsService.class);
        if (answer == null) {
            answer = (CamelMetricsService)camelContext.getRegistry().findSingleByType(CamelMetricsService.class);
        }
        if (answer == null) {
            answer = (CamelMetricsService)camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("micrometer-prometheus", CamelMetricsService.class).orElseThrow(() -> new IllegalArgumentException("Cannot find CamelMetricsService on classpath. Add camel-micrometer-prometheus to classpath."));
        }
        return answer;
    }

    private static MainHttpServerFactory resolveMainHttpServerFactory(CamelContext camelContext) {
        MainHttpServerFactory answer = (MainHttpServerFactory)camelContext.getRegistry().findSingleByType(MainHttpServerFactory.class);
        if (answer == null) {
            answer = (MainHttpServerFactory)camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("platform-http-server", MainHttpServerFactory.class).orElseThrow(() -> new IllegalArgumentException("Cannot find MainHttpServerFactory on classpath. Add camel-platform-http-main to classpath."));
        }
        return (MainHttpServerFactory)CamelContextAware.trySetCamelContext((Object)answer, (CamelContext)camelContext);
    }

    private static /* synthetic */ boolean lambda$doInitFileConfigurations$12(String pattern, File f) {
        return StringHelper.matches((String)pattern, (String)f.getName());
    }

    private static final class PropertyPlaceholderListener
    implements PropertiesLookupListener {
        private final OrderedLocationProperties olp;

        public PropertyPlaceholderListener(OrderedLocationProperties olp) {
            this.olp = olp;
        }

        public void onLookup(String name, String value, String defaultValue, String source) {
            if (source == null) {
                source = "unknown";
            }
            this.olp.put(source, (Object)name, (Object)value, (Object)defaultValue);
        }
    }

    private static class PlaceholderSummaryEventNotifier
    extends SimpleEventNotifierSupport
    implements NonManagedService {
        private final OrderedLocationProperties propertyPlaceholders;

        public PlaceholderSummaryEventNotifier(OrderedLocationProperties propertyPlaceholders) {
            this.propertyPlaceholders = propertyPlaceholders;
        }

        public boolean isEnabled(CamelEvent event) {
            return event instanceof CamelEvent.CamelContextRoutesStartedEvent;
        }

        public void notify(CamelEvent event) throws Exception {
            if (!this.propertyPlaceholders.isEmpty()) {
                boolean header = true;
                for (Map.Entry entry : this.propertyPlaceholders.entrySet()) {
                    String k = entry.getKey().toString();
                    Object v = entry.getValue();
                    Object dv = this.propertyPlaceholders.getDefaultValue((Object)k);
                    boolean same = ObjectHelper.equal(v, (Object)dv);
                    boolean skip = "templateId".equals(k);
                    if (same || skip) continue;
                    if (header) {
                        LOG.info("Property-placeholders summary");
                        header = false;
                    }
                    String loc = LocationHelper.locationSummary((OrderedLocationProperties)this.propertyPlaceholders, (String)k);
                    if (SensitiveUtils.containsSensitive((String)k)) {
                        LOG.info("    {} {} = xxxxxx", (Object)loc, (Object)k);
                        continue;
                    }
                    LOG.info("    {} {} = {}", new Object[]{loc, k, v});
                }
            }
        }
    }
}

