/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedEndpointRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed EndpointRegistry")
public class ManagedEndpointRegistry
extends ManagedService
implements ManagedEndpointRegistryMBean {
    private final EndpointRegistry<?> endpointRegistry;
    private boolean sanitize;

    public ManagedEndpointRegistry(CamelContext context, EndpointRegistry<?> endpointRegistry) {
        super(context, (Service)endpointRegistry);
        this.endpointRegistry = endpointRegistry;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : false;
    }

    public EndpointRegistry<?> getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public String getSource() {
        return this.endpointRegistry.toString();
    }

    public Integer getDynamicSize() {
        return this.endpointRegistry.dynamicSize();
    }

    public Integer getStaticSize() {
        return this.endpointRegistry.staticSize();
    }

    public Integer getSize() {
        return this.endpointRegistry.size();
    }

    public Integer getMaximumCacheSize() {
        return this.endpointRegistry.getMaximumCacheSize();
    }

    public void purge() {
        this.endpointRegistry.purge();
    }

    public TabularData listEndpoints() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listEndpointsTabularType());
            Collection endpoints = this.endpointRegistry.values();
            for (Endpoint endpoint : endpoints) {
                CompositeType ct = CamelOpenMBeanTypes.listEndpointsCompositeType();
                String url = endpoint.getEndpointUri();
                if (this.sanitize) {
                    url = URISupport.sanitizeUri((String)url);
                }
                boolean fromStatic = this.endpointRegistry.isStatic(url);
                boolean fromDynamic = this.endpointRegistry.isDynamic(url);
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "static", "dynamic"}, new Object[]{url, fromStatic, fromDynamic});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

