/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.messagehistory;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistory;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryNamingStrategy;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryService;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceSupport;

public class MicrometerMessageHistoryFactory
extends ServiceSupport
implements CamelContextAware,
StaticService,
NonManagedService,
MessageHistoryFactory {
    private CamelContext camelContext;
    private MeterRegistry meterRegistry;
    private boolean copyMessage;
    private String nodePattern;
    private boolean prettyPrint = true;
    private boolean skipCamelInfo = false;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private MicrometerMessageHistoryNamingStrategy namingStrategy = MicrometerMessageHistoryNamingStrategy.DEFAULT;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isSkipCamelInfo() {
        return this.skipCamelInfo;
    }

    public void setSkipCamelInfo(boolean skipCamelInfo) {
        this.skipCamelInfo = skipCamelInfo;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    public MicrometerMessageHistoryNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerMessageHistoryNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public boolean isCopyMessage() {
        return this.copyMessage;
    }

    public void setCopyMessage(boolean copyMessage) {
        this.copyMessage = copyMessage;
    }

    public String getNodePattern() {
        return this.nodePattern;
    }

    public void setNodePattern(String nodePattern) {
        this.nodePattern = nodePattern;
    }

    public MessageHistory newMessageHistory(String routeId, NamedNode namedNode, Exchange exchange) {
        Route route;
        if (this.nodePattern != null) {
            String[] parts;
            String name = namedNode.getShortName();
            for (String part : parts = this.nodePattern.split(",")) {
                boolean match = PatternHelper.matchPattern((String)name, (String)part);
                if (match) continue;
                return null;
            }
        }
        Message msg = null;
        if (this.copyMessage) {
            msg = exchange.getMessage().copy();
        }
        if ((route = this.camelContext.getRoute(routeId)) != null) {
            return new MicrometerMessageHistory(this.getMeterRegistry(), route, namedNode, this.getNamingStrategy(), msg);
        }
        return null;
    }

    protected void doStart() throws Exception {
        if (this.meterRegistry == null) {
            this.meterRegistry = MicrometerUtils.getOrCreateMeterRegistry(this.camelContext.getRegistry(), "metricsRegistry");
        }
        try {
            MicrometerMessageHistoryService messageHistoryService = (MicrometerMessageHistoryService)this.camelContext.hasService(MicrometerMessageHistoryService.class);
            if (messageHistoryService == null) {
                messageHistoryService = new MicrometerMessageHistoryService();
                messageHistoryService.setPrettyPrint(this.isPrettyPrint());
                messageHistoryService.setMeterRegistry(this.getMeterRegistry());
                messageHistoryService.setPrettyPrint(this.isPrettyPrint());
                messageHistoryService.setDurationUnit(this.getDurationUnit());
                messageHistoryService.setMatchingTags((Iterable<Tag>)Tags.of((String)"kind", (String)"CamelMessageHistory"));
                this.camelContext.addService((Object)messageHistoryService);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected void doStop() {
    }
}

