/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.handlers;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.netty4.NettyCamelState;
import org.apache.camel.component.netty4.NettyHelper;
import org.apache.camel.component.netty4.NettyPayloadHelper;
import org.apache.camel.component.netty4.NettyProducer;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannelHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyProducer.class);
    private final NettyProducer producer;
    private volatile boolean messageReceived;
    private volatile boolean exceptionHandled;

    public ClientChannelHandler(NettyProducer producer) {
        this.producer = producer;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Channel open: {}", (Object)ctx.channel());
        }
        this.producer.getAllChannels().add((Object)ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exception caught at Channel: " + ctx.channel(), cause);
        }
        if (this.exceptionHandled) {
            return;
        }
        this.exceptionHandled = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing channel as an exception was thrown from Netty", cause);
        }
        Exchange exchange = this.getExchange(ctx);
        AsyncCallback callback = this.getAsyncCallback(ctx);
        if (exchange != null && callback != null) {
            exchange.setException(cause);
            NettyHelper.close(ctx.channel());
            callback.done(false);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Channel closed: {}", (Object)ctx.channel());
        }
        Exchange exchange = this.getExchange(ctx);
        AsyncCallback callback = this.getAsyncCallback(ctx);
        this.producer.removeState(ctx.channel());
        this.producer.getAllChannels().remove((Object)ctx.channel());
        if (this.producer.getConfiguration().isSync() && !this.messageReceived && !this.exceptionHandled) {
            this.exceptionHandled = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Channel closed but no message received from address: {}", (Object)this.producer.getConfiguration().getAddress());
            }
            exchange.setException((Throwable)new CamelExchangeException("No response received from remote server: " + this.producer.getConfiguration().getAddress(), exchange));
            callback.done(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Message message;
        Exchange exchange;
        ChannelHandler handler;
        this.messageReceived = true;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Message received: {}", msg);
        }
        if ((handler = ctx.pipeline().get("timeout")) != null) {
            LOG.trace("Removing timeout channel as we received message");
            ctx.pipeline().remove(handler);
        }
        if ((exchange = this.getExchange(ctx)) == null) {
            return;
        }
        AsyncCallback callback = this.getAsyncCallback(ctx);
        try {
            message = this.getResponseMessage(exchange, ctx, msg);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(false);
            return;
        }
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            exchange.setOut(message);
        } else {
            exchange.setIn(message);
        }
        try {
            Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
            if (close == null) {
                close = (Boolean)exchange.getProperty("CamelNettyCloseChannelWhenComplete", Boolean.class);
            }
            boolean disconnect = this.producer.getConfiguration().isDisconnect();
            if (close != null) {
                disconnect = close;
            }
            if (disconnect) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Closing channel when complete at address: {}", (Object)this.producer.getConfiguration().getAddress());
                }
                NettyHelper.close(ctx.channel());
            }
        }
        finally {
            callback.done(false);
        }
    }

    protected Message getResponseMessage(Exchange exchange, ChannelHandlerContext ctx, Object message) throws Exception {
        Object body = message;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel: {} received body: {}", new Object[]{ctx.channel(), body});
        }
        if (this.producer.getConfiguration().isTextline()) {
            body = this.producer.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, message);
        }
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            NettyPayloadHelper.setOut(exchange, body);
            return exchange.getOut();
        }
        NettyPayloadHelper.setIn(exchange, body);
        return exchange.getIn();
    }

    private Exchange getExchange(ChannelHandlerContext ctx) {
        NettyCamelState state = this.producer.getState(ctx.channel());
        return state != null ? state.getExchange() : null;
    }

    private AsyncCallback getAsyncCallback(ChannelHandlerContext ctx) {
        NettyCamelState state = this.producer.getState(ctx.channel());
        return state != null ? state.getCallback() : null;
    }
}

