/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class PackageComponentMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File componentOutDir;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageComponentMojo.prepareComponent(this.getLog(), this.project, this.projectHelper, this.componentOutDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void prepareComponent(Log log, MavenProject project, MavenProjectHelper projectHelper, File componentOutDir) throws MojoExecutionException {
        File camelMetaDir = new File(componentOutDir, "META-INF/services/org/apache/camel/");
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        for (Resource r : project.getBuild().getResources()) {
            File[] files;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(project.getBasedir(), r.getDirectory());
            }
            if (!(f = new File(f, "META-INF/services/org/apache/camel/component")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                ++count;
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(name);
            }
        }
        if (count > 0) {
            Properties properties = new Properties();
            String names = buffer.toString();
            properties.put("components", names);
            properties.put("groupId", project.getGroupId());
            properties.put("artifactId", project.getArtifactId());
            properties.put("version", project.getVersion());
            properties.put("projectName", project.getName());
            if (project.getDescription() != null) {
                properties.put("projectDescription", project.getDescription());
            }
            camelMetaDir.mkdirs();
            File outFile = new File(camelMetaDir, "component.properties");
            try {
                properties.store(new FileWriter(outFile), "Generated by camel-package-maven-plugin");
                log.info((CharSequence)("Generated " + outFile + " containing " + count + " Camel " + (count > 1 ? "components: " : "component: ") + names));
                if (projectHelper == null) return;
                ArrayList<String> includes = new ArrayList<String>();
                includes.add("**/component.properties");
                projectHelper.addResource(project, componentOutDir.getPath(), includes, new ArrayList());
                projectHelper.attachArtifact(project, "properties", "camelComponent", outFile);
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write properties to " + outFile + ". Reason: " + e, (Exception)e);
            }
        } else {
            log.debug((CharSequence)"No META-INF/services/org/apache/camel/component directory found. Are you sure you have created a Camel component?");
        }
    }
}

