/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

public class PackageLanguageMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File languageOutDir;
    protected File schemaOutDir;
    private MavenProjectHelper projectHelper;
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageLanguageMojo.prepareLanguage(this.getLog(), this.project, this.projectHelper, this.languageOutDir, this.schemaOutDir, this.buildContext);
    }

    public static void prepareLanguage(Log log, MavenProject project, MavenProjectHelper projectHelper, File languageOutDir, File schemaOutDir, BuildContext buildContext) throws MojoExecutionException {
        String javaType;
        File camelMetaDir = new File(languageOutDir, "META-INF/services/org/apache/camel/");
        if (projectHelper != null) {
            projectHelper.addResource(project, languageOutDir.getPath(), Collections.singletonList("**/language.properties"), Collections.emptyList());
        }
        if (!PackageHelper.haveResourcesChanged(log, project, buildContext, "META-INF/services/org/apache/camel/language")) {
            return;
        }
        HashMap<String, String> javaTypes = new HashMap<String, String>();
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        for (Resource r : project.getBuild().getResources()) {
            File[] files;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(project.getBasedir(), r.getDirectory());
            }
            if (!(f = new File(f, "META-INF/services/org/apache/camel/language")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
            for (File file : files) {
                javaType = PackageLanguageMojo.readClassFromCamelResource(file, buffer, buildContext);
                if (!file.isDirectory() && file.getName().charAt(0) != '.') {
                    ++count;
                }
                if (javaType == null) continue;
                javaTypes.put(file.getName(), javaType);
            }
        }
        boolean apacheCamel = "org.apache.camel".equals(project.getGroupId());
        try {
            File core;
            Artifact camelCore;
            if (apacheCamel && count > 0 && (camelCore = PackageLanguageMojo.findCamelCoreArtifact(project)) != null && (core = camelCore.getFile()) != null) {
                URL url = new URL("file", null, core.getAbsolutePath());
                URLClassLoader loader = new URLClassLoader(new URL[]{url});
                for (Map.Entry entry : javaTypes.entrySet()) {
                    String name = (String)entry.getKey();
                    javaType = (String)entry.getValue();
                    String modelName = PackageLanguageMojo.asModelName(name);
                    InputStream is = loader.getResourceAsStream("org/apache/camel/model/language/" + modelName + ".json");
                    if (is == null) {
                        is = new FileInputStream(new File(core, "org/apache/camel/model/language/" + modelName + ".json"));
                    }
                    String json = PackageHelper.loadText(is);
                    LanguageModel languageModel = new LanguageModel();
                    languageModel.setName(name);
                    languageModel.setTitle("");
                    languageModel.setModelName(modelName);
                    languageModel.setLabel("");
                    languageModel.setDescription("");
                    languageModel.setJavaType(javaType);
                    languageModel.setGroupId(project.getGroupId());
                    languageModel.setArtifactId(project.getArtifactId());
                    languageModel.setVersion(project.getVersion());
                    List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
                    for (Map<String, String> row : rows) {
                        if (row.containsKey("title")) {
                            String title = PackageLanguageMojo.asTitle(name, row.get("title"));
                            languageModel.setTitle(title);
                        }
                        if (row.containsKey("description")) {
                            String desc = PackageLanguageMojo.asDescription(name, row.get("description"));
                            languageModel.setDescription(desc);
                        }
                        if (row.containsKey("label")) {
                            languageModel.setLabel(row.get("label"));
                        }
                        if (row.containsKey("deprecated")) {
                            languageModel.setDeprecated(row.get("deprecated"));
                        }
                        if (row.containsKey("deprecationNote")) {
                            languageModel.setDeprecationNote(row.get("deprecationNote"));
                        }
                        if (row.containsKey("javaType")) {
                            languageModel.setModelJavaType(row.get("javaType"));
                        }
                        if (!row.containsKey("firstVersion")) continue;
                        languageModel.setFirstVersion(row.get("firstVersion"));
                    }
                    log.debug((CharSequence)("Model " + languageModel));
                    String properties = PackageHelper.after(json, "  \"properties\": {");
                    String schema = PackageLanguageMojo.createParameterJsonSchema(languageModel, properties);
                    log.debug((CharSequence)("JSon schema\n" + schema));
                    File dir = new File(schemaOutDir, PackageLanguageMojo.schemaSubDirectory(languageModel.getJavaType()));
                    dir.mkdirs();
                    File out = new File(dir, name + ".json");
                    OutputStream fos = buildContext.newFileOutputStream(out);
                    fos.write(schema.getBytes());
                    fos.close();
                    buildContext.refresh(out);
                    log.debug((CharSequence)("Generated " + out + " containing JSon schema for " + name + " language"));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error loading language model from camel-core. Reason: " + e, e);
        }
        if (count > 0) {
            Properties properties = new Properties();
            String names = buffer.toString();
            properties.put("languages", names);
            properties.put("groupId", project.getGroupId());
            properties.put("artifactId", project.getArtifactId());
            properties.put("version", project.getVersion());
            properties.put("projectName", project.getName());
            if (project.getDescription() != null) {
                properties.put("projectDescription", project.getDescription());
            }
            camelMetaDir.mkdirs();
            File outFile = new File(camelMetaDir, "language.properties");
            if (outFile.exists()) {
                try {
                    Properties existing = new Properties();
                    FileInputStream is = new FileInputStream(outFile);
                    existing.load(is);
                    ((InputStream)is).close();
                    if (existing.equals(properties)) {
                        log.debug((CharSequence)"No language changes detected");
                        return;
                    }
                }
                catch (IOException existing) {
                    // empty catch block
                }
            }
            try {
                OutputStream os = buildContext.newFileOutputStream(outFile);
                properties.store(os, "Generated by camel-package-maven-plugin");
                os.close();
                log.info((CharSequence)("Generated " + outFile + " containing " + count + " Camel " + (count > 1 ? "languages: " : "language: ") + names));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write properties to " + outFile + ". Reason: " + e, (Exception)e);
            }
        }
        log.debug((CharSequence)"No META-INF/services/org/apache/camel/language directory found. Are you sure you have created a Camel language?");
    }

    private static String readClassFromCamelResource(File file, StringBuilder buffer, BuildContext buildContext) throws MojoExecutionException {
        if (file.isDirectory()) {
            return null;
        }
        String name = file.getName();
        if (name.charAt(0) != '.') {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(name);
        }
        if (!buildContext.hasDelta(file)) {
            return null;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            Map<String, String> map = PackageHelper.parseAsMap(text);
            return map.get("class");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read file " + file + ". Reason: " + e, (Exception)e);
        }
    }

    private static String asModelName(String name) {
        if ("bean".equals(name)) {
            return "method";
        }
        if ("file".equals(name)) {
            return "simple";
        }
        return name;
    }

    private static String asTitle(String name, String title) {
        if ("file".equals(name)) {
            return "File";
        }
        return title;
    }

    private static String asDescription(String name, String description) {
        if ("file".equals(name)) {
            return "For expressions and predicates using the file/simple language";
        }
        return description;
    }

    private static Artifact findCamelCoreArtifact(MavenProject project) {
        Artifact artifact2 = project.getArtifact();
        if (artifact2.getGroupId().equals("org.apache.camel") && artifact2.getArtifactId().equals("camel-core")) {
            return artifact2;
        }
        for (Artifact artifact2 : project.getDependencyArtifacts()) {
            if (!artifact2.getGroupId().equals("org.apache.camel") || !artifact2.getArtifactId().equals("camel-core")) continue;
            return artifact2;
        }
        return null;
    }

    private static String schemaSubDirectory(String javaType) {
        int idx = javaType.lastIndexOf(46);
        String pckName = javaType.substring(0, idx);
        return pckName.replace('.', '/');
    }

    private static String createParameterJsonSchema(LanguageModel languageModel, String schema) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"language\": {");
        buffer.append("\n    \"name\": \"").append(languageModel.getName()).append("\",");
        buffer.append("\n    \"kind\": \"").append("language").append("\",");
        buffer.append("\n    \"modelName\": \"").append(languageModel.getModelName()).append("\",");
        if (languageModel.getTitle() != null) {
            buffer.append("\n    \"title\": \"").append(languageModel.getTitle()).append("\",");
        }
        if (languageModel.getDescription() != null) {
            buffer.append("\n    \"description\": \"").append(languageModel.getDescription()).append("\",");
        }
        boolean deprecated = "true".equals(languageModel.getDeprecated());
        buffer.append("\n    \"deprecated\": ").append(deprecated).append(",");
        if (languageModel.getFirstVersion() != null) {
            buffer.append("\n    \"firstVersion\": \"").append(languageModel.getFirstVersion()).append("\",");
        }
        buffer.append("\n    \"label\": \"").append(languageModel.getLabel()).append("\",");
        buffer.append("\n    \"javaType\": \"").append(languageModel.getJavaType()).append("\",");
        if (languageModel.getModelJavaType() != null) {
            buffer.append("\n    \"modelJavaType\": \"").append(languageModel.getModelJavaType()).append("\",");
        }
        buffer.append("\n    \"groupId\": \"").append(languageModel.getGroupId()).append("\",");
        buffer.append("\n    \"artifactId\": \"").append(languageModel.getArtifactId()).append("\",");
        buffer.append("\n    \"version\": \"").append(languageModel.getVersion()).append("\"");
        buffer.append("\n  },");
        buffer.append("\n  \"properties\": {");
        buffer.append(schema);
        return buffer.toString();
    }

    private static class LanguageModel {
        private String name;
        private String title;
        private String modelName;
        private String description;
        private String firstVersion;
        private String label;
        private String deprecated;
        private String deprecationNote;
        private String javaType;
        private String modelJavaType;
        private String groupId;
        private String artifactId;
        private String version;

        private LanguageModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public String getModelJavaType() {
            return this.modelJavaType;
        }

        public void setModelJavaType(String modelJavaType) {
            this.modelJavaType = modelJavaType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getFirstVersion() {
            return this.firstVersion;
        }

        public void setFirstVersion(String firstVersion) {
            this.firstVersion = firstVersion;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(String deprecated) {
            this.deprecated = deprecated;
        }

        public String getDeprecationNote() {
            return this.deprecationNote;
        }

        public void setDeprecationNote(String deprecationNote) {
            this.deprecationNote = deprecationNote;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "LanguageModel[name='" + this.name + '\'' + ", modelName='" + this.modelName + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", label='" + this.label + '\'' + ", javaType='" + this.javaType + '\'' + ", modelJavaType='" + this.modelJavaType + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ']';
        }
    }
}

