/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.maven.packaging.SpringBootHelper;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpringBootStarterMojo
extends AbstractMojo {
    private static final String[] IGNORE_MODULES = new String[]{"camel-blueprint", "camel-core-osgi", "camel-eventadmin", "camel-paxlogging", "camel-scr", "camel-cdi", "camel-ejb", "camel-swagger", "camel-mina", "camel-ibatis", "camel-quartz", "camel-jclouds", "camel-spark-rest", "camel-core-xml", "camel-groovy-dsl", "camel-scala"};
    private static final boolean IGNORE_TEST_MODULES = true;
    private static final String GENERATED_SECTION_START = "START OF GENERATED CODE";
    private static final String GENERATED_SECTION_START_COMMENT = "<!--START OF GENERATED CODE-->";
    private static final String GENERATED_SECTION_END = "END OF GENERATED CODE";
    private static final String GENERATED_SECTION_END_COMMENT = "<!--END OF GENERATED CODE-->";
    protected MavenProject project;
    protected boolean reuseExistingPom;
    protected File baseDir;
    protected ArtifactFactory artifactFactory;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactCollector artifactCollector;
    protected DependencyTreeBuilder treeBuilder;
    protected ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isStarterAllowed()) {
            this.getLog().info((CharSequence)("Spring-Boot-Starter: starter not allowed for module " + this.project.getArtifactId() + ": skipping."));
            return;
        }
        try {
            File starterDir = this.starterDir();
            this.getLog().info((CharSequence)("Spring-Boot-Starter: starter dir for the component is: " + starterDir.getAbsolutePath()));
            if (!starterDir.exists()) {
                starterDir.mkdirs();
            }
            Document pom = this.createBasePom();
            this.fixExcludedDependencies(pom);
            this.fixAdditionalDependencies(pom);
            this.fixAdditionalRepositories(pom);
            File pomFile = new File(starterDir, "pom.xml");
            this.writeXmlFormatted(pom, pomFile);
            this.writeStaticFiles();
            this.writeSpringProvides();
            this.synchronizeParentPom();
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to create starter", (Throwable)e);
        }
    }

    private File starterDir() throws IOException {
        return SpringBootHelper.starterDir(this.baseDir, this.project.getArtifactId());
    }

    private File allStartersDir() throws IOException {
        return SpringBootHelper.allStartersDir(this.baseDir);
    }

    private void fixAdditionalDependencies(Document pom) throws Exception {
        Properties properties = new Properties();
        properties.load(((Object)((Object)this)).getClass().getResourceAsStream("/spring-boot-fix-dependencies.properties"));
        TreeSet<String> deps = new TreeSet<String>();
        deps.addAll(this.csvToSet(properties.getProperty(this.project.getArtifactId())));
        Set<String> globalProps = this.csvToSet(properties.getProperty("global"));
        boolean inGlobal = false;
        for (String gp : globalProps) {
            String[] comps = gp.split("\\:");
            String stdName = (comps[0] + ":" + comps[1]).replace("-starter", "");
            if (!stdName.equals(this.project.getGroupId() + ":" + this.project.getArtifactId())) continue;
            inGlobal = true;
            break;
        }
        if (!inGlobal) {
            deps.addAll(globalProps);
        }
        if (deps.size() > 0) {
            this.getLog().debug((CharSequence)("The following dependencies will be added to the starter: " + deps));
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node dependencies = ((NodeList)xpath.compile("/project/dependencies").evaluate(pom, XPathConstants.NODESET)).item(0);
            if (deps.size() > 0) {
                dependencies.appendChild(pom.createComment(GENERATED_SECTION_START));
                for (String dep : deps) {
                    Element dependency = pom.createElement("dependency");
                    dependencies.appendChild(dependency);
                    String[] comps = dep.split("\\:");
                    String groupIdStr = comps[0];
                    String artifactIdStr = comps[1];
                    String versionStr = comps.length > 2 ? comps[2] : null;
                    Element groupId = pom.createElement("groupId");
                    groupId.setTextContent(groupIdStr);
                    dependency.appendChild(groupId);
                    Element artifactId = pom.createElement("artifactId");
                    artifactId.setTextContent(artifactIdStr);
                    dependency.appendChild(artifactId);
                    if (versionStr == null) continue;
                    Element version = pom.createElement("version");
                    version.setTextContent(versionStr);
                    dependency.appendChild(version);
                }
                dependencies.appendChild(pom.createComment(GENERATED_SECTION_END));
            }
        }
    }

    private void fixAdditionalRepositories(Document pom) throws Exception {
        if (this.project.getFile() != null) {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document originalPom = builder.parse(this.project.getFile());
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node repositories = (Node)xpath.compile("/project/repositories").evaluate(originalPom, XPathConstants.NODE);
            if (repositories != null) {
                pom.getDocumentElement().appendChild(pom.createComment(GENERATED_SECTION_START));
                pom.getDocumentElement().appendChild(pom.importNode(repositories, true));
                pom.getDocumentElement().appendChild(pom.createComment(GENERATED_SECTION_END));
            }
        } else {
            this.getLog().warn((CharSequence)"Cannot access the project pom file to retrieve repositories");
        }
    }

    private void appendTextElementIfPresent(Document pom, Element parent, String name, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        Element element = pom.createElement(name);
        element.setTextContent(value);
        parent.appendChild(element);
    }

    private Set<String> csvToSet(String csv) {
        if (csv == null || csv.trim().length() == 0) {
            return new TreeSet<String>();
        }
        TreeSet<String> set = new TreeSet<String>();
        for (String s : csv.split(",")) {
            set.add(s.trim());
        }
        return set;
    }

    private void fixExcludedDependencies(Document pom) throws Exception {
        HashSet<String> loggingImpl = new HashSet<String>();
        loggingImpl.add("commons-logging:commons-logging");
        loggingImpl.add("log4j:log4j");
        loggingImpl.add("log4j:apache-log4j-extras");
        loggingImpl.add("ch.qos.logback:logback-core");
        loggingImpl.add("ch.qos.logback:logback-classic");
        loggingImpl.add("org.apache.logging.log4j:log4j");
        loggingImpl.add("org.apache.logging.log4j:log4j-core");
        loggingImpl.add("org.apache.logging.log4j:log4j-slf4j-impl");
        loggingImpl.add("org.slf4j:slf4j-jcl");
        loggingImpl.add("org.slf4j:slf4j-jdk14");
        loggingImpl.add("org.slf4j:slf4j-log4j12");
        loggingImpl.add("org.slf4j:slf4j-log4j13");
        loggingImpl.add("org.slf4j:slf4j-nop");
        loggingImpl.add("org.slf4j:slf4j-simple");
        HashSet<String> configExclusions = new HashSet<String>();
        Properties properties = new Properties();
        properties.load(((Object)((Object)this)).getClass().getResourceAsStream("/spring-boot-fix-dependencies.properties"));
        String artExcl = properties.getProperty("exclude_" + this.project.getArtifactId());
        this.getLog().debug((CharSequence)("Configured exclusions: " + artExcl));
        if (artExcl != null && artExcl.trim().length() > 0) {
            for (String dep : artExcl.split(",")) {
                this.getLog().debug((CharSequence)("Adding configured exclusion: " + dep));
                configExclusions.add(dep);
            }
        }
        Set<String> libsToRemove = new TreeSet<String>();
        libsToRemove.addAll(loggingImpl);
        libsToRemove.addAll(configExclusions);
        libsToRemove = this.filterIncludedArtifacts(libsToRemove);
        if (libsToRemove.size() > 0) {
            this.getLog().info((CharSequence)("Spring-Boot-Starter: the following dependencies will be removed from the starter: " + libsToRemove));
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node dependency = ((NodeList)xpath.compile("/project/dependencies/dependency[artifactId/text() = '" + this.project.getArtifactId() + "']").evaluate(pom, XPathConstants.NODESET)).item(0);
            Element exclusions = pom.createElement("exclusions");
            dependency.appendChild(pom.createComment(GENERATED_SECTION_START));
            dependency.appendChild(exclusions);
            dependency.appendChild(pom.createComment(GENERATED_SECTION_END));
            for (String lib : libsToRemove) {
                String groupIdStr = lib.split("\\:")[0];
                String artifactIdStr = lib.split("\\:")[1];
                Element exclusion = pom.createElement("exclusion");
                Element groupId = pom.createElement("groupId");
                groupId.setTextContent(groupIdStr);
                exclusion.appendChild(groupId);
                Element artifactId = pom.createElement("artifactId");
                artifactId.setTextContent(artifactIdStr);
                exclusion.appendChild(artifactId);
                exclusions.appendChild(exclusion);
            }
        }
    }

    private Set<String> filterIncludedArtifacts(Set<String> artifacts) throws DependencyTreeBuilderException {
        TreeSet<String> included = new TreeSet<String>();
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter(null);
        DependencyNode node = this.treeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.artifactCollector);
        CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
        node.accept((DependencyNodeVisitor)visitor);
        List nodes = visitor.getNodes();
        for (DependencyNode dependencyNode : nodes) {
            String canonicalName;
            Artifact artifact = dependencyNode.getArtifact();
            this.getLog().debug((CharSequence)("Found dependency node: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + " - scope=" + artifact.getScope()));
            if ("test".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) || !artifacts.contains(canonicalName = artifact.getGroupId() + ":" + artifact.getArtifactId())) continue;
            this.getLog().debug((CharSequence)(canonicalName + " marked for exclusion"));
            included.add(canonicalName);
        }
        return included;
    }

    private void synchronizeParentPom() throws Exception {
        File pomFile = new File(this.allStartersDir(), "pom.xml");
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document pom = builder.parse(pomFile);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node modules = ((NodeList)xpath.compile("/project/modules").evaluate(pom, XPathConstants.NODESET)).item(0);
        while (modules.hasChildNodes()) {
            modules.removeChild(modules.getFirstChild());
        }
        for (File starterDir : Arrays.asList(this.allStartersDir().listFiles((f, n) -> new File(f, n).isDirectory() && n.endsWith("-starter") && new File(new File(f, n), "pom.xml").exists())).stream().sorted().collect(Collectors.toList())) {
            Element module = pom.createElement("module");
            module.setTextContent(starterDir.getName());
            modules.appendChild(module);
        }
        this.writeXmlFormatted(pom, pomFile);
    }

    private Document createBasePom() throws Exception {
        Document pom = null;
        if (this.reuseExistingPom) {
            pom = this.createBasePomFromExisting();
        }
        if (pom == null) {
            pom = this.createBasePomFromScratch();
        }
        return pom;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document createBasePomFromExisting() {
        try {
            File pomFile = new File(this.starterDir(), "pom.xml");
            if (!pomFile.exists()) return null;
            try (FileInputStream in = new FileInputStream(pomFile);){
                Document pom;
                String content = IOUtils.toString((InputStream)in, (String)"UTF-8");
                boolean editablePom = content.contains(GENERATED_SECTION_START_COMMENT);
                if (!editablePom) return null;
                content = this.removeGeneratedSections(content, 10);
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                try (ByteArrayInputStream contentIn = new ByteArrayInputStream(content.getBytes("UTF-8"));){
                    pom = builder.parse(contentIn);
                }
                this.getLog().info((CharSequence)"Reusing the existing pom.xml for the starter");
                Document document = pom;
                return document;
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Cannot use the existing pom.xml file", (Throwable)e);
        }
        return null;
    }

    private String removeGeneratedSections(String pom, int maxNumber) {
        if (maxNumber > 0 && pom.contains(GENERATED_SECTION_START_COMMENT)) {
            int start = pom.indexOf(GENERATED_SECTION_START_COMMENT);
            int end = pom.indexOf(GENERATED_SECTION_END_COMMENT);
            if (end <= start) {
                throw new IllegalArgumentException("Generated sections inside the xml document are not well-formed");
            }
            String newPom = pom.substring(0, start) + pom.substring(end + GENERATED_SECTION_END_COMMENT.length());
            return this.removeGeneratedSections(newPom, maxNumber - 1);
        }
        return pom;
    }

    private Document createBasePomFromScratch() throws Exception {
        this.getLog().info((CharSequence)"Creating a new pom.xml for the starter from scratch");
        Template pomTemplate = this.getTemplate("spring-boot-starter-template-pom.template");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("version", this.project.getVersion());
        props.put("componentId", this.getComponentId());
        props.put("componentName", this.project.getName());
        props.put("componentDescription", this.project.getDescription());
        StringWriter sw = new StringWriter();
        pomTemplate.process(props, (Writer)sw);
        String xml = sw.toString();
        ByteArrayInputStream bin = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document pom = builder.parse(bin);
        return pom;
    }

    private void writeStaticFiles() throws IOException, TemplateException {
        String license;
        String notice;
        try (InputStream isNotice = ((Object)((Object)this)).getClass().getResourceAsStream("/spring-boot-starter-NOTICE.txt");
             InputStream isLicense = ((Object)((Object)this)).getClass().getResourceAsStream("/spring-boot-starter-LICENSE.txt");){
            notice = IOUtils.toString((InputStream)isNotice);
            license = IOUtils.toString((InputStream)isLicense);
        }
        this.writeIfChanged(notice, new File(this.starterDir(), "src/main/resources/META-INF/NOTICE.txt"));
        this.writeIfChanged(license, new File(this.starterDir(), "src/main/resources/META-INF/LICENSE.txt"));
    }

    private void writeSpringProvides() throws IOException, TemplateException {
        Template fileTemplate = this.getTemplate("spring-boot-starter-template-spring.provides");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("artifactId", this.project.getArtifactId());
        File outDir = new File(this.starterDir(), "src/main/resources/META-INF");
        outDir.mkdirs();
        File outFile = new File(outDir, "spring.provides");
        StringWriter sw = new StringWriter();
        fileTemplate.process(props, (Writer)sw);
        sw.close();
        this.writeIfChanged(sw.toString(), outFile);
    }

    private Template getTemplate(String name) throws IOException {
        Configuration cfg = new Configuration(Configuration.getVersion());
        cfg.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                return SpringBootStarterMojo.class.getResource("/" + name);
            }
        });
        cfg.setDefaultEncoding("UTF-8");
        Template template = cfg.getTemplate(name);
        return template;
    }

    private boolean isStarterAllowed() {
        for (String ignored : IGNORE_MODULES) {
            if (!ignored.equals(this.project.getArtifactId())) continue;
            this.getLog().debug((CharSequence)"Component inside ignore list");
            return false;
        }
        if (this.project.getArtifactId().startsWith("camel-test") || this.project.getArtifactId().startsWith("camel-testng")) {
            this.getLog().debug((CharSequence)"Test components are ignored");
            return false;
        }
        if (this.project.getPackaging() != null && !this.project.getPackaging().equals("jar")) {
            this.getLog().debug((CharSequence)"Ignored for wrong packaging");
            return false;
        }
        if (this.baseDir.getName().equals("camel-core")) {
            return true;
        }
        if (this.baseDir.getParentFile().getName().equals("components") || this.baseDir.getName().endsWith("-component")) {
            return true;
        }
        this.getLog().debug((CharSequence)"Component directory mismatch");
        return false;
    }

    private String getComponentId() {
        String componentName = this.project.getArtifact().getArtifactId();
        String componentId = componentName.replace("camel-", "");
        return componentId;
    }

    private void writeXmlFormatted(Document pom, File destination) throws Exception {
        String content;
        XPathExpression xpath = XPathFactory.newInstance().newXPath().compile("//text()[normalize-space(.) = '']");
        NodeList emptyNodes = (NodeList)xpath.evaluate(pom, XPathConstants.NODESET);
        for (int i = 0; i < emptyNodes.getLength(); ++i) {
            Node emptyNode = emptyNodes.item(i);
            emptyNode.getParentNode().removeChild(emptyNode);
        }
        pom.setXmlStandalone(true);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(pom);
        try (StringWriter out = new StringWriter();){
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            content = out.toString();
        }
        content = content.replaceFirst("-->", "-->\n").replaceFirst("\\?><!--", "\\?>\n<!--");
        this.writeIfChanged(content, destination);
    }

    private void writeIfChanged(String content, File file) throws IOException {
        Throwable throwable;
        boolean write = true;
        if (file.exists()) {
            throwable = null;
            try (FileReader fr = new FileReader(file);){
                String oldContent = IOUtils.toString((Reader)fr);
                if (!content.equals(oldContent)) {
                    this.getLog().debug((CharSequence)("Writing new file " + file.getAbsolutePath()));
                    fr.close();
                }
                this.getLog().debug((CharSequence)("File " + file.getAbsolutePath() + " has been left unchanged"));
                write = false;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        } else {
            File parent = file.getParentFile();
            parent.mkdirs();
        }
        if (write) {
            throwable = null;
            try (FileWriter fw = new FileWriter(file);){
                IOUtils.write((String)content, (Writer)fw);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }
}

