/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.BufferedWriter;
import java.io.IOError;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Objects;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    public static final String GENERATED_MSG = "Generated by camel build tools";
    public static final String NL = "\n";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected BuildContext buildContext;

    protected void addResourceDirectory(Path path) {
        this.projectHelper.addResource(this.project, path.toString(), Collections.singletonList("**/*"), Collections.emptyList());
    }

    public void refresh(Path file) {
        AbstractGeneratorMojo.refresh(this.buildContext, file);
    }

    protected void updateResource(Path out, String data) {
        AbstractGeneratorMojo.updateResource(this.buildContext, out, data);
    }

    protected String createProperties(String key, String val) {
        return AbstractGeneratorMojo.createProperties(this.project, key, val);
    }

    public static String createProperties(MavenProject project, String key, String val) {
        StringBuilder properties = new StringBuilder();
        properties.append("# Generated by camel build tools\n");
        properties.append(key).append("=").append(val).append(NL);
        properties.append("groupId=").append(project.getGroupId()).append(NL);
        properties.append("artifactId=").append(project.getArtifactId()).append(NL);
        properties.append("version=").append(project.getVersion()).append(NL);
        properties.append("projectName=").append(project.getName()).append(NL);
        if (project.getDescription() != null) {
            properties.append("projectDescription=").append(project.getDescription()).append(NL);
        }
        String data = properties.toString();
        return data;
    }

    public static void refresh(BuildContext buildContext, Path file) {
        if (buildContext != null) {
            buildContext.refresh(file.toFile());
        }
    }

    public static void updateResource(BuildContext buildContext, Path out, String data) {
        block17: {
            try {
                String content;
                if (data == null) {
                    if (Files.isRegularFile(out, new LinkOption[0])) {
                        Files.delete(out);
                        AbstractGeneratorMojo.refresh(buildContext, out);
                    }
                    break block17;
                }
                if (Files.isRegularFile(out, new LinkOption[0]) && Files.isReadable(out) && Objects.equals(content = new String(Files.readAllBytes(out), StandardCharsets.UTF_8), data)) {
                    return;
                }
                Files.createDirectories(out.getParent(), new FileAttribute[0]);
                try (BufferedWriter w = Files.newBufferedWriter(out, StandardCharsets.UTF_8, new OpenOption[0]);){
                    w.append(data);
                }
                AbstractGeneratorMojo.refresh(buildContext, out);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }
}

