/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-languages-list", threadSafe=true)
public class PackageLanguageMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/generated/camel/languages")
    protected File languageOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes")
    protected File schemaOutDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageLanguageMojo.prepareLanguage(this.getLog(), this.project, this.projectHelper, this.languageOutDir, this.schemaOutDir, this.buildContext);
    }

    public static int prepareLanguage(Log log, MavenProject project, MavenProjectHelper projectHelper, File languageOutDir, File schemaOutDir, BuildContext buildContext) throws MojoExecutionException {
        int count;
        StringBuilder buffer;
        File camelMetaDir;
        block20: {
            String javaType;
            File[] files;
            camelMetaDir = new File(languageOutDir, "META-INF/services/org/apache/camel/");
            if (projectHelper != null) {
                projectHelper.addResource(project, languageOutDir.getPath(), Collections.singletonList("**/language.properties"), Collections.emptyList());
            }
            if (!PackageHelper.haveResourcesChanged(log, project, buildContext, "META-INF/services/org/apache/camel/language")) {
                return 0;
            }
            HashMap<String, String> javaTypes = new HashMap<String, String>();
            buffer = new StringBuilder();
            count = 0;
            File f = new File(project.getBasedir(), "target/classes");
            if ((f = new File(f, "META-INF/services/org/apache/camel/language")).exists() && f.isDirectory() && (files = f.listFiles()) != null) {
                for (File file : files) {
                    javaType = PackageLanguageMojo.readClassFromCamelResource(file, buffer, buildContext);
                    if (!file.isDirectory() && file.getName().charAt(0) != '.') {
                        ++count;
                    }
                    if (javaType == null) continue;
                    javaTypes.put(file.getName(), javaType);
                }
            }
            boolean apacheCamel = "org.apache.camel".equals(project.getGroupId());
            try {
                if (!apacheCamel || count <= 0) break block20;
                File core = PackageHelper.findCamelCoreDirectory(project.getBasedir());
                if (core != null) {
                    for (Map.Entry entry : javaTypes.entrySet()) {
                        String name = (String)entry.getKey();
                        javaType = (String)entry.getValue();
                        String modelName = PackageLanguageMojo.asModelName(name);
                        FileInputStream is = new FileInputStream(new File(core, "target/classes/org/apache/camel/model/language/" + modelName + ".json"));
                        String json = PackageHelper.loadText(is);
                        LanguageModel languageModel = new LanguageModel();
                        languageModel.setName(name);
                        languageModel.setTitle("");
                        languageModel.setModelName(modelName);
                        languageModel.setLabel("");
                        languageModel.setDescription("");
                        languageModel.setJavaType(javaType);
                        languageModel.setGroupId(project.getGroupId());
                        languageModel.setArtifactId(project.getArtifactId());
                        languageModel.setVersion(project.getVersion());
                        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
                        for (Map<String, String> row : rows) {
                            if (row.containsKey("title")) {
                                String title = PackageLanguageMojo.asTitle(name, row.get("title"));
                                languageModel.setTitle(title);
                            }
                            if (row.containsKey("description")) {
                                String desc = PackageLanguageMojo.asDescription(name, row.get("description"));
                                languageModel.setDescription(desc);
                            }
                            if (row.containsKey("label")) {
                                languageModel.setLabel(row.get("label"));
                            }
                            if (row.containsKey("deprecated")) {
                                languageModel.setDeprecated(row.get("deprecated"));
                            }
                            if (row.containsKey("deprecationNote")) {
                                languageModel.setDeprecationNote(row.get("deprecationNote"));
                            }
                            if (row.containsKey("javaType")) {
                                languageModel.setModelJavaType(row.get("javaType"));
                            }
                            if (!row.containsKey("firstVersion")) continue;
                            languageModel.setFirstVersion(row.get("firstVersion"));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((CharSequence)("Model: " + languageModel));
                        }
                        String properties = PackageHelper.after(json, "  \"properties\": {");
                        String schema = PackageLanguageMojo.createParameterJsonSchema(languageModel, properties);
                        if (log.isDebugEnabled()) {
                            log.debug((CharSequence)("JSon schema\n" + schema));
                        }
                        Path out = schemaOutDir.toPath().resolve(PackageLanguageMojo.schemaSubDirectory(languageModel.getJavaType())).resolve(name + ".json");
                        PackageLanguageMojo.updateResource(buildContext, out, schema);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((CharSequence)("Generated " + out + " containing JSon schema for " + name + " language"));
                    }
                    break block20;
                }
                throw new MojoExecutionException("Error finding core/camel-core/target/camel-core-" + project.getVersion() + ".jar file. Make sure camel-core has been built first.");
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error loading language model from camel-core. Reason: " + e, e);
            }
        }
        if (count > 0) {
            String names = buffer.toString();
            Path outFile = camelMetaDir.toPath().resolve("language.properties");
            String properties = PackageLanguageMojo.createProperties(project, "languages", names);
            PackageLanguageMojo.updateResource(buildContext, outFile, properties);
            log.info((CharSequence)("Generated " + outFile + " containing " + count + " Camel " + (count > 1 ? "languages: " : "language: ") + names));
        } else {
            log.debug((CharSequence)"No META-INF/services/org/apache/camel/language directory found. Are you sure you have created a Camel language?");
        }
        return count;
    }

    private static String readClassFromCamelResource(File file, StringBuilder buffer, BuildContext buildContext) throws MojoExecutionException {
        if (file.isDirectory()) {
            return null;
        }
        String name = file.getName();
        if (name.charAt(0) != '.') {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(name);
        }
        if (!buildContext.hasDelta(file)) {
            return null;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            Map<String, String> map = PackageHelper.parseAsMap(text);
            return map.get("class");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read file " + file + ". Reason: " + e, (Exception)e);
        }
    }

    private static String asModelName(String name) {
        if ("bean".equals(name)) {
            return "method";
        }
        if ("file".equals(name)) {
            return "simple";
        }
        return name;
    }

    private static String asTitle(String name, String title) {
        if ("file".equals(name)) {
            return "File";
        }
        return title;
    }

    private static String asDescription(String name, String description) {
        if ("file".equals(name)) {
            return "For expressions and predicates using the file/simple language";
        }
        return description;
    }

    private static String schemaSubDirectory(String javaType) {
        int idx = javaType.lastIndexOf(46);
        String pckName = javaType.substring(0, idx);
        return pckName.replace('.', '/');
    }

    private static String createParameterJsonSchema(LanguageModel languageModel, String schema) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"language\": {");
        buffer.append("\n    \"name\": \"").append(languageModel.getName()).append("\",");
        buffer.append("\n    \"kind\": \"").append("language").append("\",");
        buffer.append("\n    \"modelName\": \"").append(languageModel.getModelName()).append("\",");
        if (languageModel.getTitle() != null) {
            buffer.append("\n    \"title\": \"").append(languageModel.getTitle()).append("\",");
        }
        if (languageModel.getDescription() != null) {
            buffer.append("\n    \"description\": \"").append(languageModel.getDescription()).append("\",");
        }
        boolean deprecated = "true".equals(languageModel.getDeprecated());
        buffer.append("\n    \"deprecated\": ").append(deprecated).append(",");
        if (languageModel.getFirstVersion() != null) {
            buffer.append("\n    \"firstVersion\": \"").append(languageModel.getFirstVersion()).append("\",");
        }
        buffer.append("\n    \"label\": \"").append(languageModel.getLabel()).append("\",");
        buffer.append("\n    \"javaType\": \"").append(languageModel.getJavaType()).append("\",");
        if (languageModel.getModelJavaType() != null) {
            buffer.append("\n    \"modelJavaType\": \"").append(languageModel.getModelJavaType()).append("\",");
        }
        buffer.append("\n    \"groupId\": \"").append(languageModel.getGroupId()).append("\",");
        buffer.append("\n    \"artifactId\": \"").append(languageModel.getArtifactId()).append("\",");
        buffer.append("\n    \"version\": \"").append(languageModel.getVersion()).append("\"");
        buffer.append("\n  },");
        buffer.append("\n  \"properties\": {");
        buffer.append(schema);
        return buffer.toString();
    }

    private static class LanguageModel {
        private String name;
        private String title;
        private String modelName;
        private String description;
        private String firstVersion;
        private String label;
        private String deprecated;
        private String deprecationNote;
        private String javaType;
        private String modelJavaType;
        private String groupId;
        private String artifactId;
        private String version;

        private LanguageModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public String getModelJavaType() {
            return this.modelJavaType;
        }

        public void setModelJavaType(String modelJavaType) {
            this.modelJavaType = modelJavaType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getFirstVersion() {
            return this.firstVersion;
        }

        public void setFirstVersion(String firstVersion) {
            this.firstVersion = firstVersion;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(String deprecated) {
            this.deprecated = deprecated;
        }

        public String getDeprecationNote() {
            return this.deprecationNote;
        }

        public void setDeprecationNote(String deprecationNote) {
            this.deprecationNote = deprecationNote;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "LanguageModel[name='" + this.name + '\'' + ", modelName='" + this.modelName + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", label='" + this.label + '\'' + ", javaType='" + this.javaType + '\'' + ", modelJavaType='" + this.modelJavaType + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ']';
        }
    }
}

