/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-legal", threadSafe=true, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class PackageLegalMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/classes")
    protected File legalOutDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.processLegal(this.legalOutDir.toPath());
    }

    public void processLegal(Path legalOutDir) throws MojoExecutionException {
        Throwable throwable;
        if (!"org.apache.camel".equals(this.project.getGroupId())) {
            return;
        }
        try {
            throwable = null;
            try (InputStream isLicense = ((Object)((Object)this)).getClass().getResourceAsStream("/camel-LICENSE.txt");){
                String license = IOUtils.toString((InputStream)isLicense, (Charset)StandardCharsets.UTF_8);
                this.updateResource(legalOutDir.resolve("META-INF").resolve("LICENSE.txt"), license);
            }
            catch (Throwable license) {
                throwable = license;
                throw license;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write legal files. Reason: " + e, (Exception)e);
        }
        try {
            throwable = null;
            try (InputStream isNotice = ((Object)((Object)this)).getClass().getResourceAsStream("/camel-NOTICE.txt");){
                String notice = IOUtils.toString((InputStream)isNotice, (Charset)StandardCharsets.UTF_8);
                this.updateResource(legalOutDir.resolve("META-INF").resolve("NOTICE.txt"), notice);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write legal files. Reason: " + e, (Exception)e);
        }
    }
}

