/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.camel.maven.packaging.UpdateReadmeMojo;
import org.apache.camel.maven.packaging.model.ComponentModel;
import org.apache.camel.maven.packaging.model.DataFormatModel;
import org.apache.camel.maven.packaging.model.EipModel;
import org.apache.camel.maven.packaging.model.LanguageModel;
import org.apache.camel.maven.packaging.model.OtherModel;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.mvel2.templates.TemplateRuntime;

@Mojo(name="prepare-readme", threadSafe=true)
public class PrepareReadmeMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/models")
    protected File eipsDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/components")
    protected File componentsDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/dataformats")
    protected File dataFormatsDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/languages")
    protected File languagesDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/others")
    protected File othersDir;
    @Parameter(defaultValue="${project.directory}/../../../core/camel-core")
    protected File readmeCoreDir;
    @Parameter(defaultValue="${project.directory}/../../../components")
    protected File readmeComponentsDir;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeEipsReadme();
        this.executeComponentsReadme(true);
        this.executeDataFormatsReadme(true);
        this.executeLanguagesReadme(true);
        this.executeComponentsReadme(false);
        this.executeOthersReadme();
        this.executeDataFormatsReadme(false);
        this.executeLanguagesReadme(false);
    }

    protected void executeEipsReadme() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> eipFiles = new TreeSet<File>();
        if (this.eipsDir != null && this.eipsDir.isDirectory() && (files = this.eipsDir.listFiles()) != null) {
            eipFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<EipModel> models = new ArrayList<EipModel>();
            for (File file : eipFiles) {
                String json = PackageHelper.loadText(new FileInputStream(file));
                EipModel model = this.generateEipModel(json);
                if (!model.getLabel().startsWith("eip")) continue;
                models.add(model);
            }
            Collections.sort(models, new EipComparator());
            long deprecated = models.stream().filter(EipModel::isDeprecated).count();
            File file = new File(this.readmeCoreDir, "readme-eip.adoc");
            boolean exists = file.exists();
            String changed = this.templateEips(models, deprecated);
            boolean updated = this.updateEips(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated readme-eip.adoc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to readme-eip.adoc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No readme-eip.adoc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeComponentsReadme(boolean coreOnly) throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> componentFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (files = this.componentsDir.listFiles()) != null) {
            componentFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<ComponentModel> models = new ArrayList<ComponentModel>();
            for (File file : componentFiles) {
                String json = PackageHelper.loadText(new FileInputStream(file));
                ComponentModel model = this.generateComponentModel(json, coreOnly);
                boolean add = true;
                if (!model.getAlternativeSchemes().isEmpty()) {
                    String first = model.getAlternativeSchemes().split(",")[0];
                    if (!model.getScheme().equals(first)) {
                        add = false;
                    }
                }
                if (!add) continue;
                models.add(model);
                if (!"imap".equals(model.getScheme())) continue;
                model.setScheme("mail");
                model.setTitle("Mail");
            }
            Collections.sort(models, new ComponentComparator());
            ArrayList<ComponentModel> components = new ArrayList<ComponentModel>();
            for (ComponentModel model : models) {
                if (coreOnly) {
                    if (!"camel-core".equals(model.getArtifactId())) continue;
                    components.add(model);
                    continue;
                }
                components.add(model);
            }
            int n = components.stream().map(ComponentModel::getArtifactId).collect(Collectors.toSet()).size();
            long deprecated = components.stream().filter(c -> "true".equals(c.getDeprecated())).count();
            File file = coreOnly ? new File(this.readmeCoreDir, "readme.adoc") : new File(this.readmeComponentsDir, "readme.adoc");
            boolean exists = file.exists();
            String changed = this.templateComponents(components, n, deprecated);
            boolean updated = this.updateComponents(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated readme.adoc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to readme.adoc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No readme.adoc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeOthersReadme() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> otherFiles = new TreeSet<File>();
        if (this.othersDir != null && this.othersDir.isDirectory() && (files = this.othersDir.listFiles()) != null) {
            otherFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<OtherModel> others = new ArrayList<OtherModel>();
            for (File file : otherFiles) {
                String json = PackageHelper.loadText(new FileInputStream(file));
                OtherModel model = this.generateOtherModel(json);
                others.add(model);
            }
            Collections.sort(others, new OtherComparator());
            int count = others.stream().map(OtherModel::getArtifactId).collect(Collectors.toSet()).size();
            long deprecated = others.stream().filter(o -> "true".equals(o.getDeprecated())).count();
            File file = new File(this.readmeComponentsDir, "readme.adoc");
            boolean exists = file.exists();
            String changed = this.templateOthers(others, count, deprecated);
            boolean updated = this.updateOthers(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated readme.adoc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to readme.adoc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No readme.adoc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeDataFormatsReadme(boolean coreOnly) throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> dataFormatFiles = new TreeSet<File>();
        if (this.dataFormatsDir != null && this.dataFormatsDir.isDirectory() && (files = this.dataFormatsDir.listFiles()) != null) {
            dataFormatFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<DataFormatModel> models = new ArrayList<DataFormatModel>();
            for (File file : dataFormatFiles) {
                String json = PackageHelper.loadText(new FileInputStream(file));
                DataFormatModel model = this.generateDataFormatModel(json, coreOnly);
                if (model.getName().startsWith("bindy")) {
                    model.setName("bindy");
                }
                models.add(model);
            }
            Collections.sort(models, new DataFormatComparator());
            int count = models.stream().map(DataFormatModel::getArtifactId).collect(Collectors.toSet()).size();
            long deprecated = models.stream().filter(m -> "true".equals(m.getDeprecated())).count();
            ArrayList<DataFormatModel> dataFormats = new ArrayList<DataFormatModel>();
            for (DataFormatModel model : models) {
                if (coreOnly) {
                    if (!"camel-core".equals(model.getArtifactId())) continue;
                    dataFormats.add(model);
                    continue;
                }
                dataFormats.add(model);
            }
            File file = coreOnly ? new File(this.readmeCoreDir, "readme.adoc") : new File(this.readmeComponentsDir, "readme.adoc");
            boolean exists = file.exists();
            String changed = this.templateDataFormats(dataFormats, count, deprecated);
            boolean updated = this.updateDataFormats(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated readme.adoc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to readme.adoc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No readme.adoc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeLanguagesReadme(boolean coreOnly) throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> languageFiles = new TreeSet<File>();
        if (this.languagesDir != null && this.languagesDir.isDirectory() && (files = this.languagesDir.listFiles()) != null) {
            languageFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<LanguageModel> models = new ArrayList<LanguageModel>();
            for (File file : languageFiles) {
                String json = PackageHelper.loadText(new FileInputStream(file));
                LanguageModel model = this.generateLanguageModel(json, coreOnly);
                models.add(model);
            }
            Collections.sort(models, new LanguageComparator());
            ArrayList<LanguageModel> languages = new ArrayList<LanguageModel>();
            for (LanguageModel model : models) {
                if (coreOnly) {
                    if (!"camel-core".equals(model.getArtifactId())) continue;
                    languages.add(model);
                    continue;
                }
                languages.add(model);
            }
            int n = languages.stream().map(LanguageModel::getArtifactId).collect(Collectors.toSet()).size();
            long deprecated = languages.stream().filter(l -> "true".equals(l.getDeprecated())).count();
            File file = coreOnly ? new File(this.readmeCoreDir, "readme.adoc") : new File(this.readmeComponentsDir, "readme.adoc");
            boolean exists = file.exists();
            String changed = this.templateLanguages(languages, n, deprecated);
            boolean updated = this.updateLanguages(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated readme.adoc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to readme.adoc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No readme.adoc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    private String templateEips(List<EipModel> models, long deprecated) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("readme-eips.mvel"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("eips", models);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateComponents(List<ComponentModel> models, int artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("readme-components.mvel"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("components", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateOthers(List<OtherModel> models, int artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("readme-others.mvel"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("others", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateDataFormats(List<DataFormatModel> models, int artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("readme-dataformats.mvel"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataformats", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateLanguages(List<LanguageModel> models, int artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("readme-languages.mvel"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("languages", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private boolean updateEips(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// eips: START", "// eips: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// eips: START");
                String after = StringHelper.after(text, "// eips: END");
                text = before + "// eips: START\n" + changed + "\n// eips: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// eips: START");
            this.getLog().warn((CharSequence)"\t// eips: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateComponents(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// components: START", "// components: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// components: START");
                String after = StringHelper.after(text, "// components: END");
                text = before + "// components: START\n" + changed + "\n// components: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// components: START");
            this.getLog().warn((CharSequence)"\t// components: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateOthers(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// others: START", "// others: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// others: START");
                String after = StringHelper.after(text, "// others: END");
                text = before + "// others: START\n" + changed + "\n// others: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// others: START");
            this.getLog().warn((CharSequence)"\t// others: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateDataFormats(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// dataformats: START", "// dataformats: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// dataformats: START");
                String after = StringHelper.after(text, "// dataformats: END");
                text = before + "// dataformats: START\n" + changed + "\n// dataformats: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// dataformats: START");
            this.getLog().warn((CharSequence)"\t// dataformats: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateLanguages(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// languages: START", "// languages: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// languages: START");
                String after = StringHelper.after(text, "// languages: END");
                text = before + "// languages: START\n" + changed + "\n// languages: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// languages: START");
            this.getLog().warn((CharSequence)"\t// languages: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private EipModel generateEipModel(String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
        EipModel eip = new EipModel();
        eip.setName(JSonSchemaHelper.getSafeValue("name", rows));
        eip.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        eip.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        eip.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        eip.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        eip.setDeprecated("true".equals(JSonSchemaHelper.getSafeValue("deprecated", rows)));
        eip.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        eip.setInput("true".equals(JSonSchemaHelper.getSafeValue("input", rows)));
        eip.setOutput("true".equals(JSonSchemaHelper.getSafeValue("output", rows)));
        return eip;
    }

    private ComponentModel generateComponentModel(String json, boolean coreOnly) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        ComponentModel component = new ComponentModel(coreOnly);
        component.setScheme(JSonSchemaHelper.getSafeValue("scheme", rows));
        component.setSyntax(JSonSchemaHelper.getSafeValue("syntax", rows));
        component.setAlternativeSyntax(JSonSchemaHelper.getSafeValue("alternativeSyntax", rows));
        component.setAlternativeSchemes(JSonSchemaHelper.getSafeValue("alternativeSchemes", rows));
        component.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        component.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        component.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        component.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        component.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        component.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        component.setConsumerOnly(JSonSchemaHelper.getSafeValue("consumerOnly", rows));
        component.setProducerOnly(JSonSchemaHelper.getSafeValue("producerOnly", rows));
        component.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        component.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        component.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        component.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        return component;
    }

    private OtherModel generateOtherModel(String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("other", json, false);
        OtherModel other = new OtherModel();
        other.setName(JSonSchemaHelper.getSafeValue("name", rows));
        other.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        other.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        other.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        other.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        other.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        other.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        other.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        other.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        other.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        return other;
    }

    private DataFormatModel generateDataFormatModel(String json, boolean coreOnly) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
        DataFormatModel dataFormat = new DataFormatModel(coreOnly);
        dataFormat.setName(JSonSchemaHelper.getSafeValue("name", rows));
        dataFormat.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        dataFormat.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        dataFormat.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        dataFormat.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        dataFormat.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        dataFormat.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        dataFormat.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        dataFormat.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        dataFormat.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        dataFormat.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        dataFormat.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        return dataFormat;
    }

    private LanguageModel generateLanguageModel(String json, boolean coreOnly) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
        LanguageModel language = new LanguageModel(coreOnly);
        language.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        language.setName(JSonSchemaHelper.getSafeValue("name", rows));
        language.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        language.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        language.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        language.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        language.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        language.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        language.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        language.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        language.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        language.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        return language;
    }

    private static class LanguageComparator
    implements Comparator<LanguageModel> {
        private LanguageComparator() {
        }

        @Override
        public int compare(LanguageModel o1, LanguageModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }

    private static class DataFormatComparator
    implements Comparator<DataFormatModel> {
        private DataFormatComparator() {
        }

        @Override
        public int compare(DataFormatModel o1, DataFormatModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }

    private static class OtherComparator
    implements Comparator<OtherModel> {
        private OtherComparator() {
        }

        @Override
        public int compare(OtherModel o1, OtherModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }

    private static class ComponentComparator
    implements Comparator<ComponentModel> {
        private ComponentComparator() {
        }

        @Override
        public int compare(ComponentModel o1, ComponentModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }

    private static class EipComparator
    implements Comparator<EipModel> {
        private EipComparator() {
        }

        @Override
        public int compare(EipModel o1, EipModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }
}

